/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.util;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.app.searchbar.SearchBar;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.searchbar.SearchOptionsSelectionNotifier;
import oracle.olap.app.util.FetchIcon;

public class TextViewerDialog
extends JDialog
implements MouseListener {
    private JTextPane textPane;
    private boolean isEditable = false;
    private JLabel saveButton;
    private JLabel copyButton;
    private JTextField tf;
    private final Highlighter highlighter = new DefaultHighlighter();
    private int highlightStart = 0;
    private SearchBar searchBar;
    private final int SEARCH_FWD = 1;
    private final int SEARCH_BCK = 2;
    private int lastSearchDir = 0;
    private final String WORD_MATCH = "(\\W*)\\w(\\W)";
    private final int UP_KEY = 38;
    private final int DOWN_KEY = 40;
    private JPopupMenu notFoundTextPopup;
    private Resources resources;
    private FetchIcon fetchIcon;
    private ErrorDisplay errorDisplay;
    private Logger logger;
    private final String SEARCH_FORWARD = "searchfwd";
    private final String SEARCH_BACKWARD = "searchbck";
    private final String DEFAULT_FONT = "Courier New";

    public TextViewerDialog(Frame frame, String string, String string2, Resources resources, FetchIcon fetchIcon, ErrorDisplay errorDisplay, Logger logger) {
        this(frame, string, true, string2, resources, fetchIcon, errorDisplay, logger);
    }

    public TextViewerDialog(Frame frame, String string, boolean bl, String string2, Resources resources, FetchIcon fetchIcon, ErrorDisplay errorDisplay, Logger logger) {
        this(frame, string, bl, string2, false, resources, fetchIcon, errorDisplay, logger);
    }

    public TextViewerDialog(Frame frame, String string, boolean bl, String string2, boolean bl2, Resources resources, FetchIcon fetchIcon, ErrorDisplay errorDisplay, Logger logger) {
        super(frame, string, bl);
        this.setLocation(200, 200);
        this.isEditable = bl2;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.errorDisplay = errorDisplay;
        this.logger = logger;
        try {
            this.jbInit(string2);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public TextViewerDialog(JDialog jDialog, String string, boolean bl, String string2, boolean bl2, Resources resources, FetchIcon fetchIcon, ErrorDisplay errorDisplay, Logger logger) {
        super(jDialog, string, bl);
        this.setLocation(200, 200);
        this.isEditable = bl2;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.errorDisplay = errorDisplay;
        this.logger = logger;
        try {
            this.jbInit(string2);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit(String string) throws Exception {
        this.setSize(new Dimension(500, 400));
        this.getContentPane().setLayout(new GridLayout(1, 1, 5, 5));
        StyleContext styleContext = new StyleContext();
        Style style = styleContext.getStyle("default");
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        defaultStyledDocument.insertString(0, string, style);
        this.textPane = new JTextPane(defaultStyledDocument);
        this.textPane.setEditable(this.isEditable);
        Font font = this.textPane.getFont();
        Font font2 = new Font("Courier New", font.getStyle(), font.getSize());
        this.textPane.setFont(font2);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.textPane);
        ImageIcon imageIcon = (ImageIcon)this.fetchIcon.getIcon("SAVE_ENABLE");
        this.tf = new JTextField();
        Dimension dimension = this.tf.getPreferredSize();
        dimension.setSize(200.0, dimension.getHeight());
        this.tf.setPreferredSize(dimension);
        JButton jButton = new JButton(this.resources.getString("DIALOG_FIND"));
        this.getRootPane().setDefaultButton(jButton);
        this.notFoundTextPopup = new JPopupMenu();
        this.saveButton = new JLabel(imageIcon);
        this.saveButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.saveButton.setToolTipText(this.resources.getString("TEXTVIEWER_DIALOG_SAVE_TEXT_TO_FILE"));
        this.saveButton.addMouseListener(this);
        imageIcon = (ImageIcon)this.fetchIcon.getIcon("COPY_ENABLE");
        this.copyButton = new JLabel(imageIcon);
        this.copyButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.copyButton.setToolTipText(this.resources.getString("TEXTVIEWER_DIALOG_COPY_TEXT_TO_CLIPBOARD"));
        this.copyButton.addMouseListener(this);
        SearchOptions searchOptions = new SearchOptions(this.resources);
        this.searchBar = new SearchBar(searchOptions, this.fetchIcon, this.resources);
        this.searchBar.setSearchOptionsSelectionNotifier(new SearchOptionsSelectionNotifier(){

            @Override
            public void optionSelected(String string) {
                if (string.equalsIgnoreCase(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES")) && TextViewerDialog.this.searchBar.isOptionSelected(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"))) {
                    try {
                        TextViewerDialog.this.highlightAllOccurrences();
                    }
                    catch (BadLocationException badLocationException) {
                        TextViewerDialog.this.showError(badLocationException);
                    }
                } else if (string.equalsIgnoreCase(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) && TextViewerDialog.this.searchBar.isOptionSelected(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) || string.equalsIgnoreCase(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD")) && TextViewerDialog.this.searchBar.isOptionSelected(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"))) {
                    try {
                        TextViewerDialog.this.highlightText(new ActionEvent(this, 0, "searchfwd"));
                    }
                    catch (BadLocationException badLocationException) {
                        TextViewerDialog.this.showError(badLocationException);
                    }
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this.searchBar);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 1, 1));
        jPanel4.add(this.saveButton);
        jPanel4.add(this.copyButton);
        jPanel3.add((Component)jPanel4, "West");
        jPanel2.add(jPanel3);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add(jPanel);
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 83) {
                    try {
                        TextViewerDialog.this.saveFile();
                    }
                    catch (IOException iOException) {
                        TextViewerDialog.this.showError(iOException);
                    }
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
                    TextViewerDialog.this.copyToClipboard();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.searchBar.getSearchTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 40) {
                    TextViewerDialog.this.searchBar.showSearchOptionsMenu();
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 83) {
                    try {
                        TextViewerDialog.this.saveFile();
                    }
                    catch (IOException iOException) {
                        TextViewerDialog.this.showError(iOException);
                    }
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
                    TextViewerDialog.this.copyToClipboard();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TextViewerDialog.this.notFoundTextPopup.setVisible(false);
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        try {
                            TextViewerDialog.this.highlightText(new ActionEvent(this, 0, "searchfwd"));
                        }
                        catch (BadLocationException badLocationException) {
                            TextViewerDialog.this.showError(badLocationException);
                        }
                        break;
                    }
                    case 38: {
                        try {
                            TextViewerDialog.this.highlightText(new ActionEvent(this, 0, "searchbck"));
                        }
                        catch (BadLocationException badLocationException) {
                            TextViewerDialog.this.showError(badLocationException);
                        }
                        break;
                    }
                    default: {
                        try {
                            if (TextViewerDialog.this.searchBar.isOptionSelected(TextViewerDialog.this.resources.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"))) {
                                TextViewerDialog.this.highlightAllOccurrences();
                                break;
                            }
                            TextViewerDialog.this.highlightText(keyEvent);
                            break;
                        }
                        catch (BadLocationException badLocationException) {
                            TextViewerDialog.this.showError(badLocationException);
                        }
                    }
                }
            }
        });
        this.searchBar.getSearchFwdLabel().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    TextViewerDialog.this.notFoundTextPopup.setVisible(false);
                    TextViewerDialog.this.highlightText(new ActionEvent(this, 0, "searchfwd"));
                }
                catch (BadLocationException badLocationException) {
                    TextViewerDialog.this.showError(badLocationException);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.searchBar.getSearchBckLabel().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    TextViewerDialog.this.notFoundTextPopup.setVisible(false);
                    TextViewerDialog.this.highlightText(new ActionEvent(this, 0, "searchbck"));
                }
                catch (BadLocationException badLocationException) {
                    TextViewerDialog.this.showError(badLocationException);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.textPane.requestFocusInWindow();
    }

    private void highlightAllOccurrences() throws BadLocationException {
        String string = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        String string2 = this.searchBar.getText();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(228, 149, 228));
        if (string2.length() == 0) {
            if (this.highlighter.getHighlights().length > 0) {
                this.highlighter.removeAllHighlights();
            }
            this.highlightStart = 0;
            this.textPane.setSelectionStart(this.highlightStart);
            return;
        }
        int n = 0;
        this.highlightStart = 0;
        this.textPane.setSelectionStart(0);
        this.textPane.setHighlighter(this.highlighter);
        while (n >= 0) {
            n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2, this.highlightStart) : string.toLowerCase().indexOf(string2.toLowerCase(), this.highlightStart);
            if (n < 0) continue;
            if (this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"))) {
                String string3 = n - 1 > 0 ? string.substring(n - 1, n + string2.length() + 1) : string.substring(n, n + string2.length() + 1);
                Pattern pattern = Pattern.compile("(\\W*)\\w(\\W)");
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find()) {
                    this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
                }
            } else {
                this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
            }
            this.highlightStart = n + string2.length();
        }
        if (this.highlighter.getHighlights().length == 0) {
            this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
        }
    }

    private void highlightText(AWTEvent aWTEvent) throws BadLocationException {
        String string = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        String string2 = this.searchBar.getText();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.CYAN);
        if (string2.length() == 0) {
            if (this.highlighter.getHighlights().length > 0) {
                this.highlighter.removeAllHighlights();
            }
            this.highlightStart = 0;
            this.textPane.setSelectionStart(this.highlightStart);
            return;
        }
        if (aWTEvent instanceof KeyEvent) {
            int n;
            int n2 = this.textPane.getSelectionStart();
            if (n2 > 0) {
                n2 += string2.length();
            }
            int n3 = n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2, n2) : string.toLowerCase().indexOf(string2.toLowerCase(), n2);
            if (n == -1) {
                n2 = 0;
                int n4 = n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2, n2) : string.toLowerCase().indexOf(string2.toLowerCase(), n2);
            }
            if (n >= 0) {
                this.highlightStart = n + string2.length();
                this.textPane.setHighlighter(this.highlighter);
                if (this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"))) {
                    String string3 = n - 1 >= 0 ? string.substring(n - 1, n + string2.length() + 1) : string.substring(n, n + string2.length() + 1);
                    Pattern pattern = Pattern.compile("(\\W*)\\w(\\W)");
                    Matcher matcher = pattern.matcher(string3);
                    if (matcher.find()) {
                        this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
                    }
                } else {
                    this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
                }
            } else {
                this.highlightStart = 0;
                if (this.highlighter.getHighlights().length > 0) {
                    this.highlighter.removeAllHighlights();
                }
                this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
            }
        } else if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            this.textPane.setSelectionStart(this.highlightStart);
            this.textPane.setHighlighter(this.highlighter);
            if (actionEvent.getActionCommand().equalsIgnoreCase("searchfwd")) {
                int n = 0;
                n = this.lastSearchDir == 2 ? (this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2, this.highlightStart + 2 * string2.length()) : string.toLowerCase().indexOf(string2.toLowerCase(), this.highlightStart + 2 * string2.length())) : (this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2, this.highlightStart) : string.toLowerCase().indexOf(string2.toLowerCase(), this.highlightStart));
                if (n == -1) {
                    this.highlightStart = 0;
                    int n5 = n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.indexOf(string2) : string.toLowerCase().indexOf(string2.toLowerCase());
                    if (n >= 0) {
                        this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_WRAP_DOWN"));
                        this.lastSearchDir = 1;
                        return;
                    }
                }
                if (n >= 0) {
                    this.highlightStart = n + string2.length();
                    this.textPane.setHighlighter(this.highlighter);
                    this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
                    if (this.highlightStart >= 0) {
                        this.textPane.setCaretPosition(this.highlightStart);
                    } else {
                        this.textPane.setCaretPosition(0);
                    }
                } else {
                    this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
                }
                this.lastSearchDir = 1;
            } else if (actionEvent.getActionCommand().equalsIgnoreCase("searchbck")) {
                int n = 0;
                if (this.highlightStart <= 0) {
                    n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.lastIndexOf(string2, string.length()) : string.toLowerCase().lastIndexOf(string2.toLowerCase(), string.length());
                } else {
                    int n6 = n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.lastIndexOf(string2, this.highlightStart - string2.length() - 1) : string.toLowerCase().lastIndexOf(string2.toLowerCase(), this.highlightStart - string2.length() - 1);
                }
                if (n == -1) {
                    this.highlightStart = 0;
                    int n7 = n = this.searchBar.isOptionSelected(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) ? string.lastIndexOf(string2) : string.toLowerCase().lastIndexOf(string2.toLowerCase());
                    if (n >= 0) {
                        this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_WRAP_UP"));
                        return;
                    }
                }
                if (n >= 0) {
                    this.highlightStart = n - string2.length() - 1;
                    this.textPane.setHighlighter(this.highlighter);
                    this.highlighter.addHighlight(n, n + string2.length(), defaultHighlightPainter);
                    if (this.highlightStart >= 0) {
                        this.textPane.setCaretPosition(this.highlightStart);
                    } else {
                        this.textPane.setCaretPosition(0);
                        this.highlightStart = 1;
                    }
                } else {
                    this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
                }
                this.lastSearchDir = 2;
            }
        }
    }

    public String getText() {
        return this.textPane.getText();
    }

    private void showPopupMessage(String string) {
        int n;
        int n2 = this.notFoundTextPopup.getSubElements().length;
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                this.notFoundTextPopup.remove(0);
            }
        }
        if ((n = string.indexOf("\n")) > 0) {
            this.notFoundTextPopup.add(string.substring(0, n - 1));
            this.notFoundTextPopup.add(string.substring(n + 1, string.length()));
        } else {
            this.notFoundTextPopup.add(string);
        }
        this.notFoundTextPopup.show(this.searchBar, 0, this.searchBar.getY() + 20);
        this.notFoundTextPopup.setBorder(BorderFactory.createLineBorder(new Color(194, 210, 233)));
        MenuElement[] menuElementArray = this.notFoundTextPopup.getSubElements();
        UIManager.put("MenuItem.disabledForeground", Color.BLACK);
        for (int i = 0; i < menuElementArray.length; ++i) {
            menuElementArray[i].getComponent().setEnabled(false);
            menuElementArray[i].getComponent().setBackground(new Color(183, 203, 234));
        }
        this.searchBar.getSearchTextField().requestFocusInWindow();
    }

    private void saveFile() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            Object object;
            if (jFileChooser.getSelectedFile().exists()) {
                object = new JOptionPane();
                int n2 = JOptionPane.showConfirmDialog(this, this.resources.getString("TEXTVIEWER_DIALOG_OVERWRITE.FILE", jFileChooser.getSelectedFile().getName()), "", 0);
                if (n2 == 1) {
                    return;
                }
            }
            object = new FileWriter(jFileChooser.getSelectedFile());
            ((Writer)object).write(this.getText());
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
            this.showConfirmation(this.resources.getString("TEXTVIEWER_DIALOG_CONFIRM.FILE.SAVED", jFileChooser.getSelectedFile().getName()));
        }
    }

    private void showConfirmation(String string) {
        JOptionPane jOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(this, string);
    }

    private void copyToClipboard() {
        StringSelection stringSelection = new StringSelection(this.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public JTextPane getJTextPane() {
        return this.textPane;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.saveButton)) {
            try {
                this.saveFile();
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        } else if (mouseEvent.getSource().equals(this.copyButton)) {
            this.copyToClipboard();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.copyButton)) {
            this.copyButton.setIcon(this.fetchIcon.getIcon("COPY_DOWN"));
        } else if (mouseEvent.getSource().equals(this.saveButton)) {
            this.saveButton.setIcon(this.fetchIcon.getIcon("SAVE_DOWN"));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.copyButton)) {
            this.copyButton.setIcon(this.fetchIcon.getIcon("COPY_ENABLE"));
        } else if (mouseEvent.getSource().equals(this.saveButton)) {
            this.saveButton.setIcon(this.fetchIcon.getIcon("SAVE_ENABLE"));
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.copyButton)) {
            this.copyButton.setIcon(this.fetchIcon.getIcon("COPY_OVER"));
        } else if (mouseEvent.getSource().equals(this.saveButton)) {
            this.saveButton.setIcon(this.fetchIcon.getIcon("SAVE_OVER"));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.copyButton)) {
            this.copyButton.setIcon(this.fetchIcon.getIcon("COPY_ENABLE"));
        } else if (mouseEvent.getSource().equals(this.saveButton)) {
            this.saveButton.setIcon(this.fetchIcon.getIcon("SAVE_ENABLE"));
        }
    }

    private void showError(Exception exception) {
        this.logger.severe(exception.getMessage());
        this.errorDisplay.show(exception, this);
    }
}

