/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.olap.app.ui.GroupCheckBoxError;
import oracle.olap.app.ui.GroupCheckBoxModel;
import oracle.olap.app.ui.GroupCheckBoxObserver;
import oracle.olap.app.ui.GroupCheckBoxSelection;

public class GroupCheckBoxTable
extends JPanel
implements ActionListener {
    private GroupCheckBoxModel groupCheckBoxModel;
    private List<JLabel> columnLabels = new ArrayList<JLabel>();
    private List<GroupCheckBoxObserver> checkBoxObservers = new ArrayList<GroupCheckBoxObserver>();
    protected List<GroupCheckBox> groupCheckBoxes = new ArrayList<GroupCheckBox>();
    protected List<GroupCheckBoxSelection> checkBoxSelections = new ArrayList<GroupCheckBoxSelection>();
    protected GroupCheckBoxError errorCallback;
    private boolean enabled;
    private boolean showGraphics = true;
    private GridBagConstraints c;
    private JPanel bottomPanel;

    public GroupCheckBoxTable(GroupCheckBoxModel groupCheckBoxModel) {
        this.groupCheckBoxModel = groupCheckBoxModel;
    }

    public void setModel(GroupCheckBoxModel groupCheckBoxModel) {
        this.groupCheckBoxModel = groupCheckBoxModel;
    }

    public void setShowGraphics(boolean bl) {
        this.showGraphics = bl;
    }

    public void enableUI(boolean bl) {
        this.enabled = bl;
        for (GroupCheckBox groupCheckBox : this.groupCheckBoxes) {
            groupCheckBox.setEnabled(bl);
        }
        this.revalidate();
        this.repaint();
    }

    public void clearGroupCheckBoxTable() {
        for (JLabel jComponent : this.columnLabels) {
            this.remove(jComponent);
        }
        this.columnLabels.clear();
        for (JCheckBox jCheckBox : this.groupCheckBoxes) {
            this.remove(jCheckBox);
        }
        this.groupCheckBoxes.clear();
        for (Iterator<JComponent> iterator : this.getComponents()) {
            if (!iterator.equals(this.bottomPanel)) continue;
            this.remove((Component)((Object)iterator));
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void initialize(List<GroupCheckBoxSelection> list) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.anchor = 18;
        this.c.fill = 2;
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBackground(Color.WHITE);
        this.renderPanelComponents();
        this.initializeSelections(list);
    }

    public void renderPanelComponents() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.clearGroupCheckBoxTable();
        this.c.weighty = 0.0;
        this.c.gridwidth = 1;
        this.c.fill = 2;
        this.c.insets = new Insets(0, 0, 5, 0);
        this.c.weightx = 0.0;
        for (String string : this.groupCheckBoxModel.getColumnNames()) {
            this.c.gridx = n++;
            this.c.gridy = n2;
            JLabel jLabel = new JLabel(string);
            this.columnLabels.add(jLabel);
            JPanel object = new JPanel();
            object.setLayout(new GridLayout(1, 1));
            object.setBackground(Color.LIGHT_GRAY);
            object.add(jLabel);
            this.add((Component)object, this.c);
        }
        n = 0;
        n2 = 1;
        this.c.insets = new Insets(5, 15, 5, 5);
        for (String string : this.groupCheckBoxModel.getColumnNames()) {
            ++n4;
            for (String string2 : this.groupCheckBoxModel.getCheckBoxNamesForColumn(string)) {
                this.c.gridx = n;
                this.c.gridy = n2++;
                GroupCheckBox groupCheckBox = new GroupCheckBox(string2);
                groupCheckBox.columnName = string;
                groupCheckBox.checkBoxName = string2;
                groupCheckBox.setBackground(Color.WHITE);
                groupCheckBox.addActionListener(this);
                this.add((Component)groupCheckBox, this.c);
                this.groupCheckBoxes.add(groupCheckBox);
                if (n3 >= n2) continue;
                n3 = n2;
            }
            n2 = 1;
            ++n;
        }
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = n3;
        this.c.gridwidth = n4;
        this.c.fill = 1;
        this.add((Component)this.bottomPanel, this.c);
        this.revalidate();
        this.repaint();
    }

    private void initializeSelections(List<GroupCheckBoxSelection> list) {
        for (GroupCheckBoxSelection object : list) {
            this.setCheckBox(object.columnName, object.checkBoxName, true);
        }
        this.checkBoxSelections.clear();
        List<String> list2 = this.groupCheckBoxModel.getColumnNames();
        for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
            if (!list2.contains(groupCheckBoxSelection.columnName)) continue;
            this.checkBoxSelections.add(groupCheckBoxSelection);
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof GroupCheckBox) {
            GroupCheckBox groupCheckBox = (GroupCheckBox)actionEvent.getSource();
            if (groupCheckBox.isSelected()) {
                int n = this.groupCheckBoxModel.getMaxGroupSelections();
                if (this.checkBoxSelections.size() == n) {
                    groupCheckBox.setSelected(false);
                    if (this.errorCallback != null) {
                        this.errorCallback.reportErrorTooManySelections();
                    }
                    return;
                }
                this.checkBoxSelections = this.getCheckBoxSelections();
            } else {
                GroupCheckBoxSelection groupCheckBoxSelection = null;
                boolean bl = false;
                for (GroupCheckBoxSelection groupCheckBoxSelection2 : this.checkBoxSelections) {
                    if (!groupCheckBoxSelection2.columnName.equals(groupCheckBox.columnName) || !groupCheckBoxSelection2.checkBoxName.equals(groupCheckBox.checkBoxName)) continue;
                    bl = true;
                    groupCheckBoxSelection = groupCheckBoxSelection2;
                    break;
                }
                if (bl) {
                    this.checkBoxSelections.remove(groupCheckBoxSelection);
                }
            }
            this.updateObservers();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.groupCheckBoxModel == null) {
            return;
        }
        if (!this.showGraphics) {
            this.drawHorizontalLine(graphics);
            return;
        }
        if (!this.enabled) {
            return;
        }
        int n = 20;
        int n2 = 10;
        for (String string : this.groupCheckBoxModel.getColumnNames()) {
            List<String> list = this.getCheckBoxNamesSelectedForColumn(string);
            for (String string2 : list) {
                GroupCheckBox groupCheckBox = this.getCheckBoxForCheckBoxStart(string, string2);
                GroupCheckBox groupCheckBox2 = this.getCheckBoxForCheckBoxStop(string, string2);
                Point point = groupCheckBox.getLocation();
                Point point2 = null;
                point2 = groupCheckBox2 != null ? groupCheckBox2.getLocation() : point;
                double d = point.getX();
                double d2 = point.getY();
                int n3 = (int)d;
                int n4 = (int)d2;
                int n5 = n3 - n2;
                int n6 = n4;
                graphics.setColor(Color.BLACK);
                graphics.drawLine(n3, n4, n5, n6);
                double d3 = point2.getX();
                double d4 = point2.getY();
                int n7 = (int)d3;
                int n8 = (int)d4;
                int n9 = n7 - n2;
                int n10 = n8 += n;
                graphics.drawLine(n7, n8, n9, n10);
                graphics.drawLine(n9, n10, n5, n6);
            }
        }
        this.drawHorizontalLine(graphics);
    }

    private void drawHorizontalLine(Graphics graphics) {
        int n;
        Rectangle rectangle = this.getBounds();
        int n2 = (int)rectangle.getWidth();
        Rectangle rectangle2 = this.columnLabels.get(0).getBounds();
        int n3 = n = (int)rectangle2.getHeight();
        graphics.drawLine(0, n3, n2, n3);
    }

    public List<GroupCheckBoxSelection> getCheckBoxSelections() {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (String string : this.groupCheckBoxModel.getColumnNames()) {
            List<GroupCheckBoxSelection> list = this.getCheckBoxSelectionsForColumn(string);
            if (list.size() <= 0) continue;
            for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
                arrayList.add(groupCheckBoxSelection);
            }
        }
        return arrayList;
    }

    protected List<GroupCheckBoxSelection> getCheckBoxSelectionsForColumn(String string) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (GroupCheckBox groupCheckBox : this.groupCheckBoxes) {
            if (!groupCheckBox.columnName.equals(string) || !groupCheckBox.isSelected()) continue;
            GroupCheckBoxSelection groupCheckBoxSelection = new GroupCheckBoxSelection(groupCheckBox.columnName, groupCheckBox.checkBoxName);
            arrayList.add(0, groupCheckBoxSelection);
        }
        return arrayList;
    }

    protected JCheckBox getCheckBox(String string, String string2) {
        GroupCheckBox groupCheckBox = null;
        for (GroupCheckBox groupCheckBox2 : this.groupCheckBoxes) {
            if (!groupCheckBox2.columnName.equalsIgnoreCase(string) || !groupCheckBox2.checkBoxName.equalsIgnoreCase(string2)) continue;
            groupCheckBox = groupCheckBox2;
            break;
        }
        return groupCheckBox;
    }

    protected void setCheckBox(String string, String string2, boolean bl) {
        JCheckBox jCheckBox = this.getCheckBox(string, string2);
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    protected List<String> getCheckBoxNamesSelectedForColumn(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupCheckBox groupCheckBox : this.groupCheckBoxes) {
            if (!groupCheckBox.columnName.equals(string) || !groupCheckBox.isSelected()) continue;
            arrayList.add(groupCheckBox.checkBoxName);
        }
        return arrayList;
    }

    protected GroupCheckBox getCheckBoxForCheckBoxStart(String string, String string2) {
        GroupCheckBox groupCheckBox = null;
        for (GroupCheckBox groupCheckBox2 : this.groupCheckBoxes) {
            if (!groupCheckBox2.columnName.equals(string) || !groupCheckBox2.checkBoxName.equals(string2)) continue;
            groupCheckBox = groupCheckBox2;
            break;
        }
        return groupCheckBox;
    }

    protected GroupCheckBox getCheckBoxForCheckBoxStop(String string, String string2) {
        GroupCheckBox groupCheckBox = null;
        List<String> list = this.getCheckBoxesSelectedBelow(string, string2);
        if (list.size() > 0) {
            String string3 = null;
            String string4 = list.get(0);
            for (String string5 : this.groupCheckBoxModel.getCheckBoxNamesForColumn(string)) {
                if (string5.equals(string4)) {
                    groupCheckBox = string3 != null ? this.getCheckBoxForCheckBoxStart(string, string3) : null;
                    break;
                }
                string3 = string5;
            }
        } else {
            groupCheckBox = this.getCheckBoxAtBottomOfColumn(string);
        }
        return groupCheckBox;
    }

    protected List<String> getCheckBoxesSelectedBelow(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (GroupCheckBox groupCheckBox : this.groupCheckBoxes) {
            if (!groupCheckBox.columnName.equals(string) || !groupCheckBox.isSelected()) continue;
            if (bl) {
                arrayList.add(groupCheckBox.checkBoxName);
                continue;
            }
            if (!string2.equals(groupCheckBox.checkBoxName)) continue;
            bl = true;
        }
        return arrayList;
    }

    protected GroupCheckBox getCheckBoxAtBottomOfColumn(String string) {
        GroupCheckBox object = null;
        List<String> list = this.groupCheckBoxModel.getCheckBoxNamesForColumn(string);
        String string2 = null;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            String object2;
            string2 = object2 = iterator.next();
        }
        for (GroupCheckBox groupCheckBox : this.groupCheckBoxes) {
            if (!groupCheckBox.columnName.equals(string) || !groupCheckBox.checkBoxName.equals(string2)) continue;
            object = groupCheckBox;
        }
        return object;
    }

    public void registerObserver(GroupCheckBoxObserver groupCheckBoxObserver) {
        if (!this.checkBoxObservers.contains(groupCheckBoxObserver)) {
            this.checkBoxObservers.add(groupCheckBoxObserver);
        }
    }

    public void updateObservers() {
        for (GroupCheckBoxObserver groupCheckBoxObserver : this.checkBoxObservers) {
            groupCheckBoxObserver.update(this.checkBoxSelections);
        }
    }

    public void registerErrorCallback(GroupCheckBoxError groupCheckBoxError) {
        this.errorCallback = groupCheckBoxError;
    }

    protected class GroupCheckBox
    extends JCheckBox {
        protected String columnName;
        protected String checkBoxName;

        public GroupCheckBox(String string) {
            super(string);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getCheckBoxName() {
            return this.checkBoxName;
        }
    }
}

