/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.view;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    private final TristateDecorator model;

    public TristateCheckBox(String string, Icon icon, Boolean bl) {
        super(string, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(bl);
    }

    public TristateCheckBox(String string, Boolean bl) {
        this(string, (Icon)null, bl);
    }

    public TristateCheckBox(String string) {
        this(string, (Boolean)null);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    public void setState(Boolean bl) {
        this.model.setState(bl);
    }

    public Boolean getState() {
        return this.model.getState();
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame jFrame = new JFrame("TristateCheckBoxTest");
        jFrame.getContentPane().setLayout(new GridLayout(0, 1, 5, 5));
        TristateCheckBox tristateCheckBox = new TristateCheckBox("Testing the tristate checkbox");
        tristateCheckBox.setMnemonic('T');
        jFrame.getContentPane().add(tristateCheckBox);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private void setState(Boolean bl) {
            if (bl == Boolean.FALSE) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (bl == Boolean.TRUE) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private Boolean getState() {
            if (this.isSelected() && !this.isArmed()) {
                return Boolean.TRUE;
            }
            if (this.isSelected() && this.isArmed()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private void nextState() {
            Boolean bl = this.getState();
            if (bl == Boolean.FALSE) {
                this.setState(Boolean.TRUE);
            } else if (bl == Boolean.TRUE) {
                this.setState(null);
            } else if (bl == null) {
                this.setState(Boolean.FALSE);
            }
        }

        @Override
        public void setArmed(boolean bl) {
        }

        public boolean isFocusTraversable() {
            return this.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.other.setEnabled(bl);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        @Override
        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        @Override
        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        @Override
        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

