/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.model;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.loader.TreeLoader;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.NodeType;
import oracle.olap.app.tree.model.TreeChange;
import oracle.olap.app.tree.model.VirtualTreeModel;

public class Tree {
    private List<Node> roots = new ArrayList<Node>();
    private int count;
    private Node lastFoundNode;
    private List<String> levelNames = new ArrayList<String>();
    private TreeLoader treeLoader;
    private VirtualTreeModel treeModel;
    private List<TreeChange> treeChangeLog;
    private static int depthCount;

    public Tree(TreeLoader treeLoader, VirtualTreeModel virtualTreeModel) {
        this.treeLoader = treeLoader;
        this.treeModel = virtualTreeModel;
        this.treeChangeLog = new ArrayList<TreeChange>();
    }

    public Tree() {
        this.treeChangeLog = new ArrayList<TreeChange>();
    }

    public void setModel(VirtualTreeModel virtualTreeModel) {
        this.treeModel = virtualTreeModel;
    }

    public void setLevelNames(List<String> list) {
        this.levelNames.addAll(list);
    }

    public String getLevelName(int n) {
        if (n < this.levelNames.size()) {
            return this.levelNames.get(n);
        }
        return null;
    }

    public void addRoot(Node node) {
        this.roots.add(node);
    }

    public void removeRoot(Node node) {
        this.roots.remove(node);
    }

    public List<Node> getRoots() {
        return this.roots;
    }

    public boolean isMultipleRoots() {
        return this.roots.size() > 1;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    public List<TreeChange> getChanges() {
        return this.treeChangeLog;
    }

    public void logPropertyChange(Node node, String string) {
        this.treeChangeLog.add(new TreeChange(node, TreeChange.Type.SET_PROPERTY, string));
    }

    public void logNewNodeChange(Node node) {
        this.treeChangeLog.add(new TreeChange(node, TreeChange.Type.NEW));
    }

    public void moveNodeChange(Node node, Node node2) {
        for (TreeChange treeChange : this.treeChangeLog) {
            if (treeChange.getType() != TreeChange.Type.NEW || !treeChange.getNode().equals(node)) continue;
            treeChange.setNode2(node2);
            return;
        }
        this.treeChangeLog.add(new TreeChange(node, node2, TreeChange.Type.MOVE));
    }

    public void logRenameNode(Node node) {
        this.treeChangeLog.add(new TreeChange(node, TreeChange.Type.RENAME));
    }

    public void removeAllNode(Node node) {
        this.treeChangeLog.add(new TreeChange(node, TreeChange.Type.REMOVEALL));
        this.removeNodeAndChildren(node);
    }

    public void removeNode(Node node) {
        this.treeChangeLog.add(new TreeChange(node, TreeChange.Type.REMOVE));
        this.removeNodeOnly(node);
    }

    private void removeNodeAndChildren(Node node) {
        Node node2 = node.getParent();
        if (node2 != null) {
            node2.removeChild(node);
        } else {
            this.treeModel.removeNodeFromParent(node);
            this.removeRoot(node);
            List<Node> list = node.getChildren();
            for (Node node3 : list) {
                this.addRoot(node3);
            }
        }
    }

    private void removeNodeOnly(Node node) {
        Node node2 = node.getParent();
        if (node2 != null) {
            node2.removeChild(node);
            List<Node> list = node.getChildren();
            for (Node node3 : list) {
                this.roots.add(node3);
                node3.setNodeType(NodeType.MOVED);
            }
        } else {
            this.treeModel.removeNodeFromParent(node);
            this.removeRoot(node);
            List<Node> list = node.getChildren();
            for (Node node4 : list) {
                this.addRoot(node4);
            }
        }
    }

    public void setTreeLoader(TreeLoader treeLoader) {
        this.treeLoader = treeLoader;
    }

    public TreeLoader getTreeLoader() {
        return this.treeLoader;
    }

    public Node findNode(Object object, int n) {
        depthCount = 0;
        if (this.lastFoundNode != null && this.lastFoundNode.getUserObject().equals(object)) {
            return this.lastFoundNode;
        }
        for (Node node : this.roots) {
            Node node2 = this.findNodeDepthFirst(node, object, n);
            if (node2 == null) continue;
            this.lastFoundNode = node2;
            return this.lastFoundNode;
        }
        return null;
    }

    public Node findNodeDepthFirst(Node node, Object object, int n) {
        if (depthCount == n && node.equals(object)) {
            return node;
        }
        if (depthCount > n) {
            return null;
        }
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            ++depthCount;
            Node node3 = this.findNodeDepthFirst(node2, object, n);
            --depthCount;
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public Node findNode(Object object) {
        return this.findNode("KEY", object, null);
    }

    public Node findNode(String string, Object object, SearchOptions searchOptions) {
        for (Node node : this.roots) {
            Node node2 = this.findNodeDepthFirst(node, string, object, searchOptions);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public Node findNodeDepthFirst(Node node, String string, Object object, SearchOptions searchOptions) {
        if (node.matches(string, object, searchOptions)) {
            return node;
        }
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            Node node3 = this.findNodeDepthFirst(node2, string, object, searchOptions);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public void findNodes(String string, Object object, SearchOptions searchOptions, List<Node> list) {
        for (Node node : this.roots) {
            this.findNodesDepthFirst(node, string, object, searchOptions, list);
        }
    }

    public void findNodesDepthFirst(Node node, String string, Object object, SearchOptions searchOptions, List<Node> list) {
        if (node.matches(string, object, searchOptions)) {
            list.add(node);
        }
        if (node.hasChildren()) {
            List<Node> list2 = node.getChildren();
            for (Node node2 : list2) {
                this.findNodesDepthFirst(node2, string, object, searchOptions, list);
            }
        }
    }

    public void print() {
        for (Node node : this.roots) {
            node.print(0);
        }
    }
}

