/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.awt.Component;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Format;
import oracle.olap.app.table.Queries;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryComponent;
import oracle.olap.app.table.QueryLayout;
import oracle.olap.app.table.QueryPanel;
import oracle.olap.app.table.QueryPanelTab;
import oracle.olap.app.table.QueryTabbedPane;
import oracle.olap.app.table.QueryView;
import oracle.olap.app.table.QueryViewTable;
import oracle.olap.app.table.QueryXMLFile;

public class QueryComponentBuilder {
    private Queries queries;
    private QueryLayout queryLayout;
    private Connection connection;
    private Class clazz;
    private String errorDialogTitle;
    private Map<String, QueryView> queryViewMap = new HashMap<String, QueryView>();
    private final String QUERY_VIEW_TYPE_PANEL = "panel";
    private final String QUERY_VIEW_TYPE_TAB = "tab";

    public QueryComponentBuilder(Connection connection, Class clazz, String string, String string2, String string3) {
        Object object;
        Object object2;
        Object object3;
        this.clazz = clazz;
        this.connection = connection;
        this.errorDialogTitle = string3;
        try {
            this.loadFromXML(string, true);
            object3 = this.queryLayout.getQueryXMLFile();
            object2 = ((QueryXMLFile)object3).getName().trim();
            this.loadFromXML((String)object2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
            object = exception.getLocalizedMessage();
            if (object == null || ((String)object).length() == 0) {
                object = exception.getClass().toString();
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)string3, (String)object2);
        }
        object3 = this.queryLayout.getQueryLayout();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (QueryLayout)object2.next();
            String string4 = ((QueryLayout)object).getName();
            if (!string4.equalsIgnoreCase(string2)) continue;
            List<QueryView> list = ((QueryLayout)object).getQueryView();
            for (QueryView queryView : list) {
                String string5 = queryView.getName();
                this.queryViewMap.put(string5, queryView);
            }
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    public Query getQuery(String string) {
        Query query = this.queries.getQuery(string);
        return query;
    }

    public void addQueryLayout(QueryLayout queryLayout) {
        this.queryLayout = queryLayout;
    }

    public QueryComponent getQueryViewComponent(String string, Map<String, Object> map) {
        Object object;
        JComponent jComponent;
        QueryTabbedPane queryTabbedPane = null;
        QueryView queryView = this.queryViewMap.get(string);
        String string2 = queryView.getType();
        List<QueryViewTable> list = queryView.getQueryViewTables();
        if (string2.equalsIgnoreCase("tab")) {
            jComponent = new QueryTabbedPane();
            for (QueryViewTable object2 : list) {
                object = object2.getName();
                String string3 = object2.getQuery();
                Query query = this.queries.getQuery(string3);
                QueryPanelTab queryPanelTab = new QueryPanelTab(this.connection, query, map, this.getFormats());
                ((QueryTabbedPane)jComponent).add((String)object, queryPanelTab);
            }
            queryTabbedPane = jComponent;
        }
        if (string2.equalsIgnoreCase("panel")) {
            jComponent = null;
            QueryViewTable queryViewTable = list.get(0);
            String string4 = queryViewTable.getQuery();
            object = this.queries.getQuery(string4);
            jComponent = new QueryPanel(this.connection, (Query)object, map, this.getFormats());
            queryTabbedPane = jComponent;
        }
        return queryTabbedPane;
    }

    private void loadFromXML(String string, boolean bl) throws Exception {
        String string2 = "oracle.olap.app.table";
        if (bl) {
            String string3 = JavaXMLBind.LoadDocument(this.clazz, string);
            JavaXMLBind.BindToJavaStr(string3, string2, this);
        } else {
            JavaXMLBind.BindToJava(string, string2, (Object)this);
        }
    }

    public List<Format> getFormats() {
        return this.queries.getFormats();
    }
}

