/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.FlatNode;
import oracle.olap.app.syntaxparser.NodeFlattener;
import oracle.olap.app.syntaxparser.NodeProcessor;
import oracle.olap.app.syntaxparser.ParseNode;

public class NestedParamProcessor
implements NodeProcessor {
    boolean abort = false;
    private static Logger LOG = Logger.getLogger(NestedParamProcessor.class.getName());
    NodeFlattener wrapped;
    String currentParamName;

    NestedParamProcessor(NodeFlattener nodeFlattener, FlatNode flatNode, Map<String, ParseNode> map) {
        this(nodeFlattener, flatNode, flatNode.getParamName(), map);
    }

    NestedParamProcessor(NodeFlattener nodeFlattener, FlatNode flatNode, String string, Map<String, ParseNode> map) {
        this.wrapped = nodeFlattener;
        this.currentParamName = string;
        nodeFlattener.prev = flatNode;
        nodeFlattener.setParamPatterns(map);
    }

    NestedParamProcessor(NodeFlattener nodeFlattener, String string, Map<String, ParseNode> map) {
        this(nodeFlattener, null, string, map);
    }

    @Override
    public ParseNode processNode(ParseNode parseNode) {
        Iterator<String> iterator = parseNode.getParamNames().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = iterator.next();
            if (!string.equals(this.currentParamName)) continue;
            if (iterator.hasNext()) {
                return this.wrapped.processNode(parseNode, iterator, iterator.next());
            }
            return this.wrapped.processNode(parseNode, iterator, null);
        }
        this.abort = true;
        return parseNode;
    }

    @Override
    public boolean abort() {
        return this.abort;
    }

    @Override
    public FlatNode getFlatList() {
        return this.wrapped.getFlatList();
    }

    @Override
    public void finish() {
        this.wrapped.finish();
    }
}

