/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.MeasureFolder;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.db.IdentifierElement;

public class Schema
extends NamedObject {
    private List<Dimension> dimensions;
    private List<Cube> cubes;
    private List<AnalyticWorkspace> aws;
    private List<MeasureFolder> measureFolders;

    public Schema(String string) {
        super(string.toUpperCase());
        this.clear();
    }

    public void clear() {
        this.dimensions = new ArrayList<Dimension>();
        this.cubes = new ArrayList<Cube>();
        this.aws = new ArrayList<AnalyticWorkspace>();
        this.measureFolders = new ArrayList<MeasureFolder>();
        this.setLoaded(false);
    }

    public NamedObjectWithDesc getNamedObject(String string) {
        NamedObjectWithDesc namedObjectWithDesc = null;
        IdentifierElement identifierElement = new IdentifierElement(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (identifierElement.getCount() > 0) {
            string2 = identifierElement.get(0);
        }
        if (identifierElement.getCount() > 1) {
            string3 = identifierElement.get(1);
        }
        if (identifierElement.getCount() > 2) {
            string4 = identifierElement.get(2);
        }
        if (string2 != null) {
            Dimension dimension = this.findDimension(string2);
            if (dimension == null) {
                Cube cube = this.findCube(string2);
                if (string3 != null) {
                    if (cube != null) {
                        Measure measure = cube.findMeasure(string3);
                        namedObjectWithDesc = measure;
                    }
                } else {
                    namedObjectWithDesc = cube;
                }
            } else if (string3 != null) {
                DimensionLevel dimensionLevel = dimension.findLevel(string3);
                if (dimensionLevel == null) {
                    DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string3);
                    if (string4 != null) {
                        if (dimensionHierarchy != null) {
                            DimensionHierarchyLevel dimensionHierarchyLevel = dimensionHierarchy.findHierarchyLevel(string4);
                            namedObjectWithDesc = dimensionHierarchyLevel;
                        }
                    } else {
                        namedObjectWithDesc = dimensionHierarchy;
                    }
                } else if (string4 != null) {
                    for (DimensionAttribute dimensionAttribute : dimensionLevel.getVisibileAttributes()) {
                        if (!string4.equalsIgnoreCase(dimensionAttribute.getName())) continue;
                        namedObjectWithDesc = dimensionAttribute;
                        break;
                    }
                } else {
                    namedObjectWithDesc = dimensionLevel;
                }
            } else {
                namedObjectWithDesc = dimension;
            }
        }
        return namedObjectWithDesc;
    }

    public void addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void addCube(Cube cube) {
        this.cubes.add(cube);
    }

    public List<Cube> getCubes() {
        return this.cubes;
    }

    public void addAW(AnalyticWorkspace analyticWorkspace) {
        this.aws.add(analyticWorkspace);
    }

    public List<AnalyticWorkspace> getAWs() {
        return this.aws;
    }

    public Dimension findDimension(String string) {
        for (Dimension dimension : this.dimensions) {
            if (!dimension.getName().equalsIgnoreCase(string)) continue;
            return dimension;
        }
        return null;
    }

    public Cube findCube(String string) {
        for (Cube cube : this.cubes) {
            if (!cube.getName().equalsIgnoreCase(string)) continue;
            return cube;
        }
        return null;
    }

    public AnalyticWorkspace findAW(String string) {
        for (AnalyticWorkspace analyticWorkspace : this.aws) {
            if (!analyticWorkspace.getName().equalsIgnoreCase(string)) continue;
            return analyticWorkspace;
        }
        return null;
    }

    public void addMeasureFolder(MeasureFolder measureFolder) {
        this.measureFolders.add(measureFolder);
    }

    public MeasureFolder findMeasureFolder(String string) {
        for (MeasureFolder measureFolder : this.measureFolders) {
            if (!measureFolder.getName().equalsIgnoreCase(string)) continue;
            return measureFolder;
        }
        return null;
    }

    public List<MeasureFolder> getMeasureFolders() {
        return this.measureFolders;
    }
}

