/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionAttributeMap;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.MemberMap;
import oracle.olap.app.olapmetadata.Schema;

public class DataValidationMetadataReader {
    private Database database;
    private Schema schema;

    public DataValidationMetadataReader(Database database, Schema schema) {
        this.database = database;
        this.schema = schema;
    }

    public void loadMetadata() throws SQLException, IOException {
        this.getDimensions();
    }

    private void getDimensions() throws SQLException, IOException {
        String string;
        Object object;
        String string2;
        Object object2;
        List<List<String>> list = this.database.executeSQL("select distinct dimension_name from olap_dim_data_validation order by dimension_name");
        for (List<String> object4 : list) {
            String string3 = object4.get(0);
            object2 = new Dimension(this.schema, null, string3, string3);
            this.schema.addDimension((Dimension)object2);
            string2 = "DESCRIPTION";
            object = string2;
            string = string2;
            ((Dimension)object2).addDimensionAttribute(string2, string, (String)object);
        }
        list = this.database.executeSQL("select dimension_name, hierarchy_name from olap_dim_data_validation order by dimension_name, hierarchy_name");
        for (List<String> list2 : list) {
            String string4 = list2.get(0);
            object2 = list2.get(1);
            string2 = list2.get(1);
            object = this.schema.findDimension(string4);
            ((Dimension)object).addDimensionHierarchy((String)object2, string2, "");
        }
        String string3 = "select dimension_name, hierarchy_name, level_name, table_owner || '.' || dimension_table || '.' || member_column keyexpr, table_owner || '.' || dimension_table || '.' || description_column descexpr from olap_dim_data_validation order by dimension_name, hierarchy_name, depth";
        list = this.database.executeSQL(string3);
        for (List<String> list3 : list) {
            object2 = list3.get(0);
            string2 = list3.get(1);
            object = list3.get(2);
            string = list3.get(2);
            String string5 = list3.get(3);
            String string6 = list3.get(4);
            Dimension dimension = this.schema.findDimension((String)object2);
            DimensionLevel dimensionLevel = dimension.addDimensionLevel((String)object, string);
            MemberMap memberMap = dimensionLevel.addMemberMap(string5);
            DimensionAttribute dimensionAttribute = dimension.findAttribute("DESCRIPTION");
            memberMap.addAttributeMap(dimensionAttribute, string6);
            DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string2);
            dimensionHierarchy.addHierarchyLevel(dimensionLevel, string);
        }
    }

    public String[] getDataSQL(DimensionHierarchy dimensionHierarchy) {
        String[] stringArray = new String[dimensionHierarchy.getHierarchyLevels().size()];
        String string = null;
        Object object = null;
        int n = 0;
        int n2 = 0;
        for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy.getHierarchyLevels()) {
            DimensionLevel dimensionLevel = dimensionHierarchyLevel.getDimensionLevel();
            String string2 = dimensionLevel.getName();
            String string3 = dimensionLevel.getMemberMap().getExpression();
            String[] stringArray2 = string3.split("\\.");
            System.out.println(string3);
            string = stringArray2[0] + "." + stringArray2[1];
            String string4 = null;
            for (DimensionAttributeMap dimensionAttributeMap : dimensionLevel.getMemberMap().getAttributeMaps()) {
                string4 = dimensionAttributeMap.getExpression();
            }
            Object object2 = "select distinct " + string3 + " key, " + string4 + " description, ";
            if (object == null) {
                object2 = (String)object2 + "null parent, ";
            } else {
                stringArray2 = ((String)object).split("\\.");
                object = string + "." + stringArray2[2];
                object2 = (String)object2 + (String)object + " parent, ";
            }
            object2 = (String)object2 + n2 + " depth, ";
            object2 = (String)object2 + "'" + string2 + "' level_name ";
            object2 = (String)object2 + "from " + string + " ";
            object2 = (String)object2 + "where " + string3 + " is not null ";
            object2 = (String)object2 + "order by " + string4;
            object = string3;
            stringArray[n++] = object2;
            ++n2;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        try {
            databaseImpl.getConnection("global", "global", "stacx25:1521:rmain3");
            Schema schema = new Schema("GLOBAL");
            DataValidationMetadataReader dataValidationMetadataReader = new DataValidationMetadataReader(databaseImpl, schema);
            dataValidationMetadataReader.loadMetadata();
            List<Dimension> list = schema.getDimensions();
            for (Dimension dimension : list) {
                if (!dimension.getName().equals("CHANNEL94")) continue;
                System.out.println(dimension.toString());
                DimensionHierarchy dimensionHierarchy = dimension.findHierarchy("STANDARD");
                String[] stringArray2 = dataValidationMetadataReader.getDataSQL(dimensionHierarchy);
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

