/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.db;

import java.io.IOException;
import java.sql.Connection;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

public class ConnectionUtil {
    private ConnectionUtil() {
    }

    public static Connection GetConnection(String string) throws DBException {
        Connections connections = Connections.getInstance();
        Connection connection = connections.getConnection(string);
        return connection;
    }

    public static Connection GetConnection(Context context) {
        Element element = context.getElement();
        Node node = context.getNode();
        Connection connection = null;
        connection = element != null ? ConnectionUtil.GetConnection(element) : ConnectionUtil.GetConnection((Element)node);
        return connection;
    }

    public static Connection GetConnection(Element element) {
        ObjectFolder objectFolder;
        if (element instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)element;
            return viewerNode.getDatabase().getConnection();
        }
        if (element instanceof ObjectFolder) {
            objectFolder = (ObjectFolder)element;
            try {
                return ConnectionUtil.GetConnection(objectFolder.getConnectionName());
            }
            catch (DBException dBException) {
                ConnectionUtil.LogMessage(dBException.toString());
                dBException.printStackTrace();
            }
        }
        if (element instanceof ObjectNode) {
            objectFolder = (ObjectNode)element;
            try {
                return ConnectionUtil.GetConnection(objectFolder.getConnectionName());
            }
            catch (DBException dBException) {
                ConnectionUtil.LogMessage(dBException.toString());
                dBException.printStackTrace();
            }
        }
        if (element instanceof DatabaseConnection) {
            objectFolder = (DatabaseConnection)element;
            try {
                return (Connection)objectFolder.getConnection();
            }
            catch (IOException iOException) {
                ConnectionUtil.LogMessage(iOException.toString());
                iOException.printStackTrace();
            }
        }
        return null;
    }

    private static void LogMessage(final String string) {
        System.out.println(string);
        try {
            new SwingClosure(){

                protected void runImpl() {
                    LogManager.getLogManager().showLog();
                    LogManager.getLogManager().getMsgPage().log((Object)(string + "\n"));
                }
            }.run();
        }
        catch (ClosureException closureException) {
            closureException.printStackTrace();
        }
    }
}

