/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.db;

public class Column {
    private String name;
    private String dataType;
    private boolean isPrimaryKey;
    private boolean notNullable;

    public Column(String string, String string2) {
        this.name = string;
        this.dataType = string2;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setIsPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    public void setIsNullable(boolean bl) {
        this.notNullable = !bl;
    }

    public boolean isNullable() {
        return !this.notNullable;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isDate() {
        return this.dataType.indexOf("DATE") != -1;
    }

    public boolean isNumeric() {
        return this.dataType.indexOf("NUMBER") != -1;
    }

    public boolean isString() {
        return this.dataType.indexOf("VARCHAR") != -1;
    }

    public String toString() {
        if (this.getDataType() != null) {
            return this.name + " " + this.getDataType();
        }
        return this.name;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Column && this.name != null && this.dataType != null) {
            Column column = (Column)object;
            if (this.name.equals(column.name) && this.dataType.equals(column.dataType)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        n = 11 * n + (null == this.name ? 0 : this.name.hashCode());
        n = 11 * n + (null == this.dataType ? 0 : this.dataType.hashCode());
        return n;
    }
}

