/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import oracle.olap.OLAPAddin;
import oracle.olap.app.cubeddl.test.CubeUtil;

public class CubeTest {
    private static final String PATH = "c:\\raptor\\trunk\\olap\\src\\oracle\\olap\\app\\cubeddl\\test\\";
    private static final String DATABASE = "adc6141176:1521:omain3";
    private static final String[][] AliasList = new String[][]{{"u", "user"}, {"pth", "password"}, {"pwd", "password"}, {"db", "database"}, {"dbg", "debug"}, {"o", "option"}, {"t", "test"}};

    public static void testCreate() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\raptor\\trunk\\olap\\src\\oracle\\olap\\app\\cubeddl\\test\\\\cubecreate.sql", "-result", "c:\\raptor\\trunk\\olap\\src\\oracle\\olap\\app\\cubeddl\\test\\\\cubecreate.log", "-option", "szkipExecuteSQL,logOLAPISQL,lZogPreSQL", "-sqldev_olap.cache", "false"};
        CubeUtil.Run(stringArray);
    }

    public static boolean diff(String string, String string2) {
        try {
            String string3;
            String[] stringArray = new String[]{"c:\\diff\\diff.exe", string, string2};
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            bufferedReader.close();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string3 = bufferedReader2.readLine()) != null) {
                System.out.println(string3);
            }
            bufferedReader2.close();
            return process.waitFor() != 0;
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            System.out.println(stackTraceElementArray.toString());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test() {
        InputStream inputStream = null;
        boolean bl = false;
        try {
            inputStream = CubeTest.class.getResourceAsStream("test.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            CubeTest.runTests(properties);
        }
        catch (IOException iOException) {
            StackTraceElement[] stackTraceElementArray = iOException.getStackTrace();
            System.out.println(stackTraceElementArray.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl) {
            System.out.println("##### Running in debug mode ######");
        }
    }

    public static void test(String[] stringArray) {
        Object object;
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            if ((string = stringArray[n++]).startsWith("-")) {
                string = string.substring(1, string.length()).toLowerCase();
            }
            string = CubeTest.LookupAlias(string);
            object = "";
            if (n < stringArray.length) {
                object = stringArray[n++];
            }
            while (n < stringArray.length && !stringArray[n].startsWith("-")) {
                object = (String)object + " " + stringArray[n++];
            }
            hashMap.put(string.toLowerCase(), ((String)object).trim());
        }
        Properties properties = new Properties();
        string = (String)hashMap.get("path");
        object = (String)hashMap.get("user");
        String string2 = (String)hashMap.get("password");
        String string3 = (String)hashMap.get("database");
        String string4 = (String)hashMap.get("option");
        String string5 = (String)hashMap.get("debug");
        String string6 = (String)hashMap.get("test");
        String string7 = (String)hashMap.get("sqldev_olap.cache");
        if (string != null) {
            properties.setProperty("path", string);
        }
        properties.setProperty("user", (String)object);
        properties.setProperty("password", string2);
        properties.setProperty("database", string3);
        properties.setProperty("option", string4);
        properties.setProperty("debug", string5);
        properties.setProperty("test", string6);
        properties.setProperty("sqldev_olap.cache", string7);
        CubeTest.runTests(properties);
    }

    private static String LookupAlias(String string) {
        for (int i = 0; i < AliasList.length; ++i) {
            if (!string.equals(AliasList[i][0])) continue;
            return AliasList[i][1];
        }
        return string;
    }

    public static void runTests(Properties properties) {
        String[] stringArray;
        String string;
        boolean bl = false;
        String string2 = properties.getProperty("database");
        String string3 = properties.getProperty("user");
        String string4 = properties.getProperty("password");
        if (string4 == null) {
            string4 = properties.getProperty("pwd");
        }
        String string5 = properties.getProperty("option");
        boolean bl2 = true;
        String string6 = properties.getProperty("logSourceSql");
        if (string6 == null) {
            string6 = properties.getProperty("logSourceSql".toLowerCase());
        }
        if (string6 != null && string6.equalsIgnoreCase("true")) {
            bl2 = false;
        }
        if (string6 != null && string6.equalsIgnoreCase("yes")) {
            bl2 = false;
        }
        if (bl) {
            System.out.println("##### Running in debug mode ######");
        }
        if ((string = properties.getProperty("debug")) != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (string != null && string.equalsIgnoreCase("yes")) {
            bl = true;
        }
        if (bl) {
            System.out.println("##### Running in debug mode ######");
        }
        String string7 = properties.getProperty("path");
        String string8 = properties.getProperty("test");
        String string9 = properties.getProperty("sqldev_olap.cache");
        for (String string10 : stringArray = string8.split(",")) {
            boolean bl3;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            if (string7 != null && string7.length() > 0) {
                string11 = String.format("%s\\%s.sql", string7, string10);
                string12 = String.format("%s\\%s.out", string7, string10);
                string13 = String.format("%s\\%s.log", string7, string10);
            } else {
                string11 = String.format("%s.sql", string10);
                string12 = String.format("%s.out", string10);
                string13 = String.format("%s.log", string10);
            }
            String[] stringArray2 = new String[]{"-user", string3, "-password", string4, "-conn", string2, "-option", string5, "-file", string11, "-result", string12, "-sqldev_olap.cache", string9};
            if (bl) {
                stringArray2 = new String[]{"-user", string3, "-password", string4, "-conn", string2, "-option", string5, "-file", string11, "-sqldev_olap.cache", string9};
            }
            long l = System.currentTimeMillis();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SS");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            System.out.println(string10 + " started");
            boolean bl4 = CubeUtil.Run(stringArray2);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            System.out.println(string10 + " finished in " + simpleDateFormat.format(new Date(l3)));
            System.out.flush();
            if (bl || !bl4) continue;
            if (!string13.contains("\\")) {
                URL uRL = CubeTest.class.getResource(string13);
                String string14 = uRL.getPath();
                string14 = string14.substring(string14.indexOf("/") + 1);
                string13 = string14.replace('/', '\\');
            }
            if (!(bl3 = CubeTest.diff(string12, string13))) continue;
            System.out.println("Failed " + string10);
            return;
        }
        System.out.println("All tests successful");
    }

    public static void main(String[] stringArray) {
        System.out.println("CubeTest Main");
        OLAPAddin.registerDBObjects();
        if (stringArray == null || stringArray.length == 0) {
            CubeTest.test();
        } else {
            CubeTest.test(stringArray);
        }
    }
}

