/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.model;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.cubeddl.model.Measure;

public class CubeAlter {
    private String name;
    private List<Measure> measures = new ArrayList<Measure>();
    private List<Measure> dropMeasures = new ArrayList<Measure>();

    public CubeAlter() {
    }

    public CubeAlter(String string) {
        this();
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Measure addDerivedMeasure(String string, String string2) {
        Measure measure = new Measure(string, string2);
        this.measures.add(measure);
        return measure;
    }

    public Measure dropMeasure(String string) {
        Measure measure = new Measure(string);
        this.dropMeasures.add(measure);
        return measure;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public List<Measure> getDropMeasures() {
        return this.dropMeasures;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER CUBE ");
        stringBuffer.append(this.getName().toLowerCase());
        stringBuffer.append(" (\n");
        if (this.getMeasures().size() > 0) {
            stringBuffer.append("ADD ( ");
            for (Measure measure : this.getMeasures()) {
                stringBuffer.append(measure.getName().toLowerCase());
                stringBuffer.append(" CALCULATION ");
                stringBuffer.append("\"" + measure.getCalcSyntax() + "\"");
                stringBuffer.append(",\n");
            }
            if (stringBuffer.toString().endsWith(",\n")) {
                stringBuffer.substring(0, stringBuffer.length() - 2);
            }
            stringBuffer.append(")");
        }
        if (this.getDropMeasures().size() > 0) {
            stringBuffer.append("DROP ( ");
            for (Measure measure : this.getDropMeasures()) {
                stringBuffer.append(measure.getName().toLowerCase());
                stringBuffer.append(",\n");
            }
            if (stringBuffer.toString().endsWith(",\n")) {
                stringBuffer.substring(0, stringBuffer.length() - 2);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

