/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import oracle.olap.actions.BaseRunnable;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.dml.DMLObject;

public class ImportFromEIFRunnable
extends BaseRunnable {
    private Connection conn = null;
    private String fileName = null;
    private String owner = null;
    private String dbDirectoryAlias = null;
    private String awName = null;
    private String tablespace = null;

    public ImportFromEIFRunnable(Connection connection, String string, String string2, String string3, String string4, String string5) {
        this.conn = connection;
        this.fileName = string5;
        this.owner = string;
        this.dbDirectoryAlias = string4;
        this.awName = string3;
        this.tablespace = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = true;
        String string = this.owner + "." + this.awName;
        try {
            DatabaseUtils.ExecuteSPL(this.conn, "cda '" + this.dbDirectoryAlias + "'");
            if (this.tablespace == null) {
                DMLObject.runDML(this.conn, "CREATE_AW", string);
            } else {
                DMLObject.runDML(this.conn, "CREATE_AW_IN_TABLESPACE", string);
            }
            bl = true;
            DMLObject.runDML(this.conn, "IMPORT_AW_FROM_EIF_FILE", this.dbDirectoryAlias, this.fileName, string);
            DMLObject.runDML(this.conn, "UPDATE_AW", string);
            this.conn.commit();
            DMLObject.runDML(this.conn, "DETACH_AW", string);
        }
        catch (Exception exception) {
            this.setException(exception);
            if (bl) {
                try {
                    DMLObject.runDML(this.conn, "DETACH_AW", string);
                    DMLObject.runDML(this.conn, "DELETE_AW", string);
                    this.conn.commit();
                }
                catch (Exception exception2) {
                    this.setException(exception2);
                }
            }
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }
}

