/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropCascadeConfirmDialog;
import oracle.olap.actions.model.CascadeDeleteCubeMap;
import oracle.olap.actions.model.CascadeDeleteCubePartition;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.actions.model.DependentCubeCalculatedMeasure;

public class DropCascadeConfirmPanel
extends JPanel {
    private DropCascadeConfirmDialog confirmDialog;
    private DefaultTableModel tableModel;
    private GenericTable dependentCascadeDeleteTable;
    private JScrollPane scrollPane;
    private CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper;
    private String objectName;
    private final int OBJECT_NAME_COLUMN = 0;
    private final int TYPE_COLUMN = 1;
    private final int DETAILS_COLUMN = 2;
    private String helpId;

    public DropCascadeConfirmPanel(DropCascadeConfirmDialog dropCascadeConfirmDialog, CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper, String string, String string2) {
        this.confirmDialog = dropCascadeConfirmDialog;
        this.cascadeDeleteDimensionWrapper = cascadeDeleteDimensionWrapper;
        this.objectName = string;
        this.helpId = string2;
        this.init();
    }

    private void init() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.helpId);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel jLabel = new JLabel(OLAPArb.format("DROP_CASCADE_DIALOG_CONFIRM_DELETE_MSG", this.objectName));
        this.add((Component)jLabel, gridBagConstraints);
        boolean bl = this.areCascadeCubeDeletes();
        if (bl) {
            ++gridBagConstraints.gridy;
            JLabel jLabel2 = new JLabel(OLAPArb.get("DROP_CASCADE_DIALOG_AFFECTED_MODEL_MSG"));
            this.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            Object[] objectArray = new String[]{OLAPArb.get("DROP_CASCADE_DIALOG_OBJECT_NAME_HEADING"), OLAPArb.get("DROP_CASCADE_DIALOG_TYPE_HEADING"), OLAPArb.get("DROP_CASCADE_DIALOG_DETAILS_HEADING")};
            this.tableModel = new DefaultTableModel(objectArray, 1){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.dependentCascadeDeleteTable = new GenericTable((TableModel)this.tableModel);
            this.dependentCascadeDeleteTable.setColumnSelectorAvailable(false);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView((Component)this.dependentCascadeDeleteTable);
            ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
            componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
            componentWithTitlebar.setComponent((JComponent)this.scrollPane);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 10, 5);
            gridBagConstraints.weighty = 1.0;
            ++gridBagConstraints.gridy;
            this.add((Component)componentWithTitlebar, gridBagConstraints);
            this.populateCascadeDeleteTable();
        }
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        if (!bl) {
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)new JPanel(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
        }
    }

    public void cancelAction() {
        this.confirmDialog.setConfirmAction(1);
        this.confirmDialog.dispose();
    }

    public void helpAction() {
        HelpSystem.getHelpSystem().showHelp((JComponent)this);
    }

    private boolean areCascadeCubeDeletes() {
        boolean bl = false;
        if (this.cascadeDeleteDimensionWrapper.getCubeDimensionMappingList().size() > 0) {
            bl = true;
        } else if (this.cascadeDeleteDimensionWrapper.getCubePartitions().size() > 0) {
            bl = true;
        } else if (this.cascadeDeleteDimensionWrapper.getDependentCalculatedMeasures().size() > 0) {
            bl = true;
        }
        return bl;
    }

    private void populateCascadeDeleteTable() {
        int n = 0;
        this.tableModel.setRowCount(0);
        String string = this.cascadeDeleteDimensionWrapper.getDimension().getName();
        boolean bl = false;
        boolean bl2 = false;
        List<CascadeDeleteCubeMap> list = this.cascadeDeleteDimensionWrapper.getCubeDimensionMappingList();
        for (CascadeDeleteCubeMap iterator2 : list) {
            bl = true;
            this.tableModel.addRow(new Object[]{"", "", "", ""});
            this.dependentCascadeDeleteTable.setValueAt((Object)iterator2.getCubeName(), n, 0);
            this.dependentCascadeDeleteTable.setValueAt((Object)OLAPArb.get("DROP_CASCADE_DIALOG_TYPE_MAP"), n, 1);
            this.dependentCascadeDeleteTable.setValueAt((Object)iterator2.getMapDetail(), n, 2);
            ++n;
        }
        if (bl) {
            this.tableModel.addRow(new Object[]{"", "", "", ""});
            ++n;
        }
        List<CascadeDeleteCubePartition> list2 = this.cascadeDeleteDimensionWrapper.getCubePartitions();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            CascadeDeleteCubePartition cascadeDeleteCubePartition = (CascadeDeleteCubePartition)iterator.next();
            bl2 = true;
            String string2 = cascadeDeleteCubePartition.getHierarchyName();
            String string3 = cascadeDeleteCubePartition.getLevelName();
            String string4 = string2 + "." + string3;
            this.tableModel.addRow(new Object[]{"", "", "", ""});
            this.dependentCascadeDeleteTable.setValueAt((Object)cascadeDeleteCubePartition.getCubeName(), n, 0);
            this.dependentCascadeDeleteTable.setValueAt((Object)OLAPArb.get("DROP_CASCADE_DIALOG_TYPE_PARTITION"), n, 1);
            this.dependentCascadeDeleteTable.setValueAt((Object)string4, n, 2);
            ++n;
        }
        if (bl2) {
            this.tableModel.addRow(new Object[]{"", "", "", ""});
            ++n;
        }
        for (DependentCubeCalculatedMeasure dependentCubeCalculatedMeasure : this.cascadeDeleteDimensionWrapper.getDependentCalculatedMeasures()) {
            this.tableModel.addRow(new Object[]{"", "", "", ""});
            this.dependentCascadeDeleteTable.setValueAt((Object)(dependentCubeCalculatedMeasure.getCubeName() + "." + dependentCubeCalculatedMeasure.getCalculatedMeasureName()), n, 0);
            this.dependentCascadeDeleteTable.setValueAt((Object)OLAPArb.get("DROP_CASCADE_DIALOG_TYPE_CALC_MEASURE"), n, 1);
            this.dependentCascadeDeleteTable.setValueAt((Object)dependentCubeCalculatedMeasure.getExpression(), n, 2);
            ++n;
        }
        this.dependentCascadeDeleteTable.revalidate();
        this.dependentCascadeDeleteTable.repaint();
    }
}

