/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.security.DataSecurityPolicy;
import oracle.olap.security.ORASUtil;
import oracle.olap.security.RealmConstraint;

public class DropAllDataSecurityRealmsAction
extends AbstractOLAPDDLAction {
    private static Logger LOG = Logger.getLogger(DropAllDataSecurityRealmsAction.class.getName());
    private static Queries queries;
    private static final String XMLFILE = "datasecurityactionqueries.xml";
    private static final String REMOVE_ACES = "REMOVE_ACES";
    private static final String DELETE_ACL = "DELETE_ACL";
    private static final String REMOVE_REALMS = "REMOVE_REALMS";
    private String policyName;
    private String objName;
    private ORASUtil orasUtil;
    private DataSecurityPolicy dsp;

    @Override
    public void launch() {
        DBObject dBObject = this.getDBObject();
        ObjectFolder objectFolder = (ObjectFolder)this.getContext().getElement();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        Connection connection = oracleDatabaseImpl.getConnection();
        this.orasUtil = ORASUtil.getInstance();
        this.objName = String.valueOf(objectFolder.getProperty("DIMENSION_NAME"));
        if (this.objName == null) {
            this.objName = String.valueOf(objectFolder.getProperty("CUBE_NAME"));
        }
        this.policyName = this.orasUtil.createDSPName(this.objName);
        this.dsp = this.orasUtil.getDSPDO(connection, this.policyName);
        List<RealmConstraint> list = null;
        if (this.dsp != null) {
            list = this.dsp.getRealmDOs();
        }
        if (list != null && list.size() > 0) {
            super.launch();
        } else {
            String string = OLAPArb.format("ALLREALMS_DROP_DLG_TITLE", this.objName);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.format("ALLREALMS_NOT_EXIST_MSG", this.objName), string, 1);
        }
    }

    @Override
    protected String getConfirmMessage(String string) {
        String string2 = OLAPArb.format("ALLREALMS_DROP_CONFIRMATION_MSG", this.objName);
        return string2;
    }

    @Override
    protected String getConfirmTitle(String string) {
        String string2 = OLAPArb.format("ALLREALMS_DROP_DLG_TITLE", this.objName);
        return string2;
    }

    @Override
    protected String getProgressMessage(String string) {
        String string2 = OLAPArb.format("ALLREALMS_DROP_PROGRESS_TITLE", this.objName);
        return string2;
    }

    @Override
    protected String getSuccessMessage(String string) {
        String string2 = OLAPArb.format("ALLREALMS_DROP_SUCCESS_MSG", this.objName);
        return string2;
    }

    @Override
    protected String getErrorTitle(String string) {
        String string2 = OLAPArb.format("ALLREALMS_DROP_ERROR_TITLE", this.objName);
        return string2;
    }

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        Connection connection = oracleDatabaseImpl.getConnection();
        String string = this.getOLAPDDLStatements();
        try (OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);){
            oracleCallableStatement.execute();
        }
    }

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        String string = this.getQuery(REMOVE_ACES);
        String string2 = this.getQuery(DELETE_ACL);
        String string3 = this.getQuery(REMOVE_REALMS);
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.orasUtil = ORASUtil.getInstance();
        stringBuffer.append("BEGIN\n");
        List<RealmConstraint> list = this.dsp.getRealmDOs();
        for (RealmConstraint realmConstraint : list) {
            String string4 = realmConstraint.getACLName();
            stringBuffer.append(String.format(string, string4));
            stringBuffer.append("\n");
            stringBuffer.append(String.format(string2, string4));
            stringBuffer.append("\n");
        }
        stringBuffer.append(String.format(string3, this.policyName));
        stringBuffer.append("\n");
        stringBuffer.append("END;");
        stringBuffer.append("\n");
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        String string = "";
        DBObject dBObject = this.getDBObject();
        Collection<String> collection = this.getOLAPDDL(dBObject);
        if (collection != null && !collection.isEmpty()) {
            String[] stringArray = new String[collection.size()];
            stringArray = collection.toArray(stringArray);
            string = stringArray[0];
        }
        return string;
    }

    @Override
    protected boolean isRemoveNodeRequired() {
        return false;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        DropAllDataSecurityRealmsAction.queries = queries;
    }
}

