/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.hierarchyviewer.DimensionMetadataContextImpl;
import oracle.olap.security.DimensionDataSecurityDialog;
import oracle.olap.util.OLAPHelpProvider;

public class CreatePolicyAction
extends AbstractMenuAction {
    private Schema schema;

    public void launch() {
        ObjectFolder objectFolder = (ObjectFolder)this.getContext().getElement();
        String string = String.valueOf(objectFolder.getProperty("DIMENSION_NAME"));
        this.showDialog(string);
    }

    private void showDialog(String string) {
        DBObject dBObject = this.getDBObject();
        final String string2 = dBObject.getConnectionName();
        final String string3 = dBObject.getSchemaName();
        final Connection connection = dBObject.getConnection();
        final OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        if (oracleDatabaseImpl != null) {
            String string4 = OLAPArb.get("MODELER.BIBEANS.INITIALIZING.BUZY.BAR.TITLE");
            final String string5 = string;
            RaptorTask raptorTask = new RaptorTask(string4, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        this.setMessage(OLAPArb.get("CUBE_DATA_VIEWER_READ_METADATA_MSG"));
                        CreatePolicyAction.this.schema = OLAPMetadataCache.getUpdatedSchema(string2, string3);
                        DimensionMetadataContextImpl dimensionMetadataContextImpl = new DimensionMetadataContextImpl(oracleDatabaseImpl, CreatePolicyAction.this.schema.findDimension(string5));
                        OLAPHelpProvider oLAPHelpProvider = new OLAPHelpProvider();
                        this.setMessage(OLAPArb.get("CUBE_DATA_VIEWER_QUERYING_DATA_MSG"));
                        DimensionDataSecurityDialog dimensionDataSecurityDialog = new DimensionDataSecurityDialog((JFrame)Ide.getMainWindow(), oLAPHelpProvider, connection, dimensionMetadataContextImpl);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            ObjectAction objectAction = this.getObjectAction();
            if (null == objectAction) {
                objectAction = new ObjectAction();
                objectAction.setReloadParent(true);
            }
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
            IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
            raptorTask.getDescriptor().addListener(iRaptorTaskListener);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            CreatePolicyAction.this.warn(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
            this.setBlockOACRefresh(true);
        }
    }
}

