/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.util.Namespace;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.actions.BaseRunnable;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.buildreports.BuildStatusDialog;

public class BuildRunnable
extends BaseRunnable {
    private DBObject dbObject;
    private Context context;
    private String type;
    private String name = null;
    private Namespace buildParams = null;
    private Connection conn;
    private String buildItems = null;
    private String refreshMethods = null;
    private int m_buildid;
    private BuildStatusDialog builddlg = null;
    private boolean isValidate = false;

    public BuildRunnable(DBObject dBObject, Context context, String string, String string2) {
        this(dBObject, context, string, string2, false);
    }

    public BuildRunnable(DBObject dBObject, Context context, String string, String string2, boolean bl) {
        this.dbObject = dBObject;
        this.conn = dBObject.getConnection();
        this.context = context;
        this.name = string2;
        this.type = string;
        this.isValidate = bl;
    }

    public BuildRunnable(Connection connection, Namespace namespace, String string, String string2, int n) {
        this(connection, namespace, string, string2, n, false);
    }

    public BuildRunnable(Connection connection, Namespace namespace, String string, String string2, int n, boolean bl) {
        this(connection, namespace, string, string2, n, null, bl);
    }

    public BuildRunnable(Connection connection, Namespace namespace, String string, String string2, int n, BuildStatusDialog buildStatusDialog) {
        this(connection, namespace, string, string2, n, buildStatusDialog, false);
    }

    public BuildRunnable(Connection connection, Namespace namespace, String string, String string2, int n, BuildStatusDialog buildStatusDialog, boolean bl) {
        this.conn = connection;
        this.buildParams = namespace;
        this.buildItems = string;
        this.refreshMethods = string2;
        this.m_buildid = n;
        if (bl) {
            buildStatusDialog = null;
        }
        this.builddlg = buildStatusDialog;
        this.isValidate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (this.name != null) {
                    if (this.isValidate) {
                        arrayList.add("VALIDATE " + this.name);
                    } else {
                        arrayList.add(this.name);
                    }
                    DatabaseUtils.ExecuteStoredProc(this.conn, "DBMS_CUBE.BUILD", arrayList);
                    break block18;
                }
                boolean bl = (Boolean)this.buildParams.get("ISATOMIC");
                int n = bl ? 1 : 0;
                boolean bl2 = (Boolean)this.buildParams.get("REFRESH_AFTER_ERROR");
                int n2 = bl2 ? 1 : 0;
                boolean bl3 = (Boolean)this.buildParams.get("AUTOORDER");
                int n3 = bl3 ? 1 : 0;
                boolean bl4 = (Boolean)this.buildParams.get("ADDDIM");
                int n4 = bl4 ? 1 : 0;
                int n5 = (Integer)this.buildParams.get("PARALLEL_PROC_NUM");
                String string = "declare bisref BOOLEAN; bisatomic BOOLEAN; bisautoorder BOOLEAN; bisautoadddim BOOLEAN; begin if :isrefaftererr=1 then bisref:=true; else bisref:=false; end if; if :isatomic=1 then bisatomic:=true; else bisatomic:=false; end if;if :isautoorder=1 then bisautoorder:=true; else bisautoorder:=false; end if;if :isautoadddim=1 then bisautoadddim:=true; else bisautoadddim:=false; end if;dbms_cube.build(:buildcommands, :refmethod, bisref, :numprocs, bisatomic, bisautoorder, bisautoadddim,null,:buildid); end;";
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
                oracleCallableStatement.setInt("isrefaftererr", n2);
                oracleCallableStatement.setInt("isatomic", n);
                oracleCallableStatement.setInt("isautoorder", n3);
                oracleCallableStatement.setInt("isautoadddim", n4);
                if (this.isValidate) {
                    oracleCallableStatement.setString("buildcommands", "VALIDATE " + this.buildItems);
                } else {
                    oracleCallableStatement.setString("buildcommands", this.buildItems);
                }
                oracleCallableStatement.setString("refmethod", this.refreshMethods);
                oracleCallableStatement.setInt("numprocs", n5);
                oracleCallableStatement.setInt("buildid", this.m_buildid);
                try {
                    oracleCallableStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                finally {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
            }
            catch (Exception exception) {
                this.setException(exception);
            }
            finally {
                if (this.builddlg != null) {
                    this.builddlg.enableClose();
                } else {
                    this.getProgressBar().setDoneStatus();
                }
            }
        }
    }
}

