/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;

public class AnalyticWorkspaceLanguagesPanel
extends JPanel {
    private List<String> languages;
    private GenericTable languagesTable;
    private LanguagesTableModel tableModel;
    private boolean selectionChanged;

    public AnalyticWorkspaceLanguagesPanel(List<String> list) {
        this.languages = list;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.tableModel = new LanguagesTableModel(this.languages);
        this.languagesTable = new GenericTable((TableModel)this.tableModel);
        this.languagesTable.setColumnSelectorAvailable(false);
        this.languagesTable.setAutoResizeMode(0);
        this.languagesTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.languagesTable.getColumnModel().getColumn(1).setPreferredWidth(500);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("REMOVE_AW_LANGUAGES_TABLE_HEADER_LABEL")));
        JScrollPane jScrollPane = new JScrollPane((Component)this.languagesTable);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 0, 0), 1, 1));
    }

    public List<String> getLanguagesToDrop() {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (this.tableModel.getRowCount() > 0) {
            arrayList = new ArrayList<String>();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                boolean bl = (Boolean)this.tableModel.getValueAt(i, 0);
                if (!bl) continue;
                arrayList.add((String)this.tableModel.getValueAt(i, 1));
            }
        }
        return arrayList;
    }

    public void setSelectionChanged(boolean bl) {
        this.selectionChanged = bl;
    }

    public boolean hasSelectionChanged() {
        return this.selectionChanged;
    }

    private class LanguagesTableModel
    extends AbstractTableModel {
        private final String[] columns = new String[]{OLAPArb.getString("REMOVE_AW_LANGUAGES_TABLE_REMOVE_COL"), OLAPArb.getString("REMOVEAW_LANGUAGES_TABLE_LANGUAGE_COL")};
        private final Class[] columnsClass = new Class[]{Boolean.class, String.class};
        private List<String> languages;
        private boolean[] languageSelections;

        public LanguagesTableModel(List<String> list) {
            this.languages = list;
            this.languageSelections = new boolean[list.size()];
        }

        @Override
        public int getRowCount() {
            return this.languages.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.languageSelections[n];
                }
                case 1: {
                    return this.languages.get(n);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.languageSelections[n] = (Boolean)object;
                AnalyticWorkspaceLanguagesPanel.this.setSelectionChanged(true);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnsClass[n];
        }
    }
}

