/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyDescriptor
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:metadata:2003-08"};
    private static final String[] localNames = new String[]{"EncryptionMethod", "KeySize", "KeyInfo", "Extension"};
    public static String KT_SIGNING = "signing";
    public static String KT_ENCRYPTION = "encryption";

    public KeyDescriptor(Element element) throws DOMException {
        super(element);
    }

    public KeyDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public KeyDescriptor(Document owner) throws DOMException {
        super(owner, "urn:liberty:metadata:2003-08", "KeyDescriptor");
    }

    public KeyDescriptor(Document owner, String use) throws DOMException {
        this(owner);
        this.setUse(use);
    }

    public void setUse(String use) throws DOMException {
        this.setAttribute("use", use);
    }

    public String getUse() {
        if (this.hasAttribute("use")) {
            return this.getAttribute("use");
        }
        return null;
    }

    public void setEncryptionMethod(String encURI) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "EncryptionMethod", nsURIs, localNames, encURI, true);
    }

    public String getEncryptionMethod() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "EncryptionMethod");
    }

    public void setKeySize(Integer keySize) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "KeySize", nsURIs, localNames, keySize.toString(), true);
    }

    public Integer getKeySize() {
        String intStr = LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "KeySize");
        if (intStr != null) {
            return Integer.valueOf(intStr);
        }
        return null;
    }

    public void setKeyInfo(XSKeyInfo keyInfo) throws DOMException {
        LibertyUtils.setChildElement(this, (XMLElement)keyInfo, nsURIs, localNames);
    }

    public XSKeyInfo getKeyInfo() {
        return (XSKeyInfo)LibertyUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

