/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.RequestType;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LibRequestMessage
extends RequestType {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 2;

    protected LibRequestMessage(Element element) throws DOMException {
        super(element);
    }

    protected LibRequestMessage(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected LibRequestMessage(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setVersion(1, 2);
    }

    protected LibRequestMessage(Document owner, String nsURI, String localName, String requestId, Date issueInstant) throws DOMException {
        this(owner, nsURI, localName);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
    }

    public static LibRequestMessage getInstance(Element element) throws DOMException {
        return (LibRequestMessage)XMLUtils.getInstance((Element)element, null, (String)"urn:liberty:iff:2003-08");
    }

    public void setProviderID(String providerID) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "ProviderID", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), providerID, true);
    }

    public String getProviderID() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "ProviderID");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getID();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((XMLElement)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    protected String getID() {
        return this.getRequestID();
    }

    protected abstract String[] getChildElementsNSURIs();

    protected abstract String[] getChildElementsLocalNames();

    protected int getChildElementPosition(String nsURI, String localName) throws DOMException {
        String[] localNames = this.getChildElementsLocalNames();
        String[] nsURIs = this.getChildElementsNSURIs();
        int pos = 0;
        while (!localName.equals(localNames[pos]) || !nsURI.equals(nsURIs[pos])) {
            if (pos == localNames.length) {
                throw new DOMException(9, "The element with the local name " + localName + "within the namespace " + nsURI + "is not a valid child element specified in the schema for this element");
            }
            ++pos;
        }
        return pos;
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

