/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import oracle.security.xmlsec.liberty.v12.AuthnContext;
import oracle.security.xmlsec.liberty.v12.LibSubject;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.AuthenticationStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.Subject;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibAuthenticationStatement
extends AuthenticationStatement {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:liberty:iff:2003-08"};
    private static final String[] localNames = new String[]{"Subject", "SubjectLocality", "AuthorityBinding", "AuthnContext"};

    public LibAuthenticationStatement(Element element) throws DOMException {
        this(element, null);
    }

    public LibAuthenticationStatement(Element element, String SystemId) throws DOMException {
        super(element, SystemId);
    }

    public LibAuthenticationStatement(Document owner) throws DOMException {
        super(owner);
        String name = "type";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        String value = "AuthenticationStatementType";
        prefix = XMLElement.getDefaultNSPrefix((String)"urn:liberty:iff:2003-08");
        if (prefix != null && prefix.length() != 0) {
            value = prefix + ":" + value;
        }
        this.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", name, value);
    }

    public LibAuthenticationStatement(Document owner, String authenticationMethod, Date authenticationInstant) throws DOMException {
        this(owner);
        this.setAuthenticationMethod(authenticationMethod);
        this.setAuthenticationInstant(authenticationInstant);
    }

    public Subject getSubject() {
        NodeList list = this.getChildElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Subject");
        if (list.getLength() == 0) {
            list = this.getChildElementsByTagNameNS("urn:liberty:iff:2003-08", "Subject");
        }
        if (list.getLength() == 0) {
            return null;
        }
        return new LibSubject((Element)list.item(0), this.systemId);
    }

    public void setReauthenticateOnOrAfter(Date reAuthnTime) {
        this.setAttribute("ReauthenticateOnOrAfter", XMLUtils.formatDateTime((Date)reAuthnTime));
    }

    public Date getReauthenticateOnOrAfter() {
        if (this.hasAttribute("ReauthenticateOnOrAfter")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("ReauthenticateOnOrAfter"));
        }
        return null;
    }

    public void setSessionIndex(String sessionIndex) {
        this.setAttribute("SessionIndex", sessionIndex);
    }

    public String getSessionIndex() {
        if (this.hasAttribute("SessionIndex")) {
            return this.getAttribute("SessionIndex");
        }
        return null;
    }

    public void setAuthnContext(AuthnContext authnContext) {
        LibertyUtils.setChildElement((XMLElement)this, authnContext, nsURIs, localNames);
        this.setAuthenticationMethod("urn:liberty:ac:2003-08");
    }

    public AuthnContext getAuthnContext() {
        return (AuthnContext)LibertyUtils.getChildElement((XMLElement)this, "urn:liberty:iff:2003-08", "AuthnContext");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

