/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v12.IDPEntries;
import oracle.security.xmlsec.liberty.v12.IDPEntry;
import oracle.security.xmlsec.liberty.v12.IDPList;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibRequestMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.Scoping;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnRequest
extends LibRequestMessage {
    private static final String DEFAULT_PROTOCOL_PROFILE_URI = "http://projectliberty.org/profiles/brws-art";
    public static final String EXACT = "exact";
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String BETTER = "better";
    public static final String NAME_ID_POLICY_NONE = "none";
    public static final String NAME_ID_POLICY_ONETIME = "onetime";
    public static final String NAME_ID_POLICY_FEDERATED = "federated";
    public static final String NAME_ID_POLICY_ANY = "any";

    public AuthnRequest(Element element) throws DOMException {
        super(element);
    }

    public AuthnRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnRequest(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "AuthnRequest");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
    }

    public AuthnRequest(Document owner, String requestId, Date issueInstant, String providerId) throws DOMException {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void setForceAuthn(boolean forceAuthn) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "ForceAuthn", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), String.valueOf(forceAuthn), true);
    }

    public void setIsPassive(boolean isPassive) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "IsPassive", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), String.valueOf(isPassive), true);
    }

    public void setProtocolProfile(String ppURI) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "ProtocolProfile", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), ppURI, true);
    }

    private Element getRequestAuthnContext() throws DOMException {
        NodeList list = this.getChildElementsByTagNameNS("urn:liberty:iff:2003-08", "RequestAuthnContext");
        Element ac = null;
        if (list.getLength() > 0) {
            ac = (Element)list.item(0);
        } else {
            ac = this.getOwnerDocument().createElementNS("urn:liberty:iff:2003-08", "RequestAuthnContext");
            XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)ac);
            XMLUtils.insertChild((Element)((Element)this.node), (Element)ac, (String[])this.getChildElementsNSURIs(), (String[])this.getChildElementsLocalNames());
        }
        return ac;
    }

    public void addAuthnContextClassRef(String accrURI) {
        Document doc = this.getOwnerDocument();
        Element accr = doc.createElementNS("urn:liberty:iff:2003-08", "AuthnContextClassRef");
        accr.appendChild(doc.createTextNode(accrURI));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)accr);
        Element ac = this.getRequestAuthnContext();
        XMLUtils.removeChildren((Element)ac, (String)"urn:liberty:iff:2003-08", (String)"AuthnContextStatementRef");
        ac.appendChild(accr);
    }

    public void addAuthnContextStatementRef(String acsrURI) {
        Document doc = this.getOwnerDocument();
        Element acsr = doc.createElementNS("urn:liberty:iff:2003-08", "AuthnContextStatementRef");
        acsr.appendChild(doc.createTextNode(acsrURI));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)acsr);
        Element ac = this.getRequestAuthnContext();
        XMLUtils.removeChildren((Element)ac, (String)"urn:liberty:iff:2003-08", (String)"AuthnContextClassRef");
        ac.appendChild(acsr);
    }

    public void setAuthnContextComparison(String value) {
        Document doc = this.getOwnerDocument();
        Element acc = doc.createElementNS("urn:liberty:iff:2003-08", "AuthnContextComparison");
        acc.appendChild(doc.createTextNode(value));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)acc);
        Element ac = this.getRequestAuthnContext();
        XMLUtils.removeChildren((Element)ac, (String)"urn:liberty:iff:2003-08", (String)"AuthnContextComparison");
        ac.appendChild(acc);
    }

    public boolean getIsPassive() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "IsPassive");
        return value == null || !value.equals("false") && !value.equals("0");
    }

    public boolean getForceAuthn() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "ForceAuthn");
        return value != null && (value.equals("true") || value.equals("1"));
    }

    public String getProtocolProfile() {
        String value = LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "ProtocolProfile");
        return value != null ? value : DEFAULT_PROTOCOL_PROFILE_URI;
    }

    public List getAuthnContextClassRefs() {
        Vector<String> vec = new Vector<String>();
        NodeList acList = this.getChildElementsByTagNameNS("urn:liberty:iff:2003-08", "RequestAuthnContext");
        if (acList.getLength() > 0) {
            NodeList acrList = XMLElement.getChildElementsByTagNameNS((Element)((Element)acList.item(0)), (String)"urn:liberty:iff:2003-08", (String)"AuthnContextClassRef");
            int size = acrList.getLength();
            for (int i = 0; i < size; ++i) {
                vec.addElement(XMLUtils.collectText((Node)acrList.item(i)));
            }
        }
        return vec;
    }

    public List getAuthnContextStatementRefs() {
        Vector<String> vec = new Vector<String>();
        NodeList acList = this.getChildElementsByTagNameNS("urn:liberty:iff:2003-08", "RequestAuthnContext");
        if (acList.getLength() > 0) {
            NodeList acsList = XMLElement.getChildElementsByTagNameNS((Element)((Element)acList.item(0)), (String)"urn:liberty:iff:2003-08", (String)"AuthnContextStatementRef");
            int size = acsList.getLength();
            for (int i = 0; i < size; ++i) {
                vec.addElement(XMLUtils.collectText((Node)acsList.item(i)));
            }
        }
        return vec;
    }

    public String getAuthnContextComparison() {
        String value;
        NodeList accList;
        NodeList acList = this.getChildElementsByTagNameNS("urn:liberty:iff:2003-08", "RequestAuthnContext");
        if (acList.getLength() > 0 && (accList = XMLElement.getChildElementsByTagNameNS((Element)((Element)acList.item(0)), (String)"urn:liberty:iff:2003-08", (String)"AuthnContextComparison")).getLength() > 0 && (value = XMLUtils.collectText((Node)accList.item(0))) != null) {
            return value;
        }
        return null;
    }

    public void setNameIDPolicy(String nameIDPolicy) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "NameIDPolicy", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), nameIDPolicy, true);
    }

    public String getNameIDPolicy() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "NameIDPolicy");
    }

    public void setAssertionConsumerServiceID(String id) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "AssertionConsumerServiceID", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), id, true);
    }

    public String getAssertionConsumerServiceID() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "AssertionConsumerServiceID");
    }

    public void setAffiliationID(String affiliationID) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "AffiliationID", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), affiliationID, true);
    }

    public String getAffiliationID() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "AffiliationID");
    }

    public Scoping getScoping() {
        return (Scoping)LibertyUtils.getChildElement((XMLElement)this, "urn:liberty:iff:2003-08", "Scoping");
    }

    public void setScoping(Scoping scoping) {
        LibertyUtils.setChildElement((XMLElement)this, scoping, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public void setRelayState(String value) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), value, true);
    }

    public String getRelayState() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState");
    }

    public void setConsent(String consent) throws DOMException {
        this.setAttribute("consent", consent);
    }

    public String getConsent() {
        if (this.hasAttribute("consent")) {
            return this.getAttribute("consent");
        }
        return null;
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        Scoping scoping;
        String relayState;
        String authnContextComparison;
        List authnContextStatementRefs;
        int acsrLen;
        List authnContextClassRefs;
        int accrLen;
        String acsID;
        String protocolProfile;
        String nameIDPolicy;
        String affiliationID;
        String providerID;
        String consent;
        StringBuffer queryBuffer = new StringBuffer();
        String requestID = this.getRequestID();
        if (requestID != null) {
            queryBuffer.append("RequestID=");
            queryBuffer.append(URLEncoder.encode(requestID));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion=");
        queryBuffer.append(String.valueOf(this.getMajorVersion()));
        queryBuffer.append("&MinorVersion=");
        queryBuffer.append(String.valueOf(this.getMinorVersion()));
        queryBuffer.append('&');
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((consent = this.getConsent()) != null) {
            queryBuffer.append("consent=");
            queryBuffer.append(URLEncoder.encode(consent));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((affiliationID = this.getAffiliationID()) != null) {
            queryBuffer.append("AffiliationID=");
            queryBuffer.append(URLEncoder.encode(affiliationID));
            queryBuffer.append('&');
        }
        if (this.getForceAuthn() && !this.getIsPassive()) {
            queryBuffer.append("ForceAuthn=true&");
        }
        if (!this.getIsPassive()) {
            queryBuffer.append("IsPassive=false&");
        }
        if ((nameIDPolicy = this.getNameIDPolicy()) != null) {
            queryBuffer.append("NameIDPolicy=");
            queryBuffer.append(URLEncoder.encode(nameIDPolicy));
            queryBuffer.append('&');
        }
        if ((protocolProfile = this.getProtocolProfile()) != null) {
            queryBuffer.append("ProtocolProfile=");
            queryBuffer.append(URLEncoder.encode(protocolProfile));
            queryBuffer.append('&');
        }
        if ((acsID = this.getAssertionConsumerServiceID()) != null) {
            queryBuffer.append("AssertionConsumerServiceID=");
            queryBuffer.append(URLEncoder.encode(acsID));
            queryBuffer.append('&');
        }
        if ((accrLen = (authnContextClassRefs = this.getAuthnContextClassRefs()).size()) > 0) {
            queryBuffer.append("AuthnContextClassRef=");
            queryBuffer.append(URLEncoder.encode((String)authnContextClassRefs.get(0)));
            for (int i = 1; i < accrLen; ++i) {
                queryBuffer.append('+');
                queryBuffer.append(URLEncoder.encode((String)authnContextClassRefs.get(i)));
            }
            queryBuffer.append('&');
        }
        if ((acsrLen = (authnContextStatementRefs = this.getAuthnContextStatementRefs()).size()) > 0) {
            queryBuffer.append("AuthnContextStatementRef=");
            queryBuffer.append(URLEncoder.encode((String)authnContextStatementRefs.get(0)));
            for (int i = 1; i < acsrLen; ++i) {
                queryBuffer.append('+');
                queryBuffer.append(URLEncoder.encode((String)authnContextStatementRefs.get(i)));
            }
            queryBuffer.append('&');
        }
        if ((authnContextComparison = this.getAuthnContextComparison()) != null) {
            queryBuffer.append("AuthnContextComparison=");
            queryBuffer.append(URLEncoder.encode(authnContextComparison));
            queryBuffer.append('&');
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if ((scoping = this.getScoping()) != null) {
            IDPList idpList;
            Integer proxyCount = scoping.getProxyCount();
            if (proxyCount != null) {
                queryBuffer.append("ProxyCount=");
                queryBuffer.append(URLEncoder.encode(proxyCount.toString()));
                queryBuffer.append('&');
            }
            if ((idpList = scoping.getIDPList()) != null) {
                String getComplete;
                int entriesLen;
                List entries = null;
                IDPEntries idpEntries = idpList.getIDPEntries();
                if (idpEntries != null) {
                    entries = idpEntries.getIDPEntries();
                }
                int n = entriesLen = entries != null ? entries.size() : 0;
                if (entriesLen > 0) {
                    queryBuffer.append("IDPEntries=");
                    queryBuffer.append(URLEncoder.encode(((IDPEntry)((Object)entries.get(0))).getProviderID()));
                    for (int i = 1; i < entriesLen; ++i) {
                        queryBuffer.append('+');
                        queryBuffer.append(URLEncoder.encode(((IDPEntry)((Object)entries.get(i))).getProviderID()));
                    }
                    queryBuffer.append('&');
                }
                if ((getComplete = idpList.getGetComplete()) != null) {
                    queryBuffer.append("GetComplete=");
                    queryBuffer.append(URLEncoder.encode(getComplete));
                    queryBuffer.append('&');
                }
            }
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&Signature=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "Extension", "ProviderID", "AffiliationID", "NameIDPolicy", "ForceAuthn", "IsPassive", "ProtocolProfile", "AssertionConsumerServiceID", "RequestAuthnContext", "RelayState", "Scoping"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

