/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.manip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.osgi.manip.SimpleBundleEntriesList;

public class SimpleBundleEntries {
    private static Map<URL, SimpleBundleEntriesList> m_bundleEntries = Collections.synchronizedMap(new HashMap());

    private SimpleBundleEntries() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleBundleEntriesList getOrLoadSimpleBundleEntriesList(URL jdevInstallationDirectory) throws FileNotFoundException, IOException {
        if (jdevInstallationDirectory == null) {
            throw new NullPointerException("jdevInstallationDirectory passed in to SimpleBundleEntries.getOrLoadSimpleBundleEntriesList() was null");
        }
        Map<URL, SimpleBundleEntriesList> map = m_bundleEntries;
        synchronized (map) {
            if (!m_bundleEntries.containsKey(jdevInstallationDirectory)) {
                return SimpleBundleEntries.loadSimpleBundleEntriesList(jdevInstallationDirectory);
            }
            return m_bundleEntries.get(jdevInstallationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleBundleEntriesList loadSimpleBundleEntriesList(URL jdevInstallationDirectory) throws FileNotFoundException, IOException {
        if (jdevInstallationDirectory == null) {
            throw new NullPointerException("jdevInstallationDirectory passed in to SimpleBundleEntries.getOrLoadSimpleBundleEntriesList() was null");
        }
        Map<URL, SimpleBundleEntriesList> map = m_bundleEntries;
        synchronized (map) {
            SimpleBundleEntriesList list = new SimpleBundleEntriesList(jdevInstallationDirectory);
            if (!list.isEmpty()) {
                list.load();
            } else {
                list = null;
            }
            m_bundleEntries.put(jdevInstallationDirectory, list);
            return m_bundleEntries.get(jdevInstallationDirectory);
        }
    }

    public static SimpleBundleEntriesList getSimpleBundleEntriesList(URL jdevInstallationDirectory) {
        if (jdevInstallationDirectory == null) {
            throw new NullPointerException("jdevInstallationDirectory passed in to SimpleBundleEntries.getSimpleBundleEntriesList() was null");
        }
        return m_bundleEntries.get(jdevInstallationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(URL bundlesInfourl) {
        Map<URL, SimpleBundleEntriesList> map = m_bundleEntries;
        synchronized (map) {
            return m_bundleEntries.containsKey(bundlesInfourl);
        }
    }
}

