/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleJARExtensionSource;
import oracle.ide.osgi.extension.ExtensionManagerLoaderOSGiImpl;
import oracle.ide.osgi.extension.IDEExtensionVisitorOSGiImpl;
import oracle.ide.osgi.extension.internal.ClassLoaderProxy;
import oracle.ide.osgi.extension.internal.IDEMinimalExtensionVisitorOSGiImpl;
import oracle.ide.osgi.extension.search.BundleExtensionSearchStrategy;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class ExtensionManagerOSGiImpl
extends ExtensionManagerImpl {
    private final ExtensionManagerLoaderOSGiImpl m_loader = new ExtensionManagerLoaderOSGiImpl();
    private static String REFERENCE_FILE_PREFIX = "reference:file:";
    private static String EXTENSION_SDK_BUNDLE_ID = "oracle.jdeveloper.esdk";

    protected void initialize() {
        this.runRoleSelectionDialog();
        PerformanceLogger.get().startTiming("ide_startup_sequence", "Starting up IDE...");
        PerformanceLogger.get().startTiming("init_extensionRegistry", "Initializing extensions...");
        this.loadProcessorPlugins();
        this.initializeExtensionRegistry();
        this.postLoadedExtensions();
    }

    public File getExtensionJAR(Extension extension) {
        Bundle bundle;
        DefaultExtension defaultExtension;
        if (extension == null) {
            throw new NullPointerException("extension is null");
        }
        if (extension instanceof DefaultExtension && (defaultExtension = (DefaultExtension)extension).getSource() instanceof BundleJARExtensionSource && (bundle = Platform.getBundleRegistry().findBundle(extension.getID())) != null) {
            try {
                String filePath;
                File file;
                String bundleLoc = bundle.getLocation();
                if (bundleLoc.startsWith(REFERENCE_FILE_PREFIX) && (file = new File(filePath = bundleLoc.substring(REFERENCE_FILE_PREFIX.length()))).isAbsolute()) {
                    return file;
                }
                File extensionJar = FileLocator.getBundleFile((Bundle)bundle);
                String decodedPath = URLDecoder.decode(extensionJar.getPath(), "utf-8");
                return new File(decodedPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Collection<ExtensionSource> findAllExtensionSources() {
        return new BundleExtensionSearchStrategy().findExtensionSources();
    }

    protected MinimalExtensionVisitor createMinimalExtensionVisitor() {
        return new IDEMinimalExtensionVisitorOSGiImpl(this.m_loader);
    }

    protected ExtensionVisitor createExtensionVisitor(ElementVisitorFactory hookVisitorFactory) {
        return new IDEExtensionVisitorOSGiImpl(this, this.m_loader, (DefaultHookVisitorFactory)hookVisitorFactory, this.getTriggerHookRegistry());
    }

    public ClassLoader getClassLoader(String extensionId) {
        return this.m_loader.findOrCreateLoader(extensionId);
    }

    public Extension findExtensionByClassLoader(ClassLoader classLoader) {
        return ClassLoaderProxy.findExtensionByClassLoader(classLoader);
    }

    protected ExtensionSource getExtensionSourceById(String id) {
        Bundle b = Platform.getBundleRegistry().findBundle(id);
        return new BundleJARExtensionSource(b);
    }

    protected List<ExtensionDependency> findExtensionDependencies(String id) {
        return Platform.getBundleRegistry().findExtensionDependencies(id);
    }
}

