/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension;

import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleRegistry;
import oracle.ide.osgi.extension.internal.ClassLoaderProxy;
import oracle.ide.osgi.util.Diagnostics;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExtensionCommandProvider
implements CommandProvider {
    private StringBuffer appendLoad(StringBuffer buf) {
        return buf.append("\tload - loads an Oracle extension. Parameters: <extension id> \n");
    }

    private StringBuffer appendCLoad(StringBuffer buf) {
        return buf.append("\tcload - classloads a class. Parameters: <fully qualifed class name> <extension or bundle id> \n");
    }

    private StringBuffer appendPkg(StringBuffer buf) {
        return buf.append("\tpkg - list all bundles that export a given package. Parameters: <fully qualified package name> \n");
    }

    private StringBuffer appendVerify(StringBuffer buf) {
        return buf.append("\tverify - finds class space violations for a bundle. Parameters: classPath OR classSpace <bundle id> \n");
    }

    private StringBuffer appendBundleOf(StringBuffer buf) {
        return buf.append("\tbundleOf - finds the bundle of the jar specified. Parameters: <file name> ");
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        this.appendLoad(buffer);
        this.appendCLoad(buffer);
        this.appendPkg(buffer);
        this.appendVerify(buffer);
        this.appendBundleOf(buffer);
        return buffer.toString();
    }

    private Extension findExtension(String extId) {
        return ExtensionRegistry.getExtensionRegistry().findExtension(extId);
    }

    public void _load(CommandInterpreter ci) {
        String extid = ci.nextArgument();
        if (extid == null) {
            ci.println((Object)("Usage: " + this.appendLoad(new StringBuffer()).toString()));
            return;
        }
        Extension extension = this.findExtension(extid);
        if (extension == null) {
            ci.println((Object)(extid + " is not a valid extension id "));
            return;
        }
        ExtensionRegistry.getExtensionRegistry().fullyLoadExtension(extension);
        ci.println((Object)("Extension " + extid + " is " + (ExtensionRegistry.getExtensionRegistry().isFullyLoaded(extid) ? "" : "not ") + "fully loaded"));
    }

    public void _cload(CommandInterpreter ci) {
        String classid = ci.nextArgument();
        String extid = ci.nextArgument();
        if (classid == null || extid == null) {
            ci.println((Object)("Usage: " + this.appendCLoad(new StringBuffer()).toString()));
            return;
        }
        Extension extension = this.findExtension(extid);
        if (extension == null) {
            BundleRegistry bundleRegistry = Platform.getBundleRegistry();
            Bundle bundle = bundleRegistry.findBundle(extid);
            if (bundle == null) {
                ci.println((Object)("Bundle " + extid + " was not a known OSGi bundle"));
            } else {
                try {
                    Class clazz = bundle.loadClass(classid);
                    ci.println((Object)(clazz + " classloaded by classloader of " + extid));
                }
                catch (ClassNotFoundException e) {
                    ci.println((Object)("Failed to load class " + classid + " using the classloader of " + extid + " -> " + e.getMessage()));
                    ci.printStackTrace((Throwable)e);
                }
            }
            return;
        }
        ClassLoader classLoader = ClassLoaderProxy.findOrCreateLoader(extid);
        try {
            Class<?> clazz = Class.forName(classid, true, classLoader);
            ci.println((Object)(clazz.getName() + " classloaded by classloader of " + extid));
        }
        catch (ClassNotFoundException e) {
            ci.printStackTrace((Throwable)e);
        }
    }

    public void _pkg(CommandInterpreter ci) {
        String packageFQN = ci.nextArgument();
        if (packageFQN == null) {
            ci.println((Object)"Usage: pkg <package id>");
            return;
        }
        ExportedPackage[] exportedPackages = Platform.getPackageAdmin().getExportedPackages(packageFQN);
        if (exportedPackages != null) {
            for (ExportedPackage expPackage : exportedPackages) {
                Bundle bundle = expPackage.getExportingBundle();
                ci.println((Object)bundle);
            }
        }
    }

    public void _verify(CommandInterpreter ci) {
        ArrayList<Diagnostics.Violation> violators = new ArrayList<Diagnostics.Violation>();
        String verificationType = ci.nextArgument();
        if (verificationType == null || "classpath".equals(verificationType.toLowerCase()) || "cp".equals(verificationType.toLowerCase())) {
            ci.println((Object)"Verifying the class path ...");
            violators.addAll(Diagnostics.verifyClassPath());
        } else if ("classspace".equals(verificationType.toLowerCase()) || "cs".equals(verificationType.toLowerCase())) {
            String bundleSymbolicName = ci.nextArgument();
            if (bundleSymbolicName == null) {
                ci.println((Object)"Verifying the class space of all bundles ...");
                for (Bundle b : Platform.getBundleRegistry().getBundles()) {
                    ci.println((Object)("Verifying " + b));
                    violators.addAll(Diagnostics.verifyClassSpace(b));
                }
            } else {
                ci.println((Object)("Verifying the class space of " + bundleSymbolicName + " ..."));
                Bundle bundle = Platform.getBundleRegistry().findBundle(bundleSymbolicName);
                if (bundle == null) {
                    ci.println((Object)("Bundle " + bundleSymbolicName + " not found"));
                    return;
                }
                violators.addAll(Diagnostics.verifyClassSpace(bundle));
            }
        } else {
            ci.println((Object)"Unsupported option. Valid options are 'classPath' (or 'cp') or 'classSpace (or cs) <bundle name>'");
            return;
        }
        if (violators.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < violators.size(); ++i) {
                Diagnostics.Violation violator = (Diagnostics.Violation)violators.get(i);
                sb.append("Violation " + (i + 1) + ": \t" + violator.displayString() + "\n\n");
            }
            ci.println((Object)("Bundle class path duplications found:\n\n" + sb.toString()));
        } else {
            ci.println((Object)"No violations found");
        }
    }

    public void _bundleOf(CommandInterpreter ci) {
        String nextArg = ci.nextArgument();
        if (nextArg == null) {
            ci.println((Object)"Usage: bundleOf <file name>");
            return;
        }
        Collection<Diagnostics.BundleInfo> bundleInfos = Diagnostics.allBundlesThatContain(nextArg.trim());
        if (bundleInfos.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Diagnostics.BundleInfo bi : bundleInfos) {
                sb.append(bi).append("\n");
            }
            ci.println((Object)sb.toString());
            return;
        }
        int indexOfLastDot = nextArg.toLowerCase().indexOf(".jar");
        if (indexOfLastDot != -1) {
            String fileNameWithoutFileExtension = nextArg.substring(0, indexOfLastDot);
            BundleRegistry br = Platform.getBundleRegistry();
            Bundle bundleById = br.findBundle(fileNameWithoutFileExtension);
            if (bundleById == null) {
                bundleById = br.findBundle(fileNameWithoutFileExtension.toLowerCase());
            }
            if (bundleById != null) {
                ci.println((Object)bundleById.getSymbolicName());
                return;
            }
        }
        ci.println((Object)"No bundles expose the file");
    }
}

