/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.credential;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PasswordActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.credential.CredentialArb;
import oracle.dbtools.util.credential.GraphicalEditorControllerInterface;
import oracle.dbtools.util.credential.GraphicalEditorInterface;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.view.View;
import org.stringtemplate.v4.ST;

public class CredentialCreateAction
extends ActionDialog {
    public static final String NAME = "name";
    public static final String COMMENTS = "comments";
    public static final String SCHEMA = "schema";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATABASE_ROLE = "database_role";
    public static final String WINDOWS_DOMAIN = "windows_domain";
    public static final String ENABLED = "enabled";
    public static final String NAME_VALID_MSG = "namevalidmsg";
    public static final String COMMENTS_VALID_MSG = "commentsvalidmsg";
    public static final String USERNAME_VALID_MSG = "usernamevalidmsg";
    public static final String PASSWORD_VALID_MSG = "passwordvalidmsg";
    public static final String DATABASE_ROLE_VALID_MSG = "database_rolevalidmsg";
    public static final String WINDOWS_DOMAIN_VALID_MSG = "windows_domainvalidmsg";
    public static final String GE_TYPE = "GraphicalEditorController.type";
    public static final String GE_ADDED = "GraphicalEditorController.added";
    public static final String GE_DELETED = "GraphicalEditorController.deleted";
    boolean showOwner = false;
    String owner = null;
    String credential_name = null;
    String database_role = null;
    String username = null;
    String password = null;
    String comments = null;
    String windows_domain = null;
    String enabledStr = null;
    ActionControl ownerCtl = null;
    NameBoxActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    ActionControl userNameCtl = null;
    PasswordActionControl passwordCtl = null;
    ActionControl databaseRoleCtl = null;
    ActionControl windowsDomainCtl = null;
    ActionControl enabledCtl = null;

    @Override
    public String getTitle() {
        return CredentialArb.getString("CREDENTIALCREATEDIALOG_TITLE");
    }

    @Override
    protected String getQuery(Connection connection, String string) {
        String string2 = Utils.getQuery(CredentialCreateAction.class, connection, string);
        return string2;
    }

    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListCredentialsTask();
    }

    protected String getObjectType() {
        return "SCHCREDENTIAL";
    }

    @Override
    public void launch() {
        try {
            DatabaseQueryTask<List<String>> databaseQueryTask = this.getListTask();
            RaptorTaskManager.getInstance().addTask(databaseQueryTask);
            List list = (List)databaseQueryTask.getResult();
            super.launch();
            databaseQueryTask = this.getListTask();
            RaptorTaskManager.getInstance().addTask(databaseQueryTask);
            List list2 = (List)databaseQueryTask.getResult();
            Vector<String> vector = new Vector<String>();
            for (String string : list2) {
                if (!list.contains(string)) continue;
                vector.add(string);
            }
            for (String string : vector) {
                list2.remove(string);
                list.remove(string);
            }
            Map<String, Object> map = this.getDBObject().getDictionary();
            map.put(GE_TYPE, this.getObjectType());
            map.put(GE_ADDED, list2);
            map.put(GE_DELETED, list);
            this.reloadParent(map, this.getDBObject());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void reloadParent(Map<String, Object> map, DBObject dBObject) {
        Context context = this.getContext();
        View view = context.getView();
        if (view instanceof GraphicalEditorInterface) {
            GraphicalEditorInterface graphicalEditorInterface = (GraphicalEditorInterface)view;
            if (dBObject != null && dBObject.getElement() != null) {
                GraphicalEditorControllerInterface graphicalEditorControllerInterface = graphicalEditorInterface.getGraphicalEditorController();
                String string = (String)map.get(GE_TYPE);
                List list = (List)map.get(GE_DELETED);
                List list2 = (List)map.get(GE_ADDED);
                if (string != null && list != null && list2 != null) {
                    for (String string2 : list2) {
                        graphicalEditorControllerInterface.addNode(string, string2);
                    }
                }
                graphicalEditorControllerInterface.ideObjectReloadParent(dBObject.getElement());
            }
        }
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        String string;
        String string2;
        Operation operation = this.getOperation();
        String string3 = this.getDBObject().getDBVersion();
        int n = 0;
        try {
            if (string3.indexOf(46) > 0) {
                string3 = string3.substring(0, string3.indexOf(46));
            }
            n = Integer.valueOf(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = this.getObjectName();
        }
        catch (Exception exception) {
            string2 = "null";
        }
        try {
            string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            string = "null";
        }
        if (operation != Operation.CREATE_NEW) {
            if (Connections.getInstance().lock(connection)) {
                object = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string2);
                    hashMap.put("OBJECT_OWNER", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "CREDENTIAL_DATA"), hashMap);
                    if (object != null && object.next()) {
                        this.owner = object.getString("OWNER");
                        this.credential_name = object.getString("CREDENTIAL_NAME");
                        this.username = object.getString("USERNAME");
                        this.windows_domain = object.getString("WINDOWS_DOMAIN");
                        this.password = null;
                        this.comments = object.getString("COMMENTS");
                        this.database_role = object.getString("DATABASE_ROLE");
                        if (n >= 12) {
                            this.enabledStr = object.getString("ENABLED");
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    DBUtil.closeResultSet(object);
                    Connections.getInstance().unlock(connection);
                }
            }
        } else {
            this.owner = string;
        }
        switch (operation) {
            case UPDATE: {
                this.ownerCtl = new TextBoxActionControl(SCHEMA, CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), this.owner);
                this.ownerCtl.setEditable(false);
                object = this.credential_name;
                if (object != null && !((String)object).matches("^[A-Z][0-9A-Z_$#]*$")) {
                    object = "\"" + (String)object + "\"";
                }
                this.nameCtl = new NameBoxActionControl(NAME, CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), (String)object);
                this.nameCtl.setEditable(false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl(USERNAME, CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl(PASSWORD, CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.windowsDomainCtl = new TextBoxActionControl(WINDOWS_DOMAIN, CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
                this.databaseRoleCtl = new ComboBoxActionControl(DATABASE_ROLE, CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                if (n < 12) break;
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, CredentialArb.getString("CREDENTIALPANEL_ENABLED_LABEL"), Boolean.valueOf(this.enabledStr), false);
                break;
            }
            case CREATE_LIKE: {
                this.ownerCtl = new SqlComboBoxActionControl(SCHEMA, CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), connection, this.getQuery(connection, "getCredentialUsers"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), "");
                this.commentsCtl = new TextBoxActionControl(COMMENTS, CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl(USERNAME, CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl(PASSWORD, CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.windowsDomainCtl = new TextBoxActionControl(WINDOWS_DOMAIN, CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
                this.databaseRoleCtl = new ComboBoxActionControl(DATABASE_ROLE, CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                if (n < 12) break;
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, CredentialArb.getString("CREDENTIALPANEL_ENABLED_LABEL"), Boolean.valueOf(this.enabledStr), false);
                break;
            }
            case CREATE_NEW: {
                this.ownerCtl = new SqlComboBoxActionControl(SCHEMA, CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), connection, this.getQuery(connection, "getCredentialUsers"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.credential_name);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl(USERNAME, CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl(PASSWORD, CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.windowsDomainCtl = new TextBoxActionControl(WINDOWS_DOMAIN, CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
                this.databaseRoleCtl = new ComboBoxActionControl(DATABASE_ROLE, CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                if (n < 12) break;
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, CredentialArb.getString("CREDENTIALPANEL_ENABLED_LABEL"), Boolean.valueOf(this.enabledStr), false);
            }
        }
        object = new ArrayList<ActionControl>();
        if (this.showOwner) {
            ((ArrayList)object).add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl(SCHEMA, CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.owner);
        }
        ((ArrayList)object).add(this.nameCtl);
        if (n >= 12) {
            ((ArrayList)object).add(this.enabledCtl);
        }
        ((ArrayList)object).add(this.commentsCtl);
        ((ArrayList)object).add(this.userNameCtl);
        ((ArrayList)object).add(this.passwordCtl);
        ((ArrayList)object).add(this.databaseRoleCtl);
        ((ArrayList)object).add(this.windowsDomainCtl);
        return object;
    }

    @Override
    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        String string = this.ownerCtl.getValue().get();
        String string2 = values.get(NAME);
        if (string2 != null) {
            if ((string2 = string2.trim()).startsWith("\"")) {
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else if (string2.matches("^[a-zA-Z][0-9a-zA-Z_$#]*$")) {
                string2 = string2.toUpperCase();
            }
        }
        String string3 = values.get(COMMENTS);
        String string4 = values.get(USERNAME);
        String string5 = values.get(PASSWORD);
        String string6 = values.get(DATABASE_ROLE);
        String string7 = values.get(WINDOWS_DOMAIN);
        String string8 = values.get(ENABLED);
        Boolean bl = null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        bl = string8 != null && string8.length() == 0 ? null : Boolean.valueOf(string8);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put(SCHEMA, string);
        treeMap.put(NAME, string2);
        treeMap.put(USERNAME, string4);
        treeMap.put(PASSWORD, string5);
        treeMap.put(DATABASE_ROLE, string6);
        treeMap.put(WINDOWS_DOMAIN, string7);
        treeMap.put(COMMENTS, string3);
        treeMap.put(ENABLED, bl);
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put(SCHEMA, CredentialCreateAction.equals(string, this.owner) == false);
        treeMap2.put(NAME, CredentialCreateAction.equals(string2, this.credential_name) == false);
        treeMap2.put(USERNAME, CredentialCreateAction.equals(string4, this.username) == false);
        treeMap2.put(PASSWORD, CredentialCreateAction.equals(string5, this.password) == false);
        treeMap2.put(WINDOWS_DOMAIN, CredentialCreateAction.equals(string7, this.windows_domain) == false);
        treeMap2.put(DATABASE_ROLE, CredentialCreateAction.equals(string6, this.database_role) == false);
        treeMap2.put(COMMENTS, CredentialCreateAction.equals(string3, this.comments) == false);
        treeMap2.put(ENABLED, CredentialCreateAction.equals(bl, Boolean.valueOf(this.enabledStr)) == false);
        TreeMap<String, Boolean> treeMap3 = new TreeMap<String, Boolean>();
        treeMap3.put(SCHEMA, string == null);
        treeMap3.put(NAME, string2 == null);
        treeMap3.put(USERNAME, string4 == null);
        treeMap3.put(PASSWORD, string5 == null);
        treeMap3.put(WINDOWS_DOMAIN, string7 == null);
        treeMap3.put(DATABASE_ROLE, string6 == null);
        treeMap3.put(COMMENTS, string3 == null);
        treeMap3.put(ENABLED, bl == null);
        TreeMap<String, Object> treeMap4 = new TreeMap<String, Object>();
        treeMap4.put("model", treeMap);
        treeMap4.put("changes", treeMap2);
        treeMap4.put("isnull", treeMap3);
        String string9 = null;
        switch (operation) {
            case UPDATE: {
                string9 = this.generate("CREDENTIAL_UPDATE", treeMap4);
                break;
            }
            case CREATE_LIKE: {
                string9 = this.generate("CREDENTIAL_CREATE_LIKE", treeMap4);
                break;
            }
            case CREATE_NEW: {
                string9 = this.generate("CREDENTIAL_CREATE", treeMap4);
            }
        }
        return string9;
    }

    private String generate(String string, Map<String, Object> map) {
        String string2 = this.getDBObject().getDBVersion();
        String string3 = this.getQuery(this.getDBObject().getConnection(), string);
        ST sT = new ST(string3);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                sT.add(entry.getKey(), entry.getValue());
            }
        }
        String string4 = sT.render();
        if (string2.startsWith("10")) {
            string4 = string4.replaceAll("\r\n", "\n");
        }
        return string4;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return Boolean.TRUE;
        }
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    @Override
    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    public boolean isEnabled(Context context) {
        Version version = new Version("11");
        return RaptorVersionTracker.checkVersion(this.getDBObject().getConnection(), null, version) && super.isEnabled(context);
    }

    @Override
    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newCredentialDialog_html");
    }

    private class ListCredentialsTask
    extends DatabaseQueryTask<List<String>> {
        public ListCredentialsTask() {
            super("ListCredentialsTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return CredentialCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            String string = CredentialCreateAction.this.getQuery(CredentialCreateAction.this.getDBObject().getConnection(), "getCredentialList");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = CredentialCreateAction.this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string = resultSet.getString("OWNER") + "." + resultSet.getString("CREDENTIAL_NAME");
                            vector.add(string);
                        }
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

