/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.credential;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.javatools.db.DBException;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public final class CredentialCodeGenerator {
    public static final String CREDENTIAL_UPDATE = "CREDENTIAL_UPDATE";
    private Map<String, STGroup> templateGroups = new HashMap<String, STGroup>();

    public static CredentialCodeGenerator getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private STGroup getTemplateGroup(String string) {
        if (string == null || string.length() == 0) {
            STGroup sTGroup = this.fetchTemplateGroup("");
            return sTGroup;
        }
        STGroup sTGroup = this.templateGroups.get(string);
        if (sTGroup == null) {
            Map<String, STGroup> map = this.templateGroups;
            synchronized (map) {
                sTGroup = this.templateGroups.get(string);
                if (sTGroup == null) {
                    String[] stringArray = string.split("\\.");
                    for (int i = stringArray.length; i > 0; --i) {
                        String string2 = "_";
                        Object object = "";
                        for (int j = 0; j < i; ++j) {
                            object = (String)object + string2 + stringArray[j];
                            string2 = "_";
                        }
                        sTGroup = this.fetchTemplateGroup((String)object);
                        if (sTGroup != null) break;
                    }
                    if (sTGroup == null) {
                        sTGroup = this.fetchTemplateGroup("");
                    }
                }
                if (sTGroup != null) {
                    this.templateGroups.put(string, sTGroup);
                }
            }
        }
        return sTGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private STGroup fetchTemplateGroup(String string) {
        STGroup sTGroup = this.templateGroups.get(string);
        if (sTGroup == null) {
            Map<String, STGroup> map = this.templateGroups;
            synchronized (map) {
                sTGroup = this.templateGroups.get(string);
                if (sTGroup == null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    try {
                        sTGroup = new STGroupFile("oracle/dbtools/util/credential/templates/CREDENTIAL" + string + ".stg");
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                    this.templateGroups.put(string, sTGroup);
                }
            }
        }
        return sTGroup;
    }

    public ST getTemplate(String string, String string2) {
        try {
            STGroup sTGroup = this.getTemplateGroup(string);
            if (sTGroup != null) {
                ST sT = sTGroup.getInstanceOf(string2);
                return sT;
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(CredentialCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return null;
    }

    public String generateForConnection(String string, String string2, Map<String, Object> map) {
        try {
            return this.generate(Connections.getInstance().getConnection(string), string2, map);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String generate(Connection connection, String string, Map<String, Object> map) {
        String string2 = RaptorVersionTracker.getDbVersion(connection).toCanonicalString();
        return this.generate(string2, string, map);
    }

    public String generate(String string, String string2, Map<String, Object> map) {
        String string3 = null;
        try {
            ST sT = this.getTemplate(string, string2);
            if (sT != null) {
                if (map != null) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        try {
                            sT.add(entry.getKey(), entry.getValue());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                string3 = sT.render();
                if (string.startsWith("10")) {
                    string3 = string3.replaceAll("\r\n", "\n");
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(CredentialCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return string3;
    }

    public String getQuery(String string, String string2) {
        STGroup sTGroup = this.getTemplateGroup(string2);
        ST sT = sTGroup.getInstanceOf(string);
        if (sT == null) {
            return null;
        }
        return sT.render();
    }

    private static final class Holder {
        private static CredentialCodeGenerator INSTANCE = new CredentialCodeGenerator();

        private Holder() {
        }
    }
}

