/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.templates;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.net.URLFileSystem;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public abstract class TemplateSupport {
    private final String mTemplatePath;
    private final String mBaseName;
    private final ClassLoader mLoader;
    private Set<Version> knownVersions = new TreeSet<Version>();
    private Map<Version, STGroup> templateGroups = new HashMap<Version, STGroup>();

    protected TemplateSupport(String string, String string2, ClassLoader classLoader) {
        this.mTemplatePath = string;
        this.mBaseName = string2;
        this.mLoader = classLoader;
    }

    protected final void initVersions() {
        for (URL uRL : FileUtils.getFilesInPackage((String)this.mTemplatePath, (ClassLoader)this.mLoader, (String)".stg")) {
            String string = URLFileSystem.getName((URL)uRL);
            if (string == null || !string.startsWith(this.mBaseName)) continue;
            String string2 = string.substring(this.mBaseName.length());
            Version version = null;
            if (string2.length() == 0) {
                version = new Version("0");
            } else if (string2.startsWith("_") && (string2 = string2.substring(1)).length() > 0) {
                version = new Version(string2.replace("_", "."));
            }
            if (version == null) continue;
            this.knownVersions.add(version);
            STGroupFile sTGroupFile = new STGroupFile(uRL);
            if (sTGroupFile == null) continue;
            this.templateGroups.put(version, (STGroup)sTGroupFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final STGroup findTemplateGroup(Version version) {
        TemplateSupport templateSupport = this;
        synchronized (templateSupport) {
            STGroup sTGroup = this.templateGroups.get(version);
            if (sTGroup == null) {
                Version version2 = null;
                for (Version version3 : this.knownVersions) {
                    if (version.compareTo(version3) < 0) break;
                    version2 = version3;
                }
                if (version2 != null && (sTGroup = this.templateGroups.get(version2)) != null) {
                    this.templateGroups.put(version, sTGroup);
                }
            }
            return sTGroup;
        }
    }
}

