/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.persistence;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.connections.security.SecureReferencePair;
import oracle.dbtools.util.Logger;
import oracle.jdevimpl.db.adapter.ReferenceWorkerWrapper;

public abstract class ConnectionReferenceFactory {
    public static final int UNSPECIFIED_PORT_VALUE = -1;

    public static String getBindingName(String string, String string2) {
        return string + "/" + string2;
    }

    public static String getConnectionName(String string, String string2) {
        int n;
        String string3 = null;
        if (string2 != null && (n = string2.indexOf(47)) >= 0 && string.equals(string2.substring(0, n))) {
            string3 = string2.substring(n + 1);
        }
        return string3;
    }

    protected static String extractConnectionNameIgnoreType(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(47)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static void setStringValue(Reference reference, String string, String string2) {
        if (string2 != null) {
            reference.add(new StringRefAddr(string, string2));
        }
    }

    protected static String getStringValue(Reference reference, String string) {
        String string2 = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            string2 = (String)refAddr.getContent();
        }
        return string2;
    }

    public static void setStringValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, String string2) {
        if (string2 != null) {
            referenceBuilder.addValue((ReferencePair)new StringReferencePair(string, string2));
        }
    }

    protected static String getStringValue(ConnectionReference connectionReference, String string) {
        String string2 = null;
        ReferencePair referencePair = connectionReference.get(string);
        if (referencePair instanceof StringReferencePair) {
            string2 = (String)referencePair.getValue();
        }
        return string2;
    }

    public static void setURIValue(Reference reference, String string, URI uRI) {
        if (uRI != null) {
            String string2 = uRI.toString();
            reference.add(new StringRefAddr(string, string2));
        }
    }

    protected static URI getURIValue(Reference reference, String string) {
        URI uRI = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            uRI = ConnectionReferenceFactory.getURI(string2);
        }
        return uRI;
    }

    private static URI getURI(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.severe(ConnectionReferenceFactory.class, (Throwable)uRISyntaxException);
        }
        return uRI;
    }

    public static void setURIValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, URI uRI) {
        if (uRI != null) {
            String string2 = uRI.toString();
            referenceBuilder.addValue((ReferencePair)new StringReferencePair(string, string2));
        }
    }

    protected static URI getURIValue(ConnectionReference connectionReference, String string) {
        URI uRI = null;
        ReferencePair referencePair = connectionReference.get(string);
        if (referencePair instanceof StringReferencePair) {
            String string2 = (String)referencePair.getValue();
            uRI = ConnectionReferenceFactory.getURI(string2);
        }
        return uRI;
    }

    public static void setURLValue(Reference reference, String string, URL uRL) {
        if (uRL != null) {
            String string2 = uRL.toString();
            reference.add(new StringRefAddr(string, string2));
        }
    }

    public static URL getURLValue(Reference reference, String string) {
        URL uRL = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            uRL = ConnectionReferenceFactory.getURL(string2);
        }
        return uRL;
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.severe(ConnectionReferenceFactory.class, (Throwable)malformedURLException);
        }
        return uRL;
    }

    public static void setURLValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, URL uRL) {
        if (uRL != null) {
            String string2 = uRL.toString();
            referenceBuilder.addValue((ReferencePair)new StringReferencePair(string, string2));
        }
    }

    public static URL getURLValue(ConnectionReference connectionReference, String string) {
        URL uRL = null;
        ReferencePair referencePair = connectionReference.get(string);
        if (referencePair instanceof StringReferencePair) {
            String string2 = (String)referencePair.getValue();
            uRL = ConnectionReferenceFactory.getURL(string2);
        }
        return uRL;
    }

    public static void setSecureValue(Reference reference, String string, char[] cArray, String string2) {
        ReferenceWorkerWrapper referenceWorkerWrapper;
        RefAddr refAddr;
        if (cArray != null && cArray.length > 0 && (refAddr = (referenceWorkerWrapper = ReferenceWorkerWrapper.wrap((ReferenceWorker)DatabaseProviderHelper.getDefaultWorker())).encrypt(string, cArray, string2)) != null) {
            reference.add(refAddr);
        }
    }

    protected static char[] getSecureValue(Reference reference, String string, String string2) {
        char[] cArray = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr != null) {
            cArray = ReferenceWorkerWrapper.wrap((ReferenceWorker)DatabaseProviderHelper.getDefaultWorker()).decrypt(refAddr, string2);
        }
        return cArray;
    }

    public static void setSecureValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, char[] cArray, String string2) {
        ReferenceWorker referenceWorker;
        SecureReferencePair secureReferencePair;
        if (cArray != null && cArray.length > 0 && (secureReferencePair = (referenceWorker = DatabaseProviderHelper.getDefaultWorker()).encrypt(string, cArray, string2)) != null) {
            referenceBuilder.addValue((ReferencePair)secureReferencePair);
        }
    }

    protected static char[] getSecureValue(ConnectionReference connectionReference, String string, String string2) {
        char[] cArray = null;
        ReferencePair referencePair = connectionReference.get(string);
        SecureReferencePair secureReferencePair = null;
        if (referencePair instanceof SecureReferencePair) {
            secureReferencePair = (SecureReferencePair)referencePair;
        } else if (referencePair instanceof StringReferencePair) {
            secureReferencePair = SecureReferencePair.convertToSecureReference((StringReferencePair)((StringReferencePair)referencePair));
        }
        if (secureReferencePair != null) {
            cArray = DatabaseProviderHelper.getDefaultWorker().decrypt(secureReferencePair, string2);
        }
        return cArray;
    }

    public static void setIntValue(Reference reference, String string, int n) {
        reference.add(new StringRefAddr(string, Integer.toString(n)));
    }

    protected static int getIntValue(Reference reference, String string) {
        int n = -1;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.severe(ConnectionReferenceFactory.class, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static void setIntValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, int n) {
        referenceBuilder.addValue((ReferencePair)new StringReferencePair(string, Integer.toString(n)));
    }

    protected static int getIntValue(ConnectionReference connectionReference, String string) {
        int n = -1;
        ReferencePair referencePair = connectionReference.get(string);
        if (referencePair instanceof StringReferencePair) {
            String string2 = (String)referencePair.getValue();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.severe(ConnectionReferenceFactory.class, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static void setBooleanValue(Reference reference, String string, Boolean bl) {
        if (bl != null) {
            reference.add(new StringRefAddr(string, bl.toString()));
        }
    }

    public static Boolean getBooleanValue(Reference reference, String string) {
        Boolean bl = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr && refAddr.getContent() != null) {
            bl = Boolean.valueOf((String)refAddr.getContent());
        }
        return bl;
    }

    public static void setBooleanValue(ConnectionReference.ReferenceBuilder referenceBuilder, String string, Boolean bl) {
        if (bl != null) {
            referenceBuilder.addValue((ReferencePair)new StringReferencePair(string, bl.toString()));
        }
    }

    public static Boolean getBooleanValue(ConnectionReference connectionReference, String string) {
        Boolean bl = null;
        ReferencePair referencePair = connectionReference.get(string);
        if (referencePair instanceof StringReferencePair && referencePair.getValue() != null) {
            bl = Boolean.valueOf((String)referencePair.getValue());
        }
        return bl;
    }
}

