/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ConnectionResolverImplementation;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.startup.HomeSupport;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.ConnectionInitializer;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Resource;
import oracle.dbtools.util.Util;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdeveloper.db.StoreListener;

public final class Connections
implements ShutdownHook {
    private static String _lastActiveConn;
    public static final String DBNAME_KEY = "Connections.db_name";
    public static final String CONN_COLOR = "Connection-Color-For-Editors";
    private static final Object LOCK;
    static final Logger LOGGER;
    private static Connections s_connections;
    private static Map<String, Store> s_tempStores;
    private List<URL> m_tempStoreURLs = new ArrayList<URL>();
    public static final String TEMP_STORE_ID = "internal";
    public static final String PRIVATE_STORE_ID = "private";
    private Map<Connection, Map<String, Object>> m_connProperties = new HashMap<Connection, Map<String, Object>>();
    private DatabaseConnectionStores m_dbStores = DatabaseConnectionStores.getInstance();
    private List<ConnectionListener> m_listeners;
    private List<ConnectionInitializer> m_initializers = new CopyOnWriteArrayList<ConnectionInitializer>();
    private List<ConnectionDisconnectListener> m_disconnectListeners = new CopyOnWriteArrayList<ConnectionDisconnectListener>();
    private Map<String, Store> m_stores;
    private ConnectionResolverImplementation m_resolver = new ConnectionResolverImplementation(){

        public Connection getConnectionImpl(String string, boolean bl) throws Exception {
            return Connections.this.getConnection(string, bl);
        }

        public Connection getUniqueConnectionImpl(String string) throws Exception {
            return Connections.this.getUniqueConnection(string);
        }

        public String getConnectionNameImpl(Connection connection) {
            return Connections.this.getConnectionName(connection);
        }

        public String[] getConnNamesImpl() {
            return Connections.this.getConnNames();
        }

        public Properties getConnectionInfoImpl(String string) {
            return Connections.this.getConnectionInfo(string);
        }

        public boolean isOracleImpl(Connection connection) {
            return Connections.this.isOracle(connection);
        }

        public boolean isTimesTenImpl(Connection connection) {
            return Connections.this.isTimesTen(connection);
        }

        public String getConnectionTypeImpl(Connection connection) {
            return Connections.this.getConnectionType(connection);
        }

        public String getQualifiedName(String string) {
            String string2 = Connections.getStoreName(string);
            if (string2 == null || string2.trim().equals("")) {
                return ConnectionKey.createConnectionKey("IdeConnections", string).getQualifiedName();
            }
            return null;
        }
    };

    public static String getActiveConnectionName() {
        return _lastActiveConn;
    }

    public static String getConnectionName(String string) {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        return connectionKey != null ? connectionKey.getConnectionName() : null;
    }

    public static String getConnName(URL uRL) {
        String string = "";
        if (uRL.getPath().indexOf("/") > 0) {
            string = uRL.getPath().substring(uRL.getPath().indexOf("/") + 1);
        }
        return string;
    }

    public static String getDisplayName(String string) {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        if (connectionKey != null) {
            String string2 = connectionKey.getStoreName();
            return !ModelUtil.hasLength((String)string2) || "IdeConnections".equals(string2) || Connections.isTempStore(string2) ? connectionKey.getConnectionName() : MessageFormat.format(UtilsResources.get("QUALIFIED_CONN_NAME_FORMAT"), connectionKey.getConnectionName(), DatabaseConnectionStores.getInstance().getShortLabel(string2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connections getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (s_connections == null) {
                s_connections = new Connections();
            }
        }
        return s_connections;
    }

    public static String getStoreName(String string) {
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        return connectionKey != null ? connectionKey.getStoreName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnections getTemporaryConnectionStore(String string) {
        Connections connections = this;
        synchronized (connections) {
            Store store = s_tempStores.get(string);
            if (store == null) {
                try {
                    URL uRL = Resource.RAPTOR_USER_TEMP != null ? URLFactory.newDirURL((File)Resource.RAPTOR_USER_TEMP) : null;
                    URL uRL2 = Util.getTempFile((String)string, (String)".xml", (URL)uRL);
                    this.m_tempStoreURLs.add(uRL2);
                    DatabaseConnections databaseConnections = DatabaseConnections.getPrivateInstance((URL)uRL2);
                    store = new Store(databaseConnections.getStoreName(), databaseConnections);
                    s_tempStores.put(string, store);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return store != null ? store.getConnectionStore() : null;
        }
    }

    private static String getUniqueName(Collection<String> collection, String string) {
        Object object;
        Object object2 = null;
        int n = 1;
        char c = '\u0000';
        if (string.indexOf(39) == 0) {
            if (string.indexOf(39, 1) == string.length() - 1) {
                string = string.substring(1, string.length() - 1);
                c = '\'';
            }
        } else if (string.indexOf(34) == 0 && string.indexOf(34, 1) == string.length() - 1) {
            string = string.substring(1, string.length() - 1);
            c = '\"';
        }
        if (!collection.contains(object = string)) {
            object2 = object;
        } else {
            object = (String)object + "__";
            int n2 = n;
            while (object2 == null) {
                String string2 = (String)object + n2;
                if (c != '\u0000') {
                    string2 = c + string2 + c;
                }
                if (!collection.contains(string2)) {
                    object2 = string2;
                }
                ++n2;
            }
        }
        return object2;
    }

    public String createPrivateConnection(String string) throws ConnectionException {
        return this.createTemporaryConnection(string, Connections.getConnectionName(string), true);
    }

    public String createTemporaryConnection(String string) throws ConnectionException {
        return this.createTemporaryConnection(string, Connections.getConnectionName(string), false);
    }

    public String createTemporaryConnection(String string, String string2) throws ConnectionException {
        return this.createTemporaryConnection(string, string2, false);
    }

    private String createTemporaryConnection(String string, String string2, boolean bl) throws ConnectionException {
        Properties properties = this.getConnectionInfo(string);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        properties2.put("SavePassword", Boolean.FALSE.toString());
        properties2.put("UnsharedWorksheetOriginalConnectionName", string);
        return this.createTemporaryConnection(string, string2, bl, properties2);
    }

    public String createPrivateConnection(String string, Properties properties) throws ConnectionException {
        return this.createTemporaryConnection(string, Connections.getConnectionName(string), true, properties);
    }

    private String createTemporaryConnection(String string, String string2, boolean bl, Properties properties) throws ConnectionException {
        DatabaseConnections databaseConnections = this.getTemporaryConnectionStore(bl ? PRIVATE_STORE_ID : TEMP_STORE_ID);
        List<String> list = databaseConnections.listConnections();
        if (list == null) {
            list = Collections.emptyList();
        }
        String string3 = Connections.getUniqueName(list, string2);
        databaseConnections.addConnection(string3, properties);
        String string4 = ConnectionKey.createConnectionKey(databaseConnections.getStoreName(), string3).getQualifiedName();
        return string4;
    }

    public void removePrivateConnection(String string) throws ConnectionException {
        String string2 = Connections.getConnectionName(string);
        DatabaseConnections databaseConnections = this.getTemporaryConnectionStore(PRIVATE_STORE_ID);
        databaseConnections.removeConnection(string2);
    }

    public static boolean isOCIDriverAvailable() {
        return Boolean.getBoolean(HomeSupport.OCI_AVAILABLE);
    }

    private static boolean isTempStore(String string) {
        boolean bl = false;
        for (Store store : s_tempStores.values()) {
            String string2 = store.getStoreID();
            if (!ModelUtil.areEqual((Object)string, (Object)string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isTemporaryConnection(String string) {
        Store store = s_tempStores.get(TEMP_STORE_ID);
        return store != null && ModelUtil.areEqual((Object)store.getStoreID(), (Object)Connections.getStoreName(string));
    }

    public static boolean isPrivateConnection(String string) {
        String string2 = Connections.getStoreName(string);
        return Connections.isTempStore(string2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "select product,version from PRODUCT_COMPONENT_VERSION";
        Connection connection = Connections.getInstance().getTestConnection("8");
        ResultSet resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("9.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("10.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
    }

    public static void populateConnectionInfo(Properties properties) {
        if (properties == null) {
            return;
        }
        if (ModelUtil.areEqual((Object)properties.getProperty("subtype"), (Object)"oraJDBC")) {
            OracleConnectionProcessor oracleConnectionProcessor = OracleConnectionType.getConnectionProcessor(properties.getProperty("OracleConnectionType"));
            Properties properties2 = oracleConnectionProcessor.preprocessProperties(properties);
            properties.clear();
            properties.putAll((Map<?, ?>)properties2);
        }
    }

    public static void safePropertySetter(Properties properties, String string, String string2) {
        if (string2 == null) {
            properties.remove(string);
        } else {
            properties.setProperty(string, string2);
        }
    }

    public static synchronized void setActiveConnectionName(String string) {
        if (string != null && string.length() > 1) {
            _lastActiveConn = string;
        }
    }

    private Connections() {
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    ConnectionResolverImplementation getConnectionResolver() {
        return this.m_resolver;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteArrayList<ConnectionListener>();
        }
        this.m_listeners.add(connectionListener);
    }

    public void addInitializer(ConnectionInitializer connectionInitializer) {
        this.m_initializers.add(connectionInitializer);
    }

    public void removeInitializer(ConnectionInitializer connectionInitializer) {
        this.m_initializers.remove(connectionInitializer);
    }

    public void addConnectionDisconnectListener(ConnectionDisconnectListener connectionDisconnectListener) {
        this.m_disconnectListeners.add(connectionDisconnectListener);
    }

    public void removeConnectionDisconnectListener(ConnectionDisconnectListener connectionDisconnectListener) {
        this.m_disconnectListeners.remove(connectionDisconnectListener);
    }

    public Connection cloneConnection(Connection connection) throws ConnectionException {
        Connection connection2 = null;
        String string = this.getConnectionName(connection);
        if (string != null) {
            connection2 = this.getUniqueConnection(string);
        }
        return connection2;
    }

    public Connection cloneConnection(String string) throws ConnectionException {
        Connection connection = null;
        if (string != null) {
            connection = this.getUniqueConnection(string);
        }
        return connection;
    }

    public boolean closeConnection(String string) {
        return this.closeConnection(string, false);
    }

    public boolean closeConnection(String string, boolean bl) {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        return connectionInfo == null || connectionInfo.closeConnection(bl);
    }

    private ConnectionInfo findConnectionInfo(String string) {
        Store store = null;
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        if (connectionKey != null) {
            store = this.getStore(connectionKey.getStoreName());
        }
        return store != null ? store.getConnectionInfo(connectionKey) : null;
    }

    private void fireConnectionEvent(final ConnectionEvent connectionEvent, boolean bl) {
        if (this.m_listeners != null) {
            final Iterator<ConnectionListener> iterator = this.m_listeners.iterator();
            connectionEvent.setSelectorOpened(ConnectionSelectorUI.SELECTOR_ACTIVE);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    switch (connectionEvent.getID()) {
                        case 2: {
                            while (iterator.hasNext()) {
                                ((ConnectionListener)iterator.next()).connectionAdded(connectionEvent);
                            }
                            break;
                        }
                        case 3: {
                            while (iterator.hasNext()) {
                                ((ConnectionListener)iterator.next()).connectionRemoved(connectionEvent);
                            }
                            break;
                        }
                        case 5: {
                            while (iterator.hasNext()) {
                                ((ConnectionListener)iterator.next()).connectionModified(connectionEvent);
                            }
                            break;
                        }
                        case 0: {
                            while (iterator.hasNext()) {
                                ((ConnectionListener)iterator.next()).connectionOpened(connectionEvent);
                            }
                            break;
                        }
                        case 1: {
                            while (iterator.hasNext()) {
                                ((ConnectionListener)iterator.next()).connectionClosed(connectionEvent);
                            }
                            break;
                        }
                    }
                }
            };
            if (bl) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public Connection getConnection(String string) throws DBException {
        return this.getConnection(string, true);
    }

    public Connection getConnection(String string, boolean bl) throws DBException {
        Database database;
        Connection connection = null;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        if (connectionInfo != null && (database = connectionInfo.getDatabase(bl)) != null) {
            connection = database.getConnection(bl);
        }
        return connection;
    }

    private Properties getConnectionInfo(ConnectionKey connectionKey) {
        ConnectionInfo connectionInfo;
        Store store = this.getStore(connectionKey.getStoreName());
        ConnectionInfo connectionInfo2 = connectionInfo = store != null ? store.getConnectionInfo(connectionKey) : null;
        if (connectionInfo != null) {
            return connectionInfo.getConnectionProperties();
        }
        return null;
    }

    public Properties getConnectionInfo(String string) {
        ConnectionKey connectionKey = null;
        if (string != null) {
            connectionKey = new ConnectionKey(string);
        }
        return connectionKey == null ? null : this.getConnectionInfo(connectionKey);
    }

    public Color getConnectionColor(String string) {
        String string2;
        Color color = null;
        Properties properties = this.getConnectionInfo(string);
        if (properties != null && (string2 = properties.getProperty(CONN_COLOR)) != null) {
            try {
                color = new Color(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    public Properties getConnectionInfo(String string, String string2) {
        return this.getConnectionInfo(ConnectionKey.createConnectionKey(string, string2));
    }

    public String getConnectionName(Connection connection) {
        String string = null;
        if (connection != null) {
            for (ConnectionInfo connectionInfo : this.getConnections(true)) {
                try {
                    Database database = connectionInfo.getDatabase(false);
                    if (database == null || database.getConnection(false) != connection) continue;
                    string = connectionInfo.m_key.getQualifiedName();
                    break;
                }
                catch (DBException dBException) {
                }
            }
        }
        return string;
    }

    public String getConnectionName(Database database) {
        String string = null;
        if (database != null) {
            string = database.getQualifiedName();
        }
        return string;
    }

    private Map<String, Store> getStores() {
        if (this.m_stores == null) {
            this.m_stores = new HashMap<String, Store>();
            for (String string : this.m_dbStores.listStores()) {
                this.registerConnectionStore(string);
            }
            this.m_dbStores.addStoreListener(new StoreListener(){

                public void storeAdded(String string) {
                    Connections.this.registerConnectionStore(string);
                }

                public void storeRemoved(String string) {
                    Connections.this.unregisterConnectionStore(string);
                }
            });
        }
        return this.m_stores;
    }

    private synchronized Collection<ConnectionInfo> getConnections(boolean bl) {
        ArrayList<ConnectionInfo> arrayList = new ArrayList<ConnectionInfo>();
        for (Store store : this.getStores().values()) {
            arrayList.addAll(store.getConnections());
        }
        if (bl) {
            for (Store store : s_tempStores.values()) {
                arrayList.addAll(store.getConnections());
            }
        }
        return arrayList;
    }

    private synchronized Store getStore(String string) {
        Map<String, Store> map = this.getStores();
        Store store = map.get(string);
        if (store == null) {
            for (Store store2 : s_tempStores.values()) {
                if (!ModelUtil.areEqual((Object)string, (Object)store2.getStoreID())) continue;
                store = store2;
                break;
            }
        }
        return store;
    }

    public String[] getConnNames() {
        return this.getConnNames((NameFilter)null);
    }

    public final String[] getConnNames(NameFilter nameFilter, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Store> map = this.getStores();
        Object object = map.values().iterator();
        while (object.hasNext()) {
            Store store = object.next();
            for (ConnectionInfo connectionInfo : store.getConnections()) {
                if (nameFilter != null && !nameFilter.accept(Candidate.createCandidate(connectionInfo))) continue;
                arrayList.add(connectionInfo.getConnectionKey().getQualifiedName());
            }
        }
        if (bl && (object = s_tempStores.get(TEMP_STORE_ID)) != null) {
            for (ConnectionInfo connectionInfo : ((Store)object).getConnections()) {
                if (nameFilter != null && !nameFilter.accept(Candidate.createCandidate(connectionInfo))) continue;
                arrayList.add(connectionInfo.getConnectionKey().getQualifiedName());
            }
        }
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                long l;
                boolean bl = Connections.this.isConnectionOpenFast(string);
                boolean bl2 = Connections.this.isConnectionOpenFast(string2);
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                long l2 = Connections.this.connectStart(string);
                if (l2 > (l = Connections.this.connectStart(string2))) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                return string.compareTo(string2);
            }
        });
        return arrayList.toArray(new String[0]);
    }

    public final String[] getConnNames(NameFilter nameFilter) {
        return this.getConnNames(nameFilter, false);
    }

    public String[] getConnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Store store = this.getStore(string);
        if (store != null) {
            for (ConnectionInfo connectionInfo : store.getConnections()) {
                arrayList.add(connectionInfo.getConnectionKey().getQualifiedName());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getConnNames(final String[] stringArray, boolean bl) {
        NameFilter nameFilter = stringArray != null && stringArray.length > 0 ? new NameFilter(){

            @Override
            public boolean accept(Candidate candidate) {
                Properties properties = candidate.getProperties();
                return Arrays.binarySearch(stringArray, properties.getProperty("subtype")) >= 0;
            }
        } : null;
        return this.getConnNames(nameFilter, bl);
    }

    public String[] getConnNames(String[] stringArray) {
        return this.getConnNames(stringArray, false);
    }

    public Database getDatabase(Connection connection) {
        return this.getDatabase(connection, true);
    }

    private Database getDatabase(Connection connection, boolean bl) {
        if (connection == null) {
            return null;
        }
        Database database = null;
        for (ConnectionInfo connectionInfo : this.getConnections(true)) {
            try {
                Database database2 = connectionInfo.getDatabase(false);
                if (database2 == null || connection != database2.getConnection(false)) continue;
                database = database2;
                break;
            }
            catch (DBException dBException) {
            }
        }
        if (database == null && bl) {
            try {
                database = DatabaseFactory.findOrCreateDatabase(null, (Connection)connection);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return database;
    }

    public Database getDatabase(String string) throws DBException {
        return this.getDatabase(string, true);
    }

    public Database getDatabase(String string, boolean bl) throws DBException {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        return connectionInfo != null ? connectionInfo.getDatabase(bl) : null;
    }

    public Connection reopenConnection(String string) throws DBException {
        Connection connection = null;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        if (connectionInfo != null) {
            connection = connectionInfo.reopenConnection();
        }
        return connection;
    }

    public Object getProperty(Connection connection, String string) {
        return this.m_connProperties.get(connection) != null ? this.m_connProperties.get(connection).get(string) : null;
    }

    public Connection getTestConnection(String string) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        String string2 = System.getProperty("sdev.testConnectionFile");
        if (string2 == null && Connections.class.getResource("testConnections.xml") != null) {
            string2 = Connections.class.getResource("testConnections.xml").getFile();
        }
        if (string2 == null) {
            File file = new File(System.getProperty("user.home") + File.separator + "testConnections.xml");
            string2 = file.getAbsolutePath();
        }
        System.out.println(Messages.getString("Connections.25") + string2);
        return null;
    }

    public ArrayList<String> getTestConnectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("10.2");
        arrayList.add("9.2");
        arrayList.add("8");
        return arrayList;
    }

    public Connection getUniqueConnection(String string) throws ConnectionException {
        DatabaseConnections databaseConnections;
        Connection connection = null;
        ConnectionKey connectionKey = ConnectionKey.createConnectionKey(string);
        Store store = this.getStore(connectionKey.getStoreName());
        if (store != null && (databaseConnections = store.getConnectionStore()) != null) {
            connection = databaseConnections.getUniqueConnection(connectionKey.getConnectionName());
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getConnectionInfo(string));
            this.initializeConnection(new ConnectionDetails(string, connection, properties, null, true));
        }
        return connection;
    }

    public boolean isAccess(String string) {
        Properties properties;
        boolean bl = false;
        if (string != null && (properties = this.getConnectionInfo(string)) != null) {
            String string2 = properties.getProperty("driver");
            bl = ModelUtil.areEqual((Object)string2, (Object)"sun.jdbc.odbc.JdbcOdbcDriver");
        }
        return bl;
    }

    public boolean isConnectionOpen(String string) {
        boolean bl = false;
        try {
            ConnectionInfo connectionInfo = this.findConnectionInfo(string);
            bl = connectionInfo != null && connectionInfo.getDatabase(false) != null;
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return bl;
    }

    public boolean isConnectionOpenFast(String string) {
        boolean bl = false;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        bl = connectionInfo != null && connectionInfo.checkDatabase();
        return bl;
    }

    public long connectStart(String string) {
        boolean bl = false;
        long l = -1L;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        boolean bl2 = bl = connectionInfo != null && connectionInfo.checkDatabase();
        if (bl) {
            l = connectionInfo.getConnectStart();
        }
        return l;
    }

    public boolean isOracle(Connection connection) {
        return connection instanceof OracleConnection;
    }

    public boolean isOracle(String string) {
        ConnectionInfo connectionInfo;
        if (string != null && (connectionInfo = this.findConnectionInfo(string)) != null) {
            return "Oracle".equals(connectionInfo.getConnectionType());
        }
        return false;
    }

    public boolean isTimesTen(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string.indexOf("TimesTen") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isTimesTen(String string) {
        ConnectionInfo connectionInfo;
        boolean bl = false;
        if (string != null && (connectionInfo = this.findConnectionInfo(string)) != null) {
            bl = "TimesTen".equals(connectionInfo.getConnectionType());
        }
        return bl;
    }

    public String getConnectionType(String string) {
        if (string != null) {
            ConnectionInfo connectionInfo = this.findConnectionInfo(string);
            return connectionInfo != null ? connectionInfo.getConnectionType() : null;
        }
        return null;
    }

    public String getConnectionType(Connection connection) {
        return this.isOracle(connection) ? "Oracle" : (this.isTimesTen(connection) ? "TimesTen" : "Generic");
    }

    public boolean lock(Connection connection) {
        return LockManager.lock((Connection)connection);
    }

    public boolean lock(Connection connection, boolean bl) {
        return LockManager.lock((Connection)connection, (boolean)bl);
    }

    public boolean lock(String string) {
        return this.lock(string, false);
    }

    public boolean checkLock(Connection connection) {
        return LockManager.checkLock((Connection)connection);
    }

    public boolean tryLock(Connection connection, long l) {
        return LockManager.tryLock((Connection)connection, (long)l);
    }

    public boolean lock(String string, boolean bl) {
        try {
            Connection connection = this.getConnection(string, false);
            return connection != null && this.lock(connection, bl);
        }
        catch (DBException dBException) {
            LOGGER.severe(Messages.getString("Connections.6"));
            return false;
        }
    }

    public boolean checkLock(String string) {
        try {
            Connection connection = this.getConnection(string, false);
            return connection != null && this.checkLock(connection);
        }
        catch (DBException dBException) {
            LOGGER.severe(Messages.getString("Connections.6"));
            return false;
        }
    }

    public boolean tryLock(String string, long l) {
        try {
            Connection connection = this.getConnection(string, false);
            return connection != null && this.tryLock(connection, l);
        }
        catch (DBException dBException) {
            LOGGER.severe(Messages.getString("Connections.6"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(Connection connection, String string, Object object) {
        Map<Connection, Map<String, Object>> map = this.m_connProperties;
        synchronized (map) {
            if (this.m_connProperties.get(connection) == null) {
                this.m_connProperties.put(connection, new HashMap());
            }
            this.m_connProperties.get(connection).put(string, object);
        }
    }

    private void registerConnectionStore(String string) {
        long l = System.currentTimeMillis();
        DatabaseConnections databaseConnections = this.m_dbStores.getStore(string);
        LOGGER.info(Messages.getString("Connections.5") + (System.currentTimeMillis() - l));
        Store store = new Store(string, databaseConnections);
        this.m_stores.put(string, store);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(connectionListener);
            if (this.m_listeners.size() == 0) {
                this.m_listeners = null;
            }
        }
    }

    public String resovleTNS2JDBCURL(String string) {
        String string2 = string;
        string2 = TNSHelper.getEntry((String)string).getJDBCUrl();
        return string2;
    }

    public void unlock(String string) {
        try {
            Connection connection = this.getConnection(string, false);
            LockManager.unlock((Connection)connection);
        }
        catch (DBException dBException) {
            LOGGER.severe(Messages.getString("Connections.6"));
        }
    }

    public void unlock(Connection connection) {
        LockManager.unlock((Connection)connection);
    }

    private void unregisterConnectionStore(String string) {
        Store store = this.m_stores.get(string);
        if (store != null) {
            store.unregister();
            this.m_stores.remove(string);
        }
    }

    private void initializeConnection(ConnectionDetails connectionDetails) {
        assert (connectionDetails.getConnection() != null);
        long l = 0L;
        for (ConnectionInitializer connectionInitializer : this.m_initializers) {
            if (Debug.DEBUG) {
                l = System.currentTimeMillis();
            }
            try {
                connectionInitializer.initializeConnection(connectionDetails);
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getLocalizedMessage());
            }
            if (!Debug.DEBUG) continue;
            LOGGER.info(MessageFormat.format("Time to initialize {0}: {1}ms", connectionInitializer.getClass().getName(), System.currentTimeMillis() - l));
        }
    }

    public boolean canShutdown() {
        boolean bl = true;
        if (this.m_stores != null) {
            for (Store store : this.m_stores.values()) {
                if (store.checkDisconnect()) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            for (Store store : s_tempStores.values()) {
                if (store.checkDisconnect()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void shutdown() {
        for (URL uRL : this.m_tempStoreURLs) {
            URLFileSystem.delete((URL)uRL);
        }
    }

    static {
        LOCK = new Object();
        LOGGER = Logger.getLogger(Connections.class.getName());
        s_tempStores = new HashMap<String, Store>();
    }

    private class Store {
        private DatabaseConnections m_dbs;
        private String m_id;
        private Map<String, ConnectionInfo> m_conns = new HashMap<String, ConnectionInfo>();
        private ConnectionsListener m_cl = new ConnectionsListener(){

            public void connectionAdded(ConnectionsEvent connectionsEvent) {
                String string = connectionsEvent.getName();
                Store.this.addConnection(string);
            }

            public void connectionRemoved(ConnectionsEvent connectionsEvent) {
                String string = connectionsEvent.getName();
                Store.this.removeConnection(string);
            }

            public void connectionUpdated(ConnectionsEvent connectionsEvent) {
                String string = connectionsEvent.getOriginalName();
                String string2 = connectionsEvent.getName();
                ConnectionKey connectionKey = ConnectionKey.createConnectionKey(Store.this.m_id, string);
                ConnectionKey connectionKey2 = ConnectionKey.createConnectionKey(Store.this.m_id, string2);
                if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                    ConnectionInfo connectionInfo = Store.this.m_conns.remove(string);
                    if (connectionInfo != null) {
                        connectionInfo.updateConnectionKey(connectionKey2);
                        Store.this.m_conns.put(string2, connectionInfo);
                    }
                } else {
                    ConnectionInfo connectionInfo = Store.this.m_conns.get(string);
                    if (connectionInfo != null) {
                        connectionInfo.clearProperties();
                    }
                }
                Connections.this.fireConnectionEvent(new ConnectionEvent(5, connectionKey2.getQualifiedName(), connectionKey.getQualifiedName()), true);
            }
        };
        private DisconnectListener m_dl = new DisconnectListener(){

            public boolean canDisconnect(ConnectionsEvent connectionsEvent) {
                String string = connectionsEvent.getName();
                ConnectionInfo connectionInfo = Store.this.getConnectionInfo(string);
                return connectionInfo == null || Store.this.checkDisconnect(connectionInfo.getConnectionDetails());
            }

            public void connectionDisconnected(ConnectionsEvent connectionsEvent) {
                ConnectionInfo connectionInfo = Store.this.getConnectionInfo(connectionsEvent.getName());
                if (connectionInfo != null) {
                    ConnectionDetails connectionDetails = connectionInfo.getConnectionDetails();
                    connectionInfo.cleanupAfterClose();
                    ListIterator<ConnectionDisconnectListener> listIterator = Connections.this.m_disconnectListeners.listIterator(Connections.this.m_disconnectListeners.size());
                    while (listIterator.hasPrevious()) {
                        ConnectionDisconnectListener connectionDisconnectListener = listIterator.previous();
                        try {
                            connectionDisconnectListener.connectionDisconnected(connectionDetails);
                        }
                        catch (Exception exception) {
                            LOGGER.severe(exception.getLocalizedMessage());
                        }
                    }
                }
            }
        };

        Store(String string, DatabaseConnections databaseConnections) {
            this.m_id = string;
            this.m_dbs = databaseConnections;
            this.m_dbs.addListener(this.m_cl);
            this.m_dbs.addDisconnectListener(this.m_dl);
            for (String string2 : this.m_dbs.listConnections()) {
                this.addConnection(string2);
            }
        }

        private void addConnection(String string) {
            ConnectionKey connectionKey = ConnectionKey.createConnectionKey(this.m_id, string);
            this.m_conns.put(string, new ConnectionInfo(connectionKey, this.m_dbs));
            Connections.this.fireConnectionEvent(new ConnectionEvent(2, connectionKey.getQualifiedName()), true);
        }

        private void removeConnection(String string) {
            ConnectionInfo connectionInfo = this.m_conns.remove(string);
            if (connectionInfo != null) {
                connectionInfo.closeConnection();
            }
            Connections.this.fireConnectionEvent(new ConnectionEvent(3, new ConnectionKey(this.m_id, string).getQualifiedName()), true);
        }

        private void unregister() {
            String[] stringArray;
            for (String string : stringArray = this.m_conns.keySet().toArray(new String[0])) {
                this.removeConnection(string);
            }
            this.m_dbs.removeListener(this.m_cl);
        }

        public String getStoreID() {
            return this.m_id;
        }

        public Collection<ConnectionInfo> getConnections() {
            return Collections.unmodifiableCollection(this.m_conns.values());
        }

        public DatabaseConnections getConnectionStore() {
            return this.m_dbs;
        }

        public ConnectionInfo getConnectionInfo(String string) {
            return this.m_conns.get(string);
        }

        public ConnectionInfo getConnectionInfo(ConnectionKey connectionKey) {
            assert (this.m_id.equals(connectionKey.getStoreName()));
            return this.getConnectionInfo(connectionKey.getConnectionName());
        }

        private boolean checkDisconnect(ConnectionDetails connectionDetails) {
            boolean bl = true;
            if (connectionDetails.getConnection() != null) {
                ListIterator<ConnectionDisconnectListener> listIterator = Connections.this.m_disconnectListeners.listIterator(Connections.this.m_disconnectListeners.size());
                while (listIterator.hasPrevious()) {
                    ConnectionDisconnectListener connectionDisconnectListener = listIterator.previous();
                    try {
                        connectionDisconnectListener.checkDisconnect(connectionDetails);
                    }
                    catch (DisconnectVetoException disconnectVetoException) {
                        bl = false;
                        break;
                    }
                }
            }
            return bl;
        }

        boolean checkDisconnect() {
            boolean bl = true;
            for (ConnectionInfo connectionInfo : this.m_conns.values()) {
                ConnectionDetails connectionDetails = connectionInfo.getConnectionDetails();
                if (connectionDetails.getConnection() == null || this.checkDisconnect(connectionDetails)) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    private final class ConnectionInfo
    extends DBObjectProviderListener {
        private final Object m_lock = new Object();
        private DatabaseConnections m_conns;
        private volatile Database m_db;
        private ConnectionKey m_key;
        private Properties m_props;
        private String m_type;
        private long m_connectStart;

        ConnectionInfo(ConnectionKey connectionKey, DatabaseConnections databaseConnections) {
            this.m_key = connectionKey;
            this.m_conns = databaseConnections;
        }

        ConnectionKey getConnectionKey() {
            return this.m_key;
        }

        void updateConnectionKey(ConnectionKey connectionKey) {
            this.m_key = connectionKey;
            this.clearProperties();
        }

        void clearProperties() {
            this.m_props = null;
        }

        boolean closeConnection() {
            return this.closeConnection(false);
        }

        boolean closeConnection(boolean bl) {
            boolean bl2 = true;
            if (this.m_db != null) {
                try {
                    bl2 = this.m_conns.disconnect(this.m_key.getConnectionName(), bl);
                }
                catch (ConnectionException connectionException) {
                    bl2 = false;
                }
            }
            if (bl2) {
                this.cleanupAfterClose();
            }
            return bl2;
        }

        private void cleanupAfterClose() {
            if (this.m_db != null) {
                this.m_db.removeProviderListener((DBObjectProviderListener)this);
                this.m_db = null;
                Connections.this.fireConnectionEvent(new ConnectionEvent(1, this.m_key.getQualifiedName()), true);
            }
            this.m_props = null;
            this.m_connectStart = -1L;
        }

        Properties getConnectionProperties() {
            if (this.m_props == null) {
                try {
                    this.m_props = this.m_conns.getProperties(this.m_key.getConnectionName());
                    Connections.populateConnectionInfo(this.m_props);
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            return this.m_props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection reopenConnection() throws DBException {
            Database database;
            Connection connection = null;
            Object object = this.m_lock;
            synchronized (object) {
                database = this.m_db;
            }
            if (database != null) {
                connection = database.getConnection(true);
                Connections.this.fireConnectionEvent(new ConnectionEvent(0, this.m_key.getQualifiedName()), true);
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Database getDatabase(boolean bl) throws DBException {
            Database database;
            Object object = this.m_lock;
            synchronized (object) {
                database = this.m_db;
            }
            if (database == null) {
                database = this.m_conns.getDatabase(this.m_key.getConnectionName(), bl);
                if (database != null) {
                    Object object2;
                    object = null;
                    if (bl) {
                        object2 = database;
                        synchronized (object2) {
                            object = database.getConnection(true);
                            this.m_connectStart = System.currentTimeMillis();
                        }
                    } else if (database.isConnectionAlive()) {
                        object = database.getConnection(false);
                    }
                    if (object == null) {
                        database = null;
                        this.m_connectStart = -1L;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        if (database != null) {
                            try {
                                object2 = this.m_lock;
                                synchronized (object2) {
                                    if (this.m_db == null) {
                                        this.m_conns.disconnect(this.m_key.getConnectionName(), true);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        database = null;
                    }
                }
                if (database != null) {
                    object = this.m_lock;
                    synchronized (object) {
                        if (this.m_db == null) {
                            this.m_db = database;
                            database.addProviderListener((DBObjectProviderListener)this);
                            Connections.this.initializeConnection(this.getConnectionDetails());
                            Connections.this.fireConnectionEvent(new ConnectionEvent(0, this.m_key.getQualifiedName()), true);
                        }
                    }
                }
            }
            return database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkDatabase() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_db != null;
            }
        }

        long getConnectStart() {
            return this.m_connectStart;
        }

        ConnectionDetails getConnectionDetails() {
            return this.getConnectionDetails(false);
        }

        ConnectionDetails getConnectionDetails(boolean bl) {
            String string = this.m_key.getQualifiedName();
            Connection connection = null;
            if (this.m_db != null) {
                try {
                    connection = this.m_db.getConnection(false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            Properties properties = this.getConnectionProperties();
            return new ConnectionDetails(string, connection, properties, this.m_db, false, bl);
        }

        String getConnectionType() {
            if (this.m_type == null) {
                Properties properties = this.getConnectionProperties();
                if (properties != null) {
                    String string = properties.getProperty("subtype");
                    if ("oraJDBC".equals(string)) {
                        this.m_type = "Oracle";
                    } else {
                        String string2 = properties.getProperty("driver");
                        if ("com.timesten.jdbc.TimesTenDriver".equals(string2) || "com.timesten.jdbc.TimesTenClientDriver".equals(string2)) {
                            this.m_type = "TimesTen";
                        }
                    }
                }
                if (this.m_type == null) {
                    this.m_type = "Generic";
                }
            }
            return this.m_type;
        }

        public void providerReloaded(DBObjectProvider dBObjectProvider) {
            Connections.this.initializeConnection(this.getConnectionDetails(true));
        }
    }

    public static interface NameFilter {
        public boolean accept(Candidate var1);
    }

    public static final class Candidate {
        private final String mName;
        private final Properties mProps;
        private final boolean mOpen;

        static Candidate createCandidate(ConnectionInfo connectionInfo) {
            String string = connectionInfo.getConnectionKey().getQualifiedName();
            Properties properties = connectionInfo.getConnectionProperties();
            boolean bl = connectionInfo.checkDatabase();
            return new Candidate(string, properties, bl);
        }

        private Candidate(String string, Properties properties, boolean bl) {
            this.mName = string;
            this.mProps = properties;
            this.mOpen = bl;
        }

        public String getName() {
            return this.mName;
        }

        public Properties getProperties() {
            return this.mProps;
        }

        public boolean isOpen() {
            return this.mOpen;
        }
    }

    public static class ConnectionKey {
        private String m_name;
        private String m_qual;
        private String m_store;

        private static ConnectionKey createConnectionKey(String string) {
            return string != null ? new ConnectionKey(string) : null;
        }

        public static ConnectionKey createConnectionKey(String string, String string2) {
            return string2 != null ? new ConnectionKey(string, string2) : null;
        }

        private ConnectionKey(String string) {
            this.m_qual = string;
            try {
                String string2 = URLDecoder.decode(string, "utf-8");
                int n = string2.indexOf(35);
                if (n != -1) {
                    this.m_store = string2.substring(0, n);
                    this.m_name = string2.substring(n + 1);
                } else {
                    this.m_store = "";
                    this.m_name = string2;
                }
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getMessage());
            }
        }

        private ConnectionKey(String string, String string2) {
            this.m_store = ModelUtil.hasLength((String)string) ? string : null;
            this.m_name = string2;
            try {
                String string3 = this.m_store != null ? this.m_store + "#" + this.m_name : this.m_name;
                this.m_qual = URLEncoder.encode(string3, "utf-8");
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getMessage());
            }
        }

        public boolean equals(Object object) {
            return object == this || object instanceof ConnectionKey && ModelUtil.areEqual((Object)this.m_store, (Object)((ConnectionKey)object).m_store) && ModelUtil.areEqual((Object)this.m_name, (Object)((ConnectionKey)object).m_name);
        }

        public String getConnectionName() {
            return this.m_name;
        }

        public String getQualifiedName() {
            return this.m_qual;
        }

        public String getStoreName() {
            return this.m_store;
        }

        public int hashCode() {
            return this.getQualifiedName().hashCode();
        }

        public String toString() {
            return this.getQualifiedName();
        }
    }
}

