/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usage;

import java.sql.Connection;
import java.util.logging.Logger;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.usage.DBUsageTracker;
import oracle.dbtools.raptor.usage.EditorTracker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;

public class UsageTrackerInitializer {
    private static EditorListener _editorListener = null;
    private static ConnectionListener _connListener;

    public static void init() {
        EditorManager.getEditorManager().addEditorListener(UsageTrackerInitializer.getEditorListener());
        Connections.getInstance().addConnectionListener(UsageTrackerInitializer.getConnectionListener());
    }

    private static ConnectionListener getConnectionListener() {
        if (_connListener == null) {
            _connListener = new ConnectionListener(){

                @Override
                public void connectionAdded(ConnectionEvent connectionEvent) {
                }

                @Override
                public void connectionRemoved(ConnectionEvent connectionEvent) {
                }

                @Override
                public void connectionRenamed(ConnectionEvent connectionEvent) {
                }

                @Override
                public void connectionModified(ConnectionEvent connectionEvent) {
                }

                @Override
                public void connectionOpened(ConnectionEvent connectionEvent) {
                    try {
                        Connection connection = Connections.getInstance().getConnection(connectionEvent.getConnectionName());
                        if (connection != null) {
                            DBUsageTracker dBUsageTracker = new DBUsageTracker("connection", "open");
                            dBUsageTracker.addProperty("db-name", connection.getMetaData().getDatabaseProductName());
                            dBUsageTracker.addProperty("db-version", connection.getMetaData().getDatabaseProductVersion());
                            dBUsageTracker.track();
                        }
                    }
                    catch (Exception exception) {
                        Logger.getAnonymousLogger().info(exception.getLocalizedMessage());
                    }
                }

                @Override
                public void connectionClosed(ConnectionEvent connectionEvent) {
                }
            };
        }
        return _connListener;
    }

    private static EditorListener getEditorListener() {
        if (_editorListener == null) {
            _editorListener = new EditorTracker();
        }
        return _editorListener;
    }
}

