/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControlPanel;

public class FileSizeActionControl
extends ActionControl {
    public static final String SIZE = "Size";
    public static final String UNIT = "Unit";
    public static final String BYTES = "Bytes";
    public static final String SIZE_CLAUSE = "SizeClause";
    private FileSizeActionControlPanel _panel;
    private long _defaultSize;

    public FileSizeActionControl(String string, String string2) {
        this(string, string2, 0L);
    }

    public FileSizeActionControl(String string, String string2, long l) {
        super(string, string2);
        this._defaultSize = l;
        this._panel = new FileSizeActionControlPanel(this._defaultSize);
        this._panel.getSizeFormattedTextField().setName(string + "_Size");
        this._panel.getSizeFormattedTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FileSizeActionControl.this.firePropertyChangeListeners();
            }
        });
        this._panel.getUnitsComboBox().setName(string + "_Unit");
        this._panel.getUnitsComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileSizeActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.add(SIZE, this._panel.getSizeText());
        value.add(UNIT, this._panel.getUnits());
        value.add(BYTES, Long.toString(this._panel.getSizeBytes()));
        value.add(SIZE_CLAUSE, this._panel.getSizeClause());
        return value;
    }

    @Override
    public Component getUI() {
        return this._panel;
    }

    @Override
    public void reset() {
        this._panel.reset();
    }

    @Override
    public void setEditable(boolean bl) {
        this._panel.setEditable(bl);
    }
}

