/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.newscriptrunner.IGetHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandlePauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandleSetPauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedAcceptProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedConnectFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedPasswordFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedSubstitutionProvider;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class GuiScriptRunnerContext
extends ScriptRunnerContext {
    private BasicEditorPane _editor;

    public GuiScriptRunnerContext() {
        this.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
        this.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
        this.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
        this.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
        this.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
        this.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
        this.setEncoding(IdeUtil.getIdeEncoding());
    }

    public String getStringTerminator() {
        if (Ide.isRunning()) {
            return Ide.getEnvironOptions().getLineBreakSequence();
        }
        return System.getProperty("line.separator");
    }

    public void setEditorComponenet(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
    }

    public BasicEditorPane getEditorComponenet() {
        return this._editor;
    }

    public String getScriptText() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (GuiScriptRunnerContext.this.m_scriptStartIndex != -1) {
                        GuiScriptRunnerContext.this._editor.setSelectionStart(GuiScriptRunnerContext.this.m_scriptStartIndex);
                        GuiScriptRunnerContext.this._editor.setSelectionEnd(GuiScriptRunnerContext.this.m_scriptEndIndex);
                        GuiScriptRunnerContext.this.m_EditorText = GuiScriptRunnerContext.this._editor.getSelectedText();
                    } else if (((BasicDocument)GuiScriptRunnerContext.this._editor.getDocument()).getTextBuffer().getLength() < 5000000) {
                        GuiScriptRunnerContext.this.m_EditorText = GuiScriptRunnerContext.this._editor.getText().replaceAll("\r\n", "\n");
                    } else {
                        GuiScriptRunnerContext.this.m_EditorText = null;
                    }
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    GuiScriptRunnerContext.this.m_EditorText = null;
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
        }
        return this.m_EditorText;
    }

    public String getSettingsDir() {
        if (Ide.isRunning()) {
            return Ide.getUserSettingsDirectory();
        }
        Object object = null;
        object = System.getProperty("ide.pref.dir");
        if (object == null) {
            object = System.getProperty("ide.base.dir");
        }
        if (object == null) {
            object = System.getProperty("user.home") + File.separator + ".sqldeveloper";
        }
        try {
            if (!new File((String)object).exists()) {
                new File((String)object).mkdir();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return object;
    }

    public GuiScriptRunnerContext clone() {
        GuiScriptRunnerContext guiScriptRunnerContext = new GuiScriptRunnerContext();
        guiScriptRunnerContext.set_autoprint(this.get_autoprint());
        guiScriptRunnerContext.setTTitleFlag(this.getTTitleFlag());
        guiScriptRunnerContext.setBTitleFlag(this.getBTitleFlag());
        guiScriptRunnerContext.setBTitle(this.getBTitle());
        guiScriptRunnerContext.setTTitle(this.getTTitle());
        guiScriptRunnerContext.setBTitleCmd(this.getBTitleCmd());
        guiScriptRunnerContext.setTTitleCmd(this.getTTitleCmd());
        guiScriptRunnerContext.setStoredFormatCmds(this.getStoredFormatCmds());
        guiScriptRunnerContext.setSavepoints(this.getSavePoints());
        guiScriptRunnerContext.consumerRuning(false);
        guiScriptRunnerContext.setdbmsEnable(this.isDbmsEnabled());
        guiScriptRunnerContext.setEncoding(this.getEncoding());
        guiScriptRunnerContext.setCurrentConnection(this.getCurrentConnection());
        guiScriptRunnerContext.set_autoprint(this.get_autoprint());
        guiScriptRunnerContext.setVarMap(this.getVarMap());
        guiScriptRunnerContext.setVerify(this.isVerifyOn());
        guiScriptRunnerContext.setEcho(this.isEchoOn());
        guiScriptRunnerContext.setFeedback(this.getFeedback());
        guiScriptRunnerContext.setSupressOutput(this.isOutputSupressed());
        guiScriptRunnerContext.setProperties(this.getProperties());
        guiScriptRunnerContext.setLastUrl(this.getLastUrl());
        guiScriptRunnerContext.setTerminateChar(this.getTerminateChar());
        guiScriptRunnerContext.setSubstitutionTerminateChar(this.getSubstitutionTerminateChar());
        guiScriptRunnerContext.setEscapeChar(this.getEscapeChar());
        guiScriptRunnerContext.setScanOn(this.getScanOn());
        guiScriptRunnerContext.setSubstitutionChar(this.getSubstitutionChar());
        guiScriptRunnerContext.setSubstitutionOn(this.getSubstitutionOn());
        guiScriptRunnerContext.setMap(this.getMap());
        guiScriptRunnerContext.setColumnMap(this.getColumnMap());
        guiScriptRunnerContext.setSqlError(this.getSqlError());
        guiScriptRunnerContext.setOsError(this.getOsError());
        guiScriptRunnerContext.setCloseConnection(this.getCloseConnection());
        guiScriptRunnerContext.setEscape(this.getEscape());
        guiScriptRunnerContext.setReturnExited(this.getReturnExited());
        guiScriptRunnerContext.setBaseConnection(this.getBaseConnection());
        guiScriptRunnerContext.setNLSMap(this.getNLSMap());
        guiScriptRunnerContext.setSourceRef(this.getSourceRef());
        guiScriptRunnerContext.setPromptedFieldProvider(this.getPromptedFieldProvider());
        guiScriptRunnerContext.setSubstitutionFieldProvider(this.getSubstitutionFieldProvider());
        guiScriptRunnerContext.setPasswordFieldsProvider(this.getPasswordFieldsProvider());
        guiScriptRunnerContext.setHandlePauseProvider(this.getHandlePauseProvider());
        guiScriptRunnerContext.setHandleSetPauseProvider(this.getHandleSetPauseProvider());
        guiScriptRunnerContext.setEditorComponenet(this.getEditorComponenet());
        return guiScriptRunnerContext;
    }
}

