/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.dialogs.schemacopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.schemacopy.DropConfirmationPrompter;
import oracle.dbtools.raptor.schemacopy.IAutoRefresh;
import oracle.dbtools.raptor.schemacopy.Messages;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class CopyAPI {
    private String encoding = IdeUtil.getIdeEncoding();
    private Context context;
    private String copyLogName;
    private Connection _fromConn;
    private Connection _toConn;
    private String fromName = null;
    private boolean _cancel = false;
    private String _type = null;
    private File _file;
    private OutputStream fout;
    private BufferedOutputStream bout;
    private OutputStreamWriter _out;
    private RaptorTask<Void> _task;
    private boolean _suppressLogging;
    private IAutoRefresh _treeRefreshCallback;
    private ArrayList<DBObject> _dndObjectList = new ArrayList();
    public static final String COPYAPI_APPEND_ROWS = "Append Rows";
    public static final String COPYAPI_DROP = "DROP";
    public static final String COPYAPI_TRUNC = "TRUNC";
    public static final String COPYAPI_NONE = "NONE";
    protected static final String EXISTS_SQL = "exists_sql";
    private String _EOL = null;
    int _step = 0;

    public synchronized void setType(String string) {
        this._type = string;
    }

    public synchronized String getType() {
        return this._type;
    }

    public CopyAPI(Connection connection, Connection connection2, String string) {
        this._type = string;
        this._fromConn = connection;
        this.fromName = Connections.getInstance().getConnectionName(this._fromConn);
        this._toConn = connection2;
    }

    private static synchronized LinkedHashMap<String, String> getOrderedTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("DATA", "Oracle#DATA");
        linkedHashMap.put("CONSTRAINT", "Oracle#CONSTRAINT");
        linkedHashMap.put("INDEX", "Oracle#INDEX");
        linkedHashMap.put("REFCONSTRAINT", "Oracle#REFCONSTRAINT");
        linkedHashMap.put("TRIGGER", "Oracle#TRIGGER");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        return linkedHashMap;
    }

    private static synchronized LinkedHashMap<String, String> getDropTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        return linkedHashMap;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public synchronized void copyWithDialog(IAutoRefresh iAutoRefresh) {
        this._treeRefreshCallback = iAutoRefresh;
        this.copyWithDialog();
    }

    public void copyWithDialog() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DatabaseCopyArb.getString("COPY_START"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){
            private volatile Thread m_execThread;

            public Void doWork() {
                this.m_execThread = Thread.currentThread();
                try {
                    this.checkCanProceed();
                    CopyAPI.this.doCopy();
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    this.getDescriptor().setMessage("Query Cancelled");
                    CopyAPI.this.initObjectFilters(null, false);
                    CopyAPI.this._treeRefreshCallback = null;
                }
                finally {
                    this.m_execThread = null;
                }
                return null;
            }

            public boolean cancel() {
                Thread thread = this.m_execThread;
                if (thread != null) {
                    DBUtil.cancelExecution((Thread)thread);
                    CopyAPI.this._cancel = true;
                    return true;
                }
                return false;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        RaptorTaskDescriptor raptorTaskDescriptor = raptorTask.getDescriptor();
        raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CopyAPI.this._treeRefreshCallback != null) {
                            CopyAPI.this._treeRefreshCallback.refresh();
                        }
                        try {
                            if (!CopyAPI.this._suppressLogging) {
                                TextNode textNode = new TextNode(URLFactory.newFileURL((File)CopyAPI.this._file));
                                CopyAPI.this.context = Context.newIdeContext((Node)textNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(CopyAPI.this.context);
                                openEditorOptions.setFlags(1);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        finally {
                            CopyAPI.this._treeRefreshCallback = null;
                            CopyAPI.this.initObjectFilters(null, false);
                        }
                    }
                });
            }
        });
        this._task = raptorTask;
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this._task != null) {
            raptorTaskDescriptor = this._task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    public synchronized void initObjectFilters(ArrayList<DatabaseNode> arrayList, boolean bl) {
        DBObject dBObject = null;
        this._dndObjectList.clear();
        this._suppressLogging = bl;
        if (arrayList != null) {
            for (DatabaseNode databaseNode : arrayList) {
                dBObject = databaseNode instanceof ObjectNode ? new DBObject((Element)((ObjectNode)databaseNode).getData()) : (databaseNode instanceof PlSqlNode ? new DBObject((Element)((PlSqlNode)databaseNode).getData()) : null);
                if (dBObject == null) continue;
                this._dndObjectList.add(dBObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doCopy() {
        block52: {
            Iterator<Map.Entry<String, String>> iterator;
            Object object6;
            Object object2;
            Object object32;
            Object object4;
            boolean bl;
            String string;
            ArrayList<Object> arrayList;
            DDLGenerator dDLGenerator;
            block50: {
                this.openLog();
                try {
                    Object object5;
                    Object object7;
                    dDLGenerator = DDLGenerator.getInstance();
                    LinkedHashMap<String, String> linkedHashMap = CopyAPI.getOrderedTypes();
                    arrayList = new ArrayList();
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    LinkedHashMap<String, String> linkedHashMap2 = null;
                    List<Object> list = null;
                    string = null;
                    bl = false;
                    this.setProg(DatabaseCopyArb.getString("COPY_GEN"));
                    if (this._dndObjectList == null || this._dndObjectList.isEmpty()) {
                        try {
                            object7 = this._fromConn.getMetaData().getUserName();
                            for (Map.Entry<String, String> object62 : linkedHashMap.entrySet()) {
                                this.checkCancelled();
                                object5 = object62.getKey();
                                object32 = dDLGenerator.getSchemaObjects(this._fromConn, (String)object7, (String)object5, (String)(object4 = object62.getValue()));
                                if (object32 == null) continue;
                                object2 = ((ArrayList)object32).iterator();
                                while (object2.hasNext()) {
                                    object6 = (BasicDBObject)object2.next();
                                    this.checkCancelled();
                                    arrayList.add(object6);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            this.lineError();
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                            this.closeLog();
                            return;
                        }
                        if (this._type.equals(COPYAPI_DROP)) {
                            linkedHashMap2 = CopyAPI.getDropTypes();
                            list = new ArrayList();
                            try {
                                object7 = this._fromConn.getMetaData().getUserName();
                                for (Map.Entry<String, String> entry : linkedHashMap2.entrySet()) {
                                    this.checkCancelled();
                                    object5 = entry.getKey();
                                    object32 = dDLGenerator.getSchemaObjects(this._fromConn, (String)object7, (String)object5, (String)(object4 = entry.getValue()));
                                    if (object32 == null) continue;
                                    object2 = ((ArrayList)object32).iterator();
                                    while (object2.hasNext()) {
                                        object6 = (BasicDBObject)object2.next();
                                        this.checkCancelled();
                                        list.add(object6);
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                                this.lineError();
                                this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                            }
                            this.dropDBObject(list);
                        }
                    } else {
                        arrayList = new ArrayList<DBObject>(this._dndObjectList);
                        object7 = null;
                        for (BasicDBObject basicDBObject : arrayList) {
                            this.checkCancelled();
                            if (!"TABLE".equals(basicDBObject.getObjectType())) continue;
                            object5 = DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(this._fromConn), null, basicDBObject.getSchemaName(), "DATA");
                            object4 = DBURLFormatHelper.getURL((URL)object5, basicDBObject.getObjectName());
                            object7 = new DBObject((URL)object4);
                            arrayList2.add(object7);
                        }
                        arrayList.addAll(arrayList2);
                        list = this.buildDropListForGetTypes(this._toConn, arrayList);
                        if (list != null && !list.isEmpty()) {
                            DropConfirmationPrompter.getUserActionForDuplicate(this, this.isTableType(list));
                            if (this._type.equals(COPYAPI_DROP)) {
                                this.dropDBObject(list);
                            } else if (this._type.equals(COPYAPI_APPEND_ROWS)) {
                                bl = true;
                            } else if (this._type.equals(COPYAPI_NONE)) {
                                return;
                            }
                        }
                    }
                    object7 = new ArrayList();
                    iterator = new ArrayList();
                    Object var11_19 = null;
                    object5 = null;
                    if (!this._type.equals(COPYAPI_TRUNC)) break block50;
                    if (this._dndObjectList == null || this._dndObjectList.isEmpty()) {
                        String string2 = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
                    } else {
                        object4 = null;
                        object32 = null;
                        for (Object object6 : arrayList) {
                            this.checkCancelled();
                            if (object4 != null) continue;
                            object4 = new StringBuilder(" (");
                            ((StringBuilder)object4).append("'");
                            ((StringBuilder)object4).append(object6.getObjectName());
                            ((StringBuilder)object4).append("'");
                            ((StringBuilder)object4).append(", ");
                        }
                        if (object4 != null) {
                            object32 = ((StringBuilder)object4).toString();
                            object32 = ((StringBuilder)object4).substring(0, ((StringBuilder)object4).lastIndexOf(", ")) + ")";
                        }
                        String string3 = "select table_name,constraint_name from user_constraints where constraint_type = 'R' AND table_name IN " + (String)object32;
                    }
                    if (Connections.getInstance().lock(this.fromName)) {
                        void var11_22;
                        object5 = DBUtil.getInstance((String)this.fromName).executeQuery((String)var11_22, Collections.emptyList());
                        try {
                            if (object5 != null) {
                                while (object5.next()) {
                                    this.checkCancelled();
                                    ((ArrayList)object7).add("alter table \"" + object5.getString(1) + "\" disable constraint \"" + object5.getString(2) + "\"");
                                    ((ArrayList)((Object)iterator)).add((Map.Entry<String, String>)((Object)((CallSite)((Object)("alter table \"" + object5.getString(1) + "\" enable constraint \"" + object5.getString(2) + "\"")))));
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            this.lineError();
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                            this.closeLog();
                            return;
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)object5);
                            Connections.getInstance().unlock(this.fromName);
                        }
                    }
                    object4 = ((ArrayList)object7).iterator();
                }
                catch (InterruptedException interruptedException) {
                    this.log(CopyPanelArb.getString("COPY_CANCELED") + this.getTerm());
                    this.lineEnd();
                }
                finally {
                    this.closeLog();
                }
                while (object4.hasNext()) {
                    object32 = (String)object4.next();
                    this.checkCancelled();
                    this.setProg(DatabaseCopyArb.getString("DISABLE_CONST"));
                    this.lineStart();
                    this.log((String)object32 + this.getTerm());
                    this.log(ScriptUtils.runSqlReturnResult((String)object32, this._toConn));
                    this.lineEnd();
                }
            }
            for (Object object32 : arrayList) {
                try {
                    this.checkCancelled();
                }
                catch (InterruptedException interruptedException) {
                    if (this._type.equals(COPYAPI_TRUNC)) {
                        object6 = ((ArrayList)((Object)iterator)).iterator();
                        while (object6.hasNext()) {
                            String string4 = (String)object6.next();
                            this.setProg(DatabaseCopyArb.getString("ENABLE_CONST"));
                            this.log(string4 + this.getTerm());
                            this.log(ScriptUtils.runSqlReturnResult(string4, this._toConn));
                        }
                    }
                    this.lineError();
                    throw interruptedException;
                }
                if (object32.getObjectType().equals("DATA")) {
                    this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + object32.getObjectName());
                    object2 = new DataMover(this._fromConn, this._toConn);
                    ((DataMover)((Object)object2)).setLogFile(this._out);
                    this.lineStart();
                    this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + object32.getObjectName() + this.getTerm());
                    this.lineEnd();
                    ((DataMover)((Object)object2)).move((BasicDBObject)object32, true);
                    continue;
                }
                if (!bl && !this._type.equals(COPYAPI_TRUNC) || this._type.equals(COPYAPI_TRUNC) && !object32.getObjectType().equals("TABLE") && !object32.getObjectType().equals("REFCONSTRAINT") && !object32.getObjectType().equals("CONSTRAINT")) {
                    try {
                        this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + object32.getObjectName());
                        object2 = "set define off;\n" + dDLGenerator.getCopyDDL((BasicDBObject)object32);
                        object6 = ((String)object2).replaceAll("\"" + object32.getSchemaName() + "\"\\.", "");
                        if (object32.getObjectType().equals("QUEUE TABLE") || object32.getObjectType().equals("QUEUE")) {
                            object6 = ((String)object2).replaceAll("'" + object32.getSchemaName() + ".", "'");
                        }
                        if (((String)object6).equals("")) continue;
                        this.lineStart();
                        this.log((String)object6 + this.getTerm());
                        this.log(ScriptUtils.runSqlReturnResult((String)object6, this._toConn));
                        this.lineEnd();
                    }
                    catch (Exception exception) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + object32.getObjectName() + this.getTerm() + exception.getMessage() + this.getTerm());
                    }
                    continue;
                }
                if (!this._type.equals(COPYAPI_TRUNC) || !object32.getObjectType().equals("TABLE")) continue;
                this.setProg(DatabaseCopyArb.getString("TRUNC_OBJ") + " " + object32.getObjectName());
                string = "  truncate " + object32.getObjectType() + " \"" + object32.getObjectName() + "\"";
                this.lineStart();
                this.log(string + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult(string, this._toConn));
                this.lineEnd();
            }
            if (!this._type.equals(COPYAPI_TRUNC)) break block52;
            object4 = ((ArrayList)((Object)iterator)).iterator();
            while (object4.hasNext()) {
                object32 = (String)object4.next();
                this.setProg(DatabaseCopyArb.getString("ENABLE_CONST"));
                this.lineStart();
                this.log((String)object32 + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult((String)object32, this._toConn));
                this.lineEnd();
            }
        }
    }

    private boolean isTableType(List<BasicDBObject> list) {
        boolean bl = false;
        if (list != null) {
            for (BasicDBObject basicDBObject : list) {
                if (!"TABLE".equals(basicDBObject.getObjectType())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private List<BasicDBObject> buildDropListForGetTypes(Connection connection, List<BasicDBObject> list) {
        ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>();
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        try {
            if (list != null && !list.isEmpty()) {
                string = this.getQuery(this._toConn, EXISTS_SQL);
                for (BasicDBObject basicDBObject : list) {
                    hashMap.put("TYPE", basicDBObject.getObjectType());
                    hashMap.put("OWNER", connection.getMetaData().getUserName());
                    hashMap.put("OBJECT_NAME", basicDBObject.getObjectName());
                    string2 = DBUtil.getInstance((Connection)this._toConn).executeOracleReturnOneCol(string, hashMap);
                    if (!"x".equals(string2)) continue;
                    arrayList.add(basicDBObject);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private Query getQueryFromFile(Connection connection, String string, MetaResource metaResource) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)metaResource);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    private MetaResource getDefaultQueryFile() {
        return new MetaResource(this.getClass().getClassLoader(), "/oracle/dbtools/raptor/ddl/oracle/ObjectSql.xml");
    }

    private final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getDefaultQueryFile());
        return query.getSql();
    }

    private void dropDBObject(List<BasicDBObject> list) throws InterruptedException {
        String string = null;
        for (BasicDBObject basicDBObject : list) {
            this.checkCancelled();
            string = basicDBObject.getObjectType().equals("MATERIALIZED VIEW LOG") ? "  DROP " + basicDBObject.getObjectType() + " on \"" + basicDBObject.getObjectName() + "\";" : (basicDBObject.getObjectType().equals("TABLE") ? "  DROP " + basicDBObject.getObjectType() + " \"" + basicDBObject.getObjectName() + "\" cascade constraints;" : (basicDBObject.getObjectType().equals("QUEUE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + basicDBObject.getObjectName() + "', auto_commit=>TRUE);" + this._EOL + "end;" : (basicDBObject.getObjectType().equals("QUEUE TABLE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + basicDBObject.getObjectName() + "', force=>TRUE);" + this._EOL + "end;" : "  DROP " + basicDBObject.getObjectType() + " \"" + basicDBObject.getObjectName() + "\";")));
            this.setProg(DatabaseCopyArb.getString("DROP_OBJ") + " " + basicDBObject.getObjectName());
            this.lineStart();
            this.log(string + this.getTerm());
            this.log(ScriptUtils.runSqlReturnResult(string, this._toConn));
            this.lineEnd();
        }
    }

    private String getStep() {
        ++this._step;
        return Integer.toString(this._step);
    }

    private void clearStep() {
        this._step = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> getSummary() {
        this.clearStep();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap2 = CopyAPI.getOrderedTypes();
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        LinkedList<CallSite> linkedList2 = new LinkedList<CallSite>();
        ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>();
        if (Connections.getInstance().lock(this._fromConn)) {
            block27: {
                try {
                    Object object;
                    Object object2;
                    Iterator iterator;
                    try {
                        iterator = this._fromConn.getMetaData().getUserName();
                        for (String string : linkedHashMap2.keySet()) {
                            Object object3 = linkedHashMap2.get(string);
                            Object object4 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, (String)((Object)iterator), string, (String)object3);
                            if (object4 == null) continue;
                            object2 = ((ArrayList)object4).iterator();
                            while (object2.hasNext()) {
                                object = (BasicDBObject)object2.next();
                                arrayList.add((BasicDBObject)object);
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                    }
                    if (this._type.equals(COPYAPI_DROP)) {
                        iterator = CopyAPI.getDropTypes();
                        ArrayList<BasicDBObject> arrayList2 = new ArrayList<BasicDBObject>();
                        try {
                            String string = this._fromConn.getMetaData().getUserName();
                            for (Object object4 : ((LinkedHashMap)((Object)iterator)).keySet()) {
                                object2 = (String)((LinkedHashMap)((Object)iterator)).get(object4);
                                object = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, string, (String)object4, (String)object2);
                                if (object == null) continue;
                                Iterator iterator2 = ((ArrayList)object).iterator();
                                while (iterator2.hasNext()) {
                                    BasicDBObject basicDBObject = (BasicDBObject)iterator2.next();
                                    arrayList2.add(basicDBObject);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                        }
                        for (Object object3 : arrayList2) {
                            linkedHashMap.put(this.getStep(), " DROP " + object3.getObjectType() + " " + object3.getObjectName());
                        }
                    }
                    if (!this._type.equals(COPYAPI_TRUNC)) break block27;
                    iterator = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
                    ResultSet resultSet = DBUtil.getInstance((String)this.fromName).executeQuery((String)((Object)iterator), Collections.emptyList());
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                linkedList.add((CallSite)((Object)("DISABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1))));
                                linkedList2.add((CallSite)((Object)("ENABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1))));
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                finally {
                    Connections.getInstance().unlock(this._fromConn);
                }
            }
            for (String string : linkedList) {
                linkedHashMap.put(this.getStep(), string);
            }
            for (BasicDBObject basicDBObject : arrayList) {
                if (basicDBObject.getObjectType().equals("DATA")) {
                    linkedHashMap.put(this.getStep(), CopyWizArb.getString("MOVE_DATA_MESSAGE") + basicDBObject.getObjectName());
                    continue;
                }
                if (!this._type.equals(COPYAPI_TRUNC) || this._type.equals(COPYAPI_TRUNC) && !basicDBObject.getObjectType().equals("TABLE") && !basicDBObject.getObjectType().equals("REFCONSTRAINT") && !basicDBObject.getObjectType().equals("CONSTRAINT")) {
                    linkedHashMap.put(this.getStep(), "CREATE " + basicDBObject.getObjectType() + " " + basicDBObject.getObjectName());
                    continue;
                }
                if (!this._type.equals(COPYAPI_TRUNC) || !basicDBObject.getObjectType().equals("TABLE")) continue;
                linkedHashMap.put(this.getStep(), "TRUNCATE " + basicDBObject.getObjectName());
            }
            if (this._type.equals(COPYAPI_TRUNC)) {
                for (String string : linkedList2) {
                    linkedHashMap.put(this.getStep(), string);
                }
            }
        }
        return linkedHashMap;
    }

    public void cancel() {
        this._cancel = true;
    }

    private void openLog() {
        if (!this._suppressLogging) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
                StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
                this.copyLogName = Ide.getUserSettingsDirectory() + "SchemaCopy." + stringBuilder + ".log";
                this._file = new File(this.copyLogName);
                this.fout = new FileOutputStream(this._file.getPath());
                this.bout = new BufferedOutputStream(this.fout);
                this._out = new OutputStreamWriter((OutputStream)this.bout, this.encoding);
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(this._file.getPath() + this._file.getName()), null);
            }
        }
    }

    private void lineStart() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.169") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineEnd() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.170") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineError() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.171") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String string) {
        try {
            if (this._out != null) {
                this._out.write(string + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeLog() {
        try {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkCancelled() throws InterruptedException {
        if (Thread.interrupted() || this._cancel) {
            throw new InterruptedException();
        }
    }
}

