/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner.debug;

import java.awt.Color;
import java.awt.SystemColor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.dbtools.util.Logger;
import oracle.ide.config.Preferences;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.JDebugger;

class DebuggerSettings
extends HashStructureAdapter
implements Copyable {
    static final String START_RUNNING = "running";
    static final String START_STEPOVER = "stepover";
    static final String START_STEPINTO = "stepinto";
    private static final String CONNECTION_RETRIES = "connectionRetries";
    private static final String TOOLTIP_IN_CODE_EDITOR = "toolTipInCodeEditor";
    private static final String ACTION_BUTTONS_ON_TOOLBAR = "actionButtonsOnToolbar";
    private static final String PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING = "promptForDebuggerHostForDatabaseDebugging";
    private static final String LOCAL_PORT_RANGE = "localPortRange";
    private static final String DETECT_METHOD_EVAL_DEADLOCKS = "detectMethodEvaluationDeadlocks";
    private static final String LOCAL_PORT_RANGE_MIN = "localPortRangeMin";
    private static final String LOCAL_PORT_RANGE_MAX = "localPortRangeMax";
    private static final String START_OPTION = "startOption";
    private static final String CHANGE_TRACKING_ENABLED = "changeTrackingEnabled";
    private static final String CHANGED_TABLECELL_FOREGROUND_COLOR = "changedCellForeground";
    private static final String CHANGED_TABLECELL_BACKGROUND_COLOR = "changedCellBackground";
    private static final String DATABASE_DEBUG_PROTOCOL = "dbDebugProtocol";

    static DebuggerSettings getDefaultInstance() {
        return DebuggerSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public static DebuggerSettings getInstance(PropertyStorage propertyStorage) {
        return new DebuggerSettings(DebuggerSettings.findOrCreate((PropertyStorage)propertyStorage, (String)"DebugWindowOptions"));
    }

    private DebuggerSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public int getConnectionRetries() {
        return this._hash.getInt(CONNECTION_RETRIES, 5);
    }

    public void setConnectionRetries(int n) {
        this._hash.putInt(CONNECTION_RETRIES, n);
    }

    public boolean isShowToolTipInCodeEditor() {
        return this._hash.getBoolean(TOOLTIP_IN_CODE_EDITOR, true);
    }

    public void setShowToolTipInCodeEditor(boolean bl) {
        this._hash.putBoolean(TOOLTIP_IN_CODE_EDITOR, bl);
    }

    public boolean isShowActionButtonsOnToolbar() {
        return this._hash.getBoolean(ACTION_BUTTONS_ON_TOOLBAR, Product.isRaptor());
    }

    public void setShowActionButtonsOnToolbar(boolean bl) {
        this._hash.putBoolean(ACTION_BUTTONS_ON_TOOLBAR, bl);
    }

    public boolean isPromptForDebuggerHostForDatabaseDebugging() {
        return this._hash.getBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, false);
    }

    public void setPromptForDebuggerHostForDatabaseDebugging(boolean bl) {
        this._hash.putBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, bl);
    }

    public boolean isLocalPortRange() {
        return this._hash.getBoolean(LOCAL_PORT_RANGE, false);
    }

    public void setLocalPortRange(boolean bl) {
        this._hash.putBoolean(LOCAL_PORT_RANGE, bl);
    }

    public boolean isDetectMethodEvalDeadlocks() {
        return this._hash.getBoolean(DETECT_METHOD_EVAL_DEADLOCKS, true);
    }

    public void setDetectMethodEvalDeadlocks(boolean bl) {
        this._hash.putBoolean(DETECT_METHOD_EVAL_DEADLOCKS, bl);
    }

    public int getLocalPortRangeMin() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MIN, 4000);
    }

    public void setLocalPortRangeMin(int n) {
        this._hash.putInt(LOCAL_PORT_RANGE_MIN, n);
    }

    public int getLocalPortRangeMax() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MAX, 4999);
    }

    public void setLocalPortRangeMax(int n) {
        this._hash.putInt(LOCAL_PORT_RANGE_MAX, n);
    }

    public String getStartOption() {
        return this._hash.getString(START_OPTION, START_RUNNING);
    }

    public void setStartOption(String string) {
        this._hash.putString(START_OPTION, string);
    }

    public boolean isChangeTrackingEnabled() {
        return this._hash.getBoolean(CHANGE_TRACKING_ENABLED, true);
    }

    public void setChangeTrackingEnabled(boolean bl) {
        this._hash.putBoolean(CHANGE_TRACKING_ENABLED, bl);
    }

    public Color getChangedCellForegroundColor() {
        int n = this._hash.getInt(CHANGED_TABLECELL_FOREGROUND_COLOR);
        if (n != -1) {
            return new Color(n);
        }
        if (JDebugger.isUsingHighContrastTheme()) {
            return SystemColor.textHighlightText;
        }
        return SystemColor.black;
    }

    public void setChangedCellForegroundColor(Color color) {
        int n = color.getRGB();
        this._hash.putInt(CHANGED_TABLECELL_FOREGROUND_COLOR, n);
    }

    public Color getChangedCellBackgroundColor() {
        int n = this._hash.getInt(CHANGED_TABLECELL_BACKGROUND_COLOR, -1);
        if (n != -1) {
            return new Color(n);
        }
        if (JDebugger.isUsingHighContrastTheme()) {
            return SystemColor.textHighlight;
        }
        return new Color(251, 249, 210);
    }

    public void setChangedCellBackgroundColor(Color color) {
        int n = color.getRGB();
        this._hash.putInt(CHANGED_TABLECELL_BACKGROUND_COLOR, n);
    }

    public Protocol getDatabaseDebugProtocol() {
        String string = this._hash.getString(DATABASE_DEBUG_PROTOCOL, Protocol.DBMS_DEBUG_JDWP.name());
        return Protocol.valueOf(string);
    }

    public void setDatabaseDebugProtocol(Protocol protocol) {
        this._hash.putString(DATABASE_DEBUG_PROTOCOL, protocol.name());
    }

    void resetToStringBehavior() {
        try {
            Class<?> clazz = Class.forName("oracle.jdevimpl.runner.debug.ObjectPreferences");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            DataValueToStringBehavior dataValueToStringBehavior = new DataValueToStringBehavior();
            dataValueToStringBehavior.setUseToString(true);
            dataValueToStringBehavior.setUseToStringOnlyWhenNoExpressionSpecified(true);
            dataValueToStringBehavior.setUseToStringOnlyWhenOverridden(true);
            Method method2 = clazz.getDeclaredMethod("setUseToStringBehavior", String.class, DataValueToStringBehavior.class);
            method2.setAccessible(true);
            method2.invoke(object, "*", dataValueToStringBehavior);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Logger.severe(DebuggerSettings.class, (Throwable)exception);
        }
    }

    static enum Protocol {
        DBMS_DEBUG,
        DBMS_DEBUG_JDWP;

    }
}

