/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.runner.InvalidData;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.raptor.runner.Type;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

class Procedure {
    private static Map<String, BasicDocument> s_docMap = new HashMap<String, BasicDocument>();
    private String _owner;
    private String _package;
    private String _name;
    private int _id;
    private int _overload;
    private boolean _pipelined;
    Set<String> trEvents;
    private Database _db;
    private PlsqlRoot _parseTree;
    private String _displayValue;
    private ParamTableModel _model;
    private BasicDocument _document;
    List<Member> packageMembers = new LinkedList<Member>();
    Map<String, String> defaultParams = null;
    static final String path = "/oracle/dbtools/raptor/runner/";
    static SqlProgram defaultParProgramInstance = null;
    static SqlProgram startBlockProgramInstance = null;
    private String rollbackStr = "Procedure.rollback";
    static final String INDENT = "  ";
    private static Map<String, Map<String, Map<String, String>>> allDefaultParams = new HashMap<String, Map<String, Map<String, String>>>();

    public Procedure(String string, String string2, int n, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer, boolean bl, PlSqlNode plSqlNode) {
        this(string, null, string2, n, 0, database, plsqlRoot, textBuffer, bl, plSqlNode);
    }

    public Procedure(String string, String string2, String string3, int n, int n2, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer, boolean bl, PlSqlNode plSqlNode) {
        this._owner = string;
        this._package = string2;
        this._name = string3;
        this._id = n;
        this._overload = n2;
        this._pipelined = bl;
        this._db = database;
        this._parseTree = plsqlRoot;
        if (plSqlNode != null) {
            plSqlNode.addMembersTo(this.packageMembers);
        }
        if (startBlockProgramInstance == null) {
            try {
                startBlockProgramInstance = new SqlProgram(Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/start_block_proc_args.prg"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (defaultParProgramInstance == null) {
            try {
                defaultParProgramInstance = new SqlProgram(Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/default_par.prg"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.defaultParams = this.parseDefaultParams(string, string2, textBuffer).get(string3);
        if (this.defaultParams == null) {
            this.defaultParams = new HashMap<String, String>();
        }
    }

    public Procedure(String string, String string2, int n, String string3, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer, boolean bl) {
        this._owner = string;
        this._name = string2;
        this._id = n;
        this._db = database;
        this._parseTree = plsqlRoot;
        this._pipelined = bl;
        this.trEvents = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if ("OR".equals(string4)) continue;
            this.trEvents.add(string4);
        }
        if (startBlockProgramInstance == null) {
            try {
                startBlockProgramInstance = new SqlProgram(Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/start_block_proc_args.prg"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (defaultParProgramInstance == null) {
            try {
                defaultParProgramInstance = new SqlProgram(Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/default_par.prg"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.defaultParams = this.parseDefaultParams(string, "N/A", textBuffer).get(string2);
        if (this.defaultParams == null) {
            this.defaultParams = new HashMap<String, String>();
        }
    }

    public String toString() {
        if (this._displayValue == null) {
            this._displayValue = this._overload > 0 ? this._name + "(" + this._overload + ")" : this._name;
        }
        return this._displayValue;
    }

    public ParamTableModel getTableModel() throws SQLException {
        if (this._model == null) {
            this._model = new ParamTableModel(this);
        }
        return this._model;
    }

    public Connection getConnection() {
        return this._db.getConnection();
    }

    public String getPackage() {
        return this._package;
    }

    public String getName() {
        return this._name;
    }

    public int getOverload() {
        return this._overload;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getObjectID() {
        return this._id;
    }

    public PlsqlRoot getParseTree() {
        return this._parseTree;
    }

    public void saveDocument() {
        if (this._document != null) {
            s_docMap.put(this._getHashName(), this._document);
        }
    }

    public void resetDocument() {
        this._document = null;
        s_docMap.remove(this._getHashName());
    }

    public char[] generateRunBlock() throws SQLException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        boolean bl = true;
        String string = this._db.getConnection().getMetaData().getUserName();
        bl = ModelUtil.areDifferent((Object)string, (Object)this._owner);
        ParamTableModel paramTableModel = this.getTableModel();
        if (this.trEvents == null) {
            this.generateRunProcedure(fastStringBuffer, bl, paramTableModel);
        } else {
            this.generateRunTrigger(fastStringBuffer, bl, paramTableModel);
        }
        char[] cArray = new char[fastStringBuffer.length()];
        fastStringBuffer.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    Map<String, Pair<String, String>> parseAnonBlock(String string) throws InvalidData {
        TreeMap<String, Pair<String, String>> treeMap = new TreeMap<String, Pair<String, String>>();
        try {
            List list = LexerToken.parse((String)string);
            Map map = startBlockProgramInstance.run(string, list);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("params");
            for (Tuple tuple : materializedPredicate.getTuples()) {
                ParseNode parseNode = materializedPredicate.getAttribute(tuple, "name");
                ParseNode parseNode2 = materializedPredicate.getAttribute(tuple, "expr");
                ParseNode parseNode3 = materializedPredicate.getAttribute(tuple, "type");
                treeMap.put(parseNode.content(list), (Pair<String, String>)new Pair((Object)parseNode2.content(list), (Object)parseNode3.content(list)));
            }
            return treeMap;
        }
        catch (SyntaxError syntaxError) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StringBuilder updateAnonBlock(String string) throws InvalidData {
        try {
            List list = LexerToken.parse((String)string);
            Map map = startBlockProgramInstance.run(string, list);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("initializations");
            TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
            Iterator iterator = materializedPredicate.getTuples().iterator();
            while (true) {
                Object object;
                String string2;
                int n;
                ParseNode parseNode;
                Object object2;
                Object object3;
                if (iterator.hasNext()) {
                    object3 = (Tuple)iterator.next();
                    object2 = materializedPredicate.getAttribute((Tuple)object3, "name");
                    parseNode = materializedPredicate.getAttribute((Tuple)object3, "expr");
                    n = this.getTableModel().getRowCount();
                    string2 = null;
                } else {
                    int n2 = 0;
                    object3 = new StringBuilder();
                    object2 = treeMap.keySet().iterator();
                    while (true) {
                        if (!object2.hasNext()) {
                            ((StringBuilder)object3).append(string.substring(n2));
                            return object3;
                        }
                        long l = (Long)object2.next();
                        int n3 = Service.lX((long)l);
                        int n4 = Service.lY((long)l);
                        object = (String)treeMap.get(l);
                        ((StringBuilder)object3).append(string.substring(n2, n3));
                        n2 = n4;
                        ((StringBuilder)object3).append((String)object);
                    }
                }
                for (int i = 0; i < n; ++i) {
                    String string3;
                    String string4;
                    object = this.getTableModel().getParameter(i);
                    if (((Parameter)object).isReturn() || !(string4 = ((Parameter)object).getVarName()).equals(string3 = object2.content(list))) continue;
                    try {
                        String string5 = ((Parameter)object).formatValue();
                        if (parseNode.content(list).equals(string4)) break;
                        string2 = string5;
                        break;
                    }
                    catch (InvalidData invalidData) {
                        invalidData.priorValue = parseNode.content(list);
                        throw invalidData;
                    }
                }
                LexerToken lexerToken = (LexerToken)list.get(parseNode.from);
                object = (LexerToken)list.get(parseNode.to - 1);
                if (string2 == null) continue;
                treeMap.put(Service.lPair((int)lexerToken.begin, (int)((LexerToken)object).end), string2.toString());
            }
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
            return null;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void generateRunProcedure(FastStringBuffer fastStringBuffer, boolean bl, ParamTableModel paramTableModel) {
        int n = paramTableModel.getRowCount();
        if (n == 0) {
            fastStringBuffer.append("BEGIN\n  ");
            if (this._pipelined) {
                fastStringBuffer.append("SELECT * --row_type(col1,col2)\n         --bulk collect into v_Return\nFROM TABLE(");
            }
            fastStringBuffer.append(this._getCallName(bl, null));
            if (this._pipelined) {
                fastStringBuffer.append(")");
            }
            fastStringBuffer.append("();\n");
            this.addRollback(fastStringBuffer);
            fastStringBuffer.append("END;");
        } else {
            int n2;
            int n3;
            Parameter parameter = null;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            Parameter parameter2 = paramTableModel.getParameter(0);
            if (parameter2.isReturn()) {
                parameter = parameter2;
            } else {
                arrayList.add(parameter2);
            }
            for (n3 = 1; n3 < n; ++n3) {
                arrayList.add(paramTableModel.getParameter(n3));
            }
            n = arrayList.size();
            fastStringBuffer.append("DECLARE\n");
            for (n3 = 0; n3 < n; ++n3) {
                parameter2 = (Parameter)arrayList.get(n3);
                parameter2.generateDeclaration(fastStringBuffer);
            }
            if (parameter != null) {
                parameter.generateDeclaration(fastStringBuffer);
            }
            fastStringBuffer.append("BEGIN\n");
            String string = null;
            for (n2 = 0; n2 < n; ++n2) {
                Object object;
                parameter2 = (Parameter)arrayList.get(n2);
                String string2 = this.defaultParams.get(parameter2.getParamName());
                if (string2 != null) {
                    parameter2.setValue(string2);
                }
                if (!((Mode)(object = parameter2.getMode())).equals(Mode.OUT)) {
                    parameter2.generateInitialization(fastStringBuffer);
                }
                if (!parameter2.isObjectInstance()) continue;
                string = parameter2.getParamName();
            }
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            if (parameter != null && !this._pipelined) {
                fastStringBuffer.append(parameter.getVarName());
                fastStringBuffer.append(" := ");
            }
            if (this._pipelined) {
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("SELECT --*  \n");
                fastStringBuffer.append(INDENT);
                if (parameter != null) {
                    Type type = parameter.getType();
                    fastStringBuffer.append(type.getTupleType(this.getConnection()));
                    fastStringBuffer.append("(");
                    int n4 = -1;
                    for (String string3 : type.getAttributes(this.getConnection())) {
                        if (0 < ++n4) {
                            fastStringBuffer.append(",");
                        }
                        fastStringBuffer.append(string3);
                    }
                    fastStringBuffer.append(") \n");
                } else {
                    fastStringBuffer.append("     --row_type(col1,col2) \n");
                }
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("         bulk collect into " + (parameter != null ? parameter.getVarName() : "V_return") + "\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("FROM TABLE(");
            }
            fastStringBuffer.append(this._getCallName(bl, string));
            fastStringBuffer.append("(");
            if (n > 0) {
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                parameter2 = (Parameter)arrayList.get(0);
                parameter2.generateCallReference(fastStringBuffer, !this._pipelined);
                for (n2 = 1; n2 < n; ++n2) {
                    fastStringBuffer.append(",\n");
                    fastStringBuffer.append(INDENT);
                    parameter2 = (Parameter)arrayList.get(n2);
                    parameter2.generateCallReference(fastStringBuffer, !this._pipelined);
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
            }
            fastStringBuffer.append(")");
            if (this._pipelined) {
                fastStringBuffer.append(")");
            }
            fastStringBuffer.append(";\n");
            if (parameter != null) {
                parameter.generateResultOutput(fastStringBuffer);
            }
            for (n2 = 0; n2 < n; ++n2) {
                parameter2 = (Parameter)arrayList.get(n2);
                Mode mode = parameter2.getMode();
                if (mode.equals(Mode.IN)) continue;
                parameter2.generateResultOutput(fastStringBuffer);
            }
            this.addRollback(fastStringBuffer);
            fastStringBuffer.append("END;\n");
        }
    }

    private void addRollback(FastStringBuffer fastStringBuffer) {
        String string = NonUserConfigOptions.get(this.rollbackStr);
        if (string == null || !"true".equals(string)) {
            fastStringBuffer.append("--rollback; \n");
        } else {
            fastStringBuffer.append("rollback; \n");
        }
    }

    void persistRollback(String string) {
        NonUserConfigOptions.put(this.rollbackStr, "" + (string.contains("rollback;") && !string.contains("--rollback;")));
    }

    private void generateRunTrigger(FastStringBuffer fastStringBuffer, boolean bl, ParamTableModel paramTableModel) {
        fastStringBuffer.append("DECLARE\n");
        fastStringBuffer.append("BEGIN\n");
        for (String string : this.trEvents) {
            int n;
            int n2;
            if ("INSERT".equals(string)) {
                n2 = paramTableModel.getRowCount();
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("insert into ");
                fastStringBuffer.append(this._getCallName(bl, null));
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("(");
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",");
                    }
                    fastStringBuffer.append(paramTableModel.getParameter(n).getParamName());
                }
                fastStringBuffer.append(")\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("values\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("(");
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",");
                    }
                    fastStringBuffer.append(paramTableModel.getParameter(n).getValue());
                }
                fastStringBuffer.append(");\n");
            }
            if ("UPDATE".equals(string)) {
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("update ");
                fastStringBuffer.append(this._getCallName(bl, null));
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("set\n");
                n2 = paramTableModel.getRowCount();
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",\n");
                    }
                    fastStringBuffer.append(INDENT);
                    fastStringBuffer.append(INDENT);
                    fastStringBuffer.append(paramTableModel.getParameter(n).getParamName());
                    fastStringBuffer.append("=");
                    fastStringBuffer.append(paramTableModel.getParameter(n).getValue());
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("where 1=0;\n");
            }
            if (!"DELETE".equals(string)) continue;
            fastStringBuffer.append(INDENT);
            fastStringBuffer.append("delete from ");
            fastStringBuffer.append(this._getCallName(bl, null));
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            fastStringBuffer.append("where 1=0;\n");
        }
        fastStringBuffer.append(INDENT);
        fastStringBuffer.append("rollback; \n");
        fastStringBuffer.append("END;\n");
    }

    private String _getCallName(boolean bl, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (string != null) {
            fastStringBuffer.append(string).append('.');
        } else {
            if (bl && ModelUtil.hasLength((String)this._owner)) {
                fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._owner)).append('.');
            }
            if (ModelUtil.hasLength((String)this._package)) {
                fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._package)).append('.');
            }
        }
        fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._name));
        return fastStringBuffer.toString();
    }

    private String _getHashName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(this._getCallName(true, null));
        if (this._overload > 0) {
            fastStringBuffer.append("(" + this._overload + ")");
        }
        String string = null;
        try {
            Connection connection = this._db.getConnection();
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ModelUtil.hasLength(string)) {
            fastStringBuffer.append('@').append(string);
        }
        return fastStringBuffer.toString();
    }

    static void resetDefaultParamMap() {
        allDefaultParams = new HashMap<String, Map<String, Map<String, String>>>();
    }

    private Map<String, Map<String, String>> parseDefaultParams(String string, String string2, TextBuffer textBuffer) {
        String string3 = string + "." + string2;
        Map<String, Map<String, String>> map = allDefaultParams.get(string3);
        if (map == null) {
            String string4 = textBuffer.getString(0, textBuffer.getLength());
            map = this.parseDefaultParams(string4);
            allDefaultParams.put(string3, map);
        }
        return map;
    }

    private Map<String, Map<String, String>> parseDefaultParams(String string) {
        List list = LexerToken.parse((String)string);
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        try {
            Map map = defaultParProgramInstance.run(string, list);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"default parameters\"");
            for (Tuple tuple : materializedPredicate.getTuples()) {
                TreeMap<String, Object> treeMap;
                ParseNode parseNode = materializedPredicate.getAttribute(tuple, "id");
                ParseNode parseNode2 = materializedPredicate.getAttribute(tuple, "pls_expr");
                ParseNode parseNode3 = materializedPredicate.getAttribute(tuple, "proc");
                Object object = parseNode2.content(list);
                if (2 <= ((String)object).length() && ((String)object).charAt(0) == '\'' && ((String)object).charAt(((String)object).length() - 1) == '\'') {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                }
                Object object2 = this.packageMembers.iterator();
                while (object2.hasNext()) {
                    treeMap = object2.next();
                    if (!((Member)((Object)treeMap)).name.equals(object)) continue;
                    object = this._package + "." + (String)object;
                    break;
                }
                if ((treeMap = (Map)hashMap.get(object2 = Service.handleMixedCase((String)parseNode3.content(list)))) == null) {
                    treeMap = new TreeMap<String, Object>();
                    hashMap.put((String)object2, treeMap);
                }
                treeMap.put(Service.handleMixedCase((String)((LexerToken)list.get((int)parseNode.from)).content), object);
            }
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) throws IOException {
        Program.debug = true;
        String string = Service.readFile(Procedure.class, (String)"FND_STATS.pks");
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        System.out.println("Time = " + (l2 - l));
    }
}

