/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.controls.query.QueryBuilderEditPanel;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.SqlLocator;
import oracle.ide.Context;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class ToggleJoins {
    public static boolean convert(Context context) {
        View view = context.getView();
        if (!(view instanceof DbEditor)) {
            return false;
        }
        BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
        String string = ((DbEditor)view).getConnectionName();
        return ToggleJoins.convert(basicEditorPane, string);
    }

    public static boolean convert(BasicEditorPane basicEditorPane, String string) {
        int n;
        int n2 = basicEditorPane.getSelectionStart();
        int n3 = basicEditorPane.getSelectionEnd();
        String string2 = null;
        if (n3 == 0 || n2 == n3) {
            n = basicEditorPane.getCaretPosition();
            try {
                string2 = basicEditorPane.getDocument().getText(0, basicEditorPane.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                Logger.ignore(ToggleJoins.class, (Throwable)badLocationException);
                return true;
            }
            long l = SqlLocator.locate((int)n, (String)string2);
            n2 = Service.lX((long)l);
            n3 = Service.lY((long)l);
            basicEditorPane.select(n2, n3);
            string2 = string2.substring(n2, n3);
            if (string2 == null) {
                return false;
            }
        } else {
            try {
                string2 = basicEditorPane.getText(n2, n3 - n2);
            }
            catch (Exception exception) {
                Logger.ignore(ToggleJoins.class, (Throwable)exception);
                return true;
            }
        }
        n = n2;
        String string3 = string2;
        QueryBuilderEditPanel queryBuilderEditPanel = ToggleJoins.setUpToggle(string3, string);
        queryBuilderEditPanel.afterRefresh(() -> {
            try {
                String string2 = queryBuilderEditPanel.toggleJoins();
                if (ModelUtil.hasLength((String)string2)) {
                    string2 = ToggleJoins.adjust(string3, string2);
                    basicEditorPane.replaceSelection(string2);
                    basicEditorPane.setSelectionStart(n);
                    basicEditorPane.setSelectionEnd(n + string2.length());
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(ToggleJoins.class, (Throwable)throwable);
            }
        });
        return true;
    }

    public static String adjust(String string, String string2) throws Exception {
        Object object = string2;
        List list = LexerToken.parse((String)string);
        if (";".equals(((LexerToken)list.get((int)(list.size() - 1))).content)) {
            List list2 = LexerToken.parse((String)object);
            if (!";".equals(((LexerToken)list2.get((int)(list2.size() - 1))).content)) {
                object = (String)object + ";";
            }
        }
        return object;
    }

    private static QueryBuilderEditPanel setUpToggle(String string, String string2) {
        JTextField jTextField = new JTextField(string);
        QueryBuilderEditPanel queryBuilderEditPanel = new QueryBuilderEditPanel(jTextField, false);
        queryBuilderEditPanel.setConnection(string2);
        queryBuilderEditPanel.setSQL(string);
        return queryBuilderEditPanel;
    }
}

