/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class RefactorMenu
implements ContextMenuListener {
    static int _cmdToggleJoins = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.TOGGLE_JOINS_ID");
    static int _cmdULI = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.CASE_ID");
    static int _cmdMLC = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.MLC_ID");
    static int _cmdEX = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.EXTRACT");
    static int _cmdRN = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.RENAME_ID");
    static int _cmdOB = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.OBFUSCATE_ID");
    static int _cmdINL = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.INLINE_ID");
    public static int cmdFOR = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.FOR_ID");
    public static int cmdWHILE = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.WHILE_ID");
    public static int cmdBLOCK = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.BLOCK_ID");
    public static int cmdIF = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.IF_ID");

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        if (RefactorMenu.isMenuAvailable(context)) {
            String string = Messages.getString("RefactorMenu.7");
            JMenu jMenu = contextMenu.createMenu(string, (float)StringUtils.getMnemonicKeyCode((String)string));
            if (RefactorMenu.isPlsqlCodeEditor(context)) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdULI)));
            }
            if (context.getView().getClass().getName().endsWith("Worksheet")) {
                jMenu.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdToggleJoins)));
            }
            jMenu.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdEX)));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdRN)));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdOB)));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)_cmdINL)));
            jMenu.setSelected(false);
            contextMenu.add((Component)jMenu);
            String string2 = Messages.getString("SurroundWith");
            JMenu jMenu2 = contextMenu.createMenu(string2, (float)StringUtils.getMnemonicKeyCode((String)string2));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)cmdFOR)));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)cmdWHILE)));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)cmdBLOCK)));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)cmdIF)));
            jMenu.add(jMenu2);
        }
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        String string = node.getShortLabel();
        if (node instanceof PlSqlNode && ("BLOCK".equals(((PlSqlNode)node).getObjectType()) || string != null && string.toLowerCase().startsWith("anon_block"))) {
            return false;
        }
        return (node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode") || view.getClass().getName().endsWith("Worksheet")) && context.getEvent().getSource() instanceof JTextComponent;
    }

    private static boolean isPlsqlCodeEditor(Context context) {
        Node node = context.getNode();
        return (node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode")) && context.getEvent().getSource() instanceof JTextComponent;
    }
}

