/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.accessibility.AccessibleText;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.plsql.structure.AutoCompleter;
import oracle.dbtools.raptor.plsql.structure.LegacyToggleButton;
import oracle.dbtools.raptor.plsql.structure.MergedNode;
import oracle.dbtools.raptor.plsql.structure.NodeMenu;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriNode;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.icons.OracleIcons;

public class OutlinePanel
extends JPanel
implements TreeSelectionListener,
ParserEventListener {
    JTree tree;
    DefaultTreeModel model;
    private JTextField restrict = new JTextField();
    NodeMenu collapseMenu;
    NodeMenu hideMenu;
    NodeMenu mergeMenu;
    private JPanel toolbar = new JPanel(new GridBagLayout());
    private Dimension size;
    private Editor editor = null;
    BackgroundParser bkgrParser = null;
    static final String kwColor = "#882244";
    Object current = null;

    public JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getModel() {
        return this.model;
    }

    public JPanel getToolbar() {
        return this.toolbar;
    }

    public OutlinePanel() {
        super(new GridBagLayout());
        JButton jButton = new JButton(RaptorImagesArb.getIcon("ARBORI"));
        this.size = jButton.getPreferredSize();
        this.model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        NodeRenderer nodeRenderer = new NodeRenderer();
        this.tree.setCellRenderer(nodeRenderer);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = OutlinePanel.this.tree.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = OutlinePanel.this.tree.getPathForRow(n);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (!(object instanceof ParseNode)) {
                        return;
                    }
                    ParseNode parseNode = (ParseNode)object;
                    int n2 = OutlinePanel.this.symbolIndex(mouseEvent);
                    if (OutlinePanel.this.urlAtIndex(n2, parseNode) != null) {
                        OutlinePanel.this.tree.setCursor(new Cursor(12));
                        return;
                    }
                }
                OutlinePanel.this.tree.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = OutlinePanel.this.tree.getRowForLocation(point.x, point.y);
                if (n < 0) {
                    return;
                }
                TreePath treePath = OutlinePanel.this.tree.getPathForRow(n);
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof ParseNode)) {
                    return;
                }
                ParseNode parseNode = (ParseNode)object;
                int n2 = OutlinePanel.this.symbolIndex(mouseEvent);
                String string = OutlinePanel.this.urlAtIndex(n2, parseNode);
                if (string != null) {
                    try {
                        Desktop.getDesktop().browse(new URI(string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put("exception_handlers_opt", false);
        treeMap.put("field_list", false);
        treeMap.put("ty_def", false);
        treeMap.put("parm_list_opt", false);
        treeMap.put("pragma", false);
        treeMap.put("prm_spec", false);
        treeMap.put("fml_part", false);
        treeMap.put("select", true);
        treeMap.put("seq_of_stmts", false);
        treeMap.put("constrained_type", false);
        this.collapseMenu = new NodeMenu(treeMap){

            @Override
            void refresh() {
                OutlinePanel.this.collapseExpand();
            }
        };
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put("basic_decl_item_list", false);
        treeMap2.put("later_decl_item_list", false);
        treeMap2.put("field_list", true);
        treeMap2.put("parm_list_opt", true);
        treeMap2.put("object_d_rhs", false);
        treeMap2.put("default_expr_opt", false);
        treeMap2.put("select_list", false);
        treeMap2.put("stmt_list_opt", false);
        treeMap2.put("sql_statements", false);
        treeMap2.put("'CREATE' 'OR' 'REPLACE'", false);
        treeMap2.put("is_or_as 'BEGIN' seq_of_stmts 'END' decl_id ';'", false);
        treeMap2.put("is_or_as decl_list 'BEGIN' seq_of_stmts 'END' decl_id ';'", false);
        treeMap2.put("is_or_as 'BEGIN' seq_of_stmts 'END' ';'", false);
        treeMap2.put("is_or_as decl_list 'BEGIN' seq_of_stmts 'END' ';'", false);
        treeMap2.put("is_or_as 'BEGIN' seq_of_stmts exception_handlers_opt 'END' decl_id ';'", false);
        treeMap2.put("is_or_as decl_list 'BEGIN' seq_of_stmts exception_handlers_opt 'END' decl_id ';'", false);
        treeMap2.put("is_or_as 'BEGIN' seq_of_stmts exception_handlers_opt 'END' ';'", false);
        treeMap2.put("is_or_as decl_list 'BEGIN' seq_of_stmts exception_handlers_opt 'END' ';'", false);
        this.hideMenu = new NodeMenu(treeMap2){

            @Override
            void refresh() {
                if (OutlinePanel.this.bkgrParser.root != null) {
                    OutlinePanel.this.setModel(OutlinePanel.this.convert(OutlinePanel.this.bkgrParser.root));
                }
            }
        };
        TreeMap<String, Boolean> treeMap3 = new TreeMap<String, Boolean>();
        treeMap3.put("object_d ';'", false);
        treeMap3.put("ty_d ';'", false);
        treeMap3.put("'PROCEDURE' decl_id", false);
        treeMap3.put("'PROCEDURE' decl_id fml_part", false);
        treeMap3.put("'FUNCTION' decl_id 'RETURN' prm_spec_unconstrained_type", false);
        treeMap3.put("'FUNCTION' decl_id fml_part 'RETURN' prm_spec_unconstrained_type", false);
        this.mergeMenu = new NodeMenu(treeMap3){

            @Override
            void refresh() {
                if (OutlinePanel.this.bkgrParser.root != null) {
                    OutlinePanel.this.setModel(OutlinePanel.this.convert(OutlinePanel.this.bkgrParser.root));
                }
            }
        };
        final JButton jButton2 = new JButton((Icon)UIManager.get("Tree.expandedIcon"));
        final JButton jButton3 = new JButton(OracleIcons.getIcon((String)"filter.png"));
        final JButton jButton4 = new JButton(RaptorImagesArb.getIcon("MERGE"));
        LegacyToggleButton legacyToggleButton = new LegacyToggleButton(new JComponent[]{jButton2, jButton3, jButton4}){

            @Override
            void stateChanged() {
                OutlinePanel.this.stateChanged(OutlinePanel.this.bkgrParser);
            }
        };
        legacyToggleButton.setPreferredSize(new Dimension((int)this.size.getHeight(), (int)this.size.getHeight()));
        int n = 0;
        this.toolbar.add((Component)legacyToggleButton, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jButton2.setPreferredSize(new Dimension((int)this.size.getHeight(), (int)this.size.getHeight()));
        jButton2.setToolTipText(Messages.getString("OutlinePanel.CollapseNodes"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlinePanel.this.collapseMenu.show(jButton2, jButton2.getX(), jButton2.getY() + jButton2.getHeight());
            }
        });
        this.toolbar.add((Component)jButton2, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jButton3.setPreferredSize(new Dimension((int)this.size.getHeight(), (int)this.size.getHeight()));
        jButton3.setToolTipText(Messages.getString("OutlinePanel.HideNodes"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlinePanel.this.hideMenu.show(jButton3, jButton3.getX(), jButton3.getY() + jButton3.getHeight());
            }
        });
        this.toolbar.add((Component)jButton3, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jButton4.setPreferredSize(new Dimension((int)this.size.getHeight(), (int)this.size.getHeight()));
        jButton4.setToolTipText(Messages.getString("OutlinePanel.MergeNodes"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlinePanel.this.mergeMenu.show(jButton4, jButton4.getX(), jButton4.getY() + jButton4.getHeight());
            }
        });
        this.toolbar.add((Component)jButton4, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.toolbar.add(Box.createRigidArea(new Dimension(20, 0)), new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.restrict.getAccessibleContext().setAccessibleName(Messages.getString("OutlinePanel.Restrict"));
        this.restrict.setToolTipText(Messages.getString("OutlinePanel.QuickSearch"));
        this.restrict.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if ("arbori".equals(OutlinePanel.this.restrict.getText())) {
                    OutlinePanel.this.openArboriEditor();
                    return;
                }
                OutlinePanel.this.tree.collapseRow(0);
                OutlinePanel.this.tree.expandRow(0);
            }
        });
        this.toolbar.add((Component)this.restrict, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 10, 0));
        new AutoCompleter(this.restrict){

            @Override
            protected boolean updateListData() {
                String string = this.textComp.getText();
                TreeSet<String> treeSet = new TreeSet<String>();
                if (!LegacyToggleButton.isOff() && LegacyToggleButton.instance.isEnabled()) {
                    for (String object2 : SqlEarley.getInstance().allSymbols) {
                        if (object2 == null || OutlinePanel.this.skipSymbol(object2) || !object2.startsWith(string)) continue;
                        treeSet.add(object2);
                    }
                }
                if (OutlinePanel.this.bkgrParser != null && OutlinePanel.this.bkgrParser.root != null) {
                    for (ParseNode parseNode : OutlinePanel.this.legacyChildren(OutlinePanel.this.bkgrParser.root)) {
                        String string2;
                        LazyNode lazyNode = (LazyNode)parseNode;
                        String string3 = lazyNode.startToken;
                        int n = string3.indexOf(32);
                        if (n < 0 || !(string2 = string3.substring(n + 1)).toUpperCase().startsWith(string.toUpperCase())) continue;
                        treeSet.add(string2);
                    }
                }
                if (!LegacyToggleButton.instance.isEnabled()) {
                    for (int i = 0; i < OutlinePanel.this.tree.getRowCount(); ++i) {
                        TreePath treePath = OutlinePanel.this.tree.getPathForRow(i);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (!(object instanceof Member)) {
                            return true;
                        }
                        Member member = (Member)object;
                        if (!member.name.toUpperCase().startsWith(string.toUpperCase())) continue;
                        treeSet.add(member.name);
                    }
                }
                this.list.setListData(treeSet.toArray(new String[0]));
                return true;
            }

            @Override
            protected void acceptedListItem(String string) {
                if (string == null || "...".equals(string.toString())) {
                    return;
                }
                String string2 = this.textComp.getText();
                int n = string2.length();
                try {
                    this.textComp.getDocument().insertString(this.textComp.getCaretPosition(), string.toString().substring(n), null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                OutlinePanel.this.tree.collapseRow(0);
                OutlinePanel.this.tree.expandRow(0);
            }
        };
        this.toolbar.add(Box.createRigidArea(new Dimension(20, 0)), new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)this.toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = OutlinePanel.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
    }

    private JPopupMenu getPopupMenu(int n, int n2) {
        JMenuItem jMenuItem;
        String string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        TreePath treePath = this.tree.getPathForLocation(n, n2);
        if (treePath == null) {
            return null;
        }
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        final ParseNode parseNode = (ParseNode)object;
        for (int n3 : parseNode.content()) {
            if (n3 == -1 || this.skipSymbol(string = SqlEarley.getInstance().allSymbols[n3]) || this.collapseMenu.allItems.containsKey(string)) continue;
            jMenuItem = new JMenuItem("<html>" + Messages.getString("OutlinePanel.Add") + " <font color=gray>" + string + "</font> " + Messages.getString("OutlinePanel.ToCollapsedList"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutlinePanel.this.collapseMenu.newItem(string, true);
                    OutlinePanel.this.collapseExpand();
                }
            });
        }
        for (int n3 : parseNode.content()) {
            if (n3 == -1 || this.skipSymbol(string = SqlEarley.getInstance().allSymbols[n3]) || this.hideMenu.allItems.containsKey(string)) continue;
            jMenuItem = new JMenuItem("<html>" + Messages.getString("OutlinePanel.Add") + " <font color=gray>" + string + "</font> " + Messages.getString("OutlinePanel.ToHiddenList"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutlinePanel.this.hideMenu.newItem(string, false);
                }
            });
        }
        Object object2 = new JMenuItem(Messages.getString("OutlinePanel.ExpandBranch"));
        jPopupMenu.add((JMenuItem)object2);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < OutlinePanel.this.tree.getRowCount(); ++i) {
                    TreePath treePath = OutlinePanel.this.tree.getPathForRow(i);
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    ParseNode parseNode2 = (ParseNode)object;
                    if (parseNode.from > parseNode2.from || parseNode2.to > parseNode.to) continue;
                    OutlinePanel.this.tree.expandRow(i);
                }
            }
        });
        object2 = new JMenuItem(Messages.getString("OutlinePanel.ExpandChildren"));
        jPopupMenu.add((JMenuItem)object2);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    int n = OutlinePanel.this.tree.getRowForPath(treePath);
                    OutlinePanel.this.tree.expandRow(n);
                }
            }
        });
        object2 = new JMenuItem(Messages.getString("OutlinePanel.CollapseChildren"));
        jPopupMenu.add((JMenuItem)object2);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    int n = OutlinePanel.this.tree.getRowForPath(treePath);
                    OutlinePanel.this.tree.collapseRow(n);
                }
            }
        });
        return jPopupMenu;
    }

    private boolean skipSymbol(String string) {
        if (0 < string.indexOf(91)) {
            return true;
        }
        if (0 < string.indexOf(35)) {
            return true;
        }
        if (0 <= string.indexOf(39)) {
            return true;
        }
        return "cartesian_product".equals(string);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object;
        if (this.firedFromLocationListener()) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        int[] nArray = this.tree.getSelectionRows();
        if (nArray.length == 1) {
            treePath = this.tree.getPathForRow(nArray[0]);
            this.current = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
        if (this.current instanceof Member) {
            Member member = (Member)this.current;
            if (this.editor != null) {
                this.editor.activate();
                BasicEditorPane basicEditorPane = null;
                if (this.editor instanceof BasicEditorPaneContainer) {
                    basicEditorPane = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
                }
                this.gotoOffset(member.codeOffset, member.name != null ? member.name.length() : 0, basicEditorPane);
            }
            return;
        }
        ParseNode parseNode = (ParseNode)this.current;
        int n = this.bkgrParser.src.get((int)parseNode.from).begin;
        int n2 = this.bkgrParser.src.get((int)(parseNode.to - 1)).end;
        if (parseNode.parent() == null) {
            object = SyntaxError.checkSyntax((String)this.bkgrParser.text, (String[])new String[]{"sql_statements", "subprg_body"}, this.bkgrParser.src, (Earley)SqlEarley.getInstance(), (Matrix)this.bkgrParser.matrix);
            if (object == null) {
                return;
            }
            n = object.end;
            n2 = n + 1;
        }
        if (this.editor != null) {
            this.editor.activate();
            object = null;
            if (this.editor instanceof BasicEditorPaneContainer) {
                object = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
            }
            this.gotoOffset(n, n2 - n, (BasicEditorPane)object);
        }
    }

    private boolean firedFromLocationListener() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.toString().contains(".LocationListener")) continue;
            return true;
        }
        return false;
    }

    private boolean gotoOffset(int n, int n2, BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        int n3 = basicDocument.getLength();
        int n4 = Math.max(0, Math.min(n, n3));
        int n5 = Math.max(n4, Math.min(n4 + n2, n3));
        basicEditorPane.setCaretPositionCenter(n4);
        if (n4 != n5) {
            basicEditorPane.moveCaretPositionCenter(n5);
        }
        return n == n4 && n2 == n5 - n4;
    }

    public void refresh(Editor editor) {
        if ("true".equalsIgnoreCase((String)HiddenParameters.parameters.get("arboriEditor"))) {
            this.openArboriEditor();
        }
        this.buildNewOutlineTree((View)editor);
    }

    private void openArboriEditor() {
        try {
            File file = File.createTempFile("temp_worksheet", ".arbori", Resource.RAPTOR_USER_TEMP);
            file.deleteOnExit();
            ArboriNode arboriNode = new ArboriNode(file.toURL());
            final Context context = Context.newIdeContext((Node)arboriNode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
            });
        }
        catch (Exception exception) {
            Logger.severe(OutlinePanel.class, (Throwable)exception);
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public void buildNewOutlineTree(View view) {
        this.buildNewOutlineTree(view, false);
    }

    public void buildNewOutlineTree(View view, boolean bl) {
        if (this.editor == view && !bl) {
            return;
        }
        this.editor = view instanceof Editor ? (Editor)view : null;
        Context context = view.getContext();
        Node node = context.getNode();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.bkgrParser = plSqlNode.getParser();
            this.bkgrParser.replaceOutlineListener(this);
            ParseNode parseNode = this.bkgrParser.root;
            if (parseNode != null) {
                defaultMutableTreeNode = this.convert(parseNode);
                LegacyToggleButton.instance.reconcileStateWithDependents();
            } else {
                LegacyToggleButton.disableToolbarActions();
                PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
                if (this.bkgrParser.src == null) {
                    return;
                }
                plsqlStructureParser.parse(this.bkgrParser.src, PlSqlArguments.getSort());
                Item item = this.bkgrParser.parseNameTypeOwner(null);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(item == null ? "" : new Member(item.objName, item.objType, 0, 1, item.objType + " " + item.objName));
                defaultMutableTreeNode = this.buildTree(defaultMutableTreeNode2, plsqlStructureParser.children);
            }
        } else if (node instanceof TextNode && view instanceof EquippedWithParser) {
            this.bkgrParser = ((EquippedWithParser)view).getParser();
            if (this.bkgrParser == null) {
                this.editor = null;
                return;
            }
            this.bkgrParser.replaceOutlineListener(this);
            ParseNode parseNode = this.bkgrParser.root;
            if (parseNode != null) {
                defaultMutableTreeNode = this.convert(parseNode);
                LegacyToggleButton.instance.reconcileStateWithDependents();
            } else {
                LegacyToggleButton.disableToolbarActions();
                PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
                if (this.bkgrParser.src == null) {
                    return;
                }
                plsqlStructureParser.parse(this.bkgrParser.src, PlSqlArguments.getSort());
                Item item = this.bkgrParser.parseNameTypeOwner(null);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(item == null ? "" : new Member(item.objName, item.objType, 0, 1, item.objType + " " + item.objName));
                defaultMutableTreeNode = this.buildTree(defaultMutableTreeNode3, plsqlStructureParser.children);
            }
        }
        this.setModel(defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode convert(ParseNode parseNode) {
        ParseNode.ignoreMarkers = "[";
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(parseNode);
        for (ParseNode parseNode2 : this.children(parseNode)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.convert(parseNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        ParseNode.ignoreMarkers = "";
        return defaultMutableTreeNode;
    }

    private Set<ParseNode> children(ParseNode parseNode) {
        if (LegacyToggleButton.isOff()) {
            return this.legacyChildren(parseNode);
        }
        if (parseNode instanceof MergedNode) {
            return parseNode.children();
        }
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        MergedNode mergedNode = this.matchNodes(parseNode, this.hideMenu);
        MergedNode mergedNode2 = this.matchNodes(parseNode, this.mergeMenu);
        for (ParseNode parseNode2 : parseNode.children()) {
            int[] nArray = parseNode2.content();
            if (mergedNode != null) {
                if (mergedNode.from == parseNode2.from || mergedNode.from < parseNode2.from && parseNode2.to <= mergedNode.to) {
                    continue;
                }
            } else if (mergedNode2 != null) {
                if (mergedNode2.from == parseNode2.from) {
                    treeSet.add(mergedNode2);
                    continue;
                }
                if (mergedNode2.from < parseNode2.from && parseNode2.to <= mergedNode2.to) continue;
            }
            if (1 < nArray.length) {
                treeSet.add(parseNode2);
                continue;
            }
            String string = SqlEarley.getInstance().allSymbols[nArray[0]];
            JCheckBoxMenuItem jCheckBoxMenuItem = this.hideMenu.allItems.get(string);
            if (jCheckBoxMenuItem == null) {
                treeSet.add(parseNode2);
                continue;
            }
            if (jCheckBoxMenuItem.isSelected()) {
                treeSet.add(parseNode2);
                continue;
            }
            treeSet.addAll(this.children(parseNode2));
        }
        return treeSet;
    }

    private Set<ParseNode> legacyChildren(ParseNode parseNode) {
        if (parseNode instanceof LazyNode) {
            return parseNode.children();
        }
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        LazyNode lazyNode = null;
        for (final ParseNode parseNode2 : parseNode.children()) {
            Object object;
            if (parseNode2.contains("basic_decl_item") && this.isPkgDecl(parseNode) || parseNode2.contains("subprg_spec") && !parseNode.contains("basic_decl_item")) {
                int n;
                object = this.bkgrParser.text.substring(this.bkgrParser.src.get((int)parseNode2.from).begin, this.bkgrParser.src.get((int)(parseNode2.from + 1)).end);
                if (parseNode2.contains("basic_decl_item")) {
                    object = this.bkgrParser.text.substring(this.bkgrParser.src.get((int)parseNode2.from).begin, this.bkgrParser.src.get((int)(parseNode2.to - 1)).end);
                }
                if (0 < (n = ((String)object).indexOf(40))) {
                    object = ((String)object).substring(0, ((String)object).indexOf(40));
                }
                if (0 < (n = ((String)object).toLowerCase().indexOf("index by"))) {
                    object = ((String)object).substring(0, n);
                }
                lazyNode = new LazyNode(parseNode2.from, (String)object, this.bkgrParser.src){

                    public Icon getIcon() {
                        String string = OutlinePanel.this.bkgrParser.src.get((int)parseNode2.from).content;
                        return Member.getIcon(string, false);
                    }
                };
                lazyNode.to = parseNode2.to;
                lazyNode.parent = parseNode;
                treeSet.add((ParseNode)lazyNode);
                for (final ParseNode parseNode3 : parseNode2.descendants()) {
                    if (!parseNode3.contains("prm_spec")) continue;
                    object = this.bkgrParser.text.substring(this.bkgrParser.src.get((int)parseNode3.from).begin, this.bkgrParser.src.get((int)(parseNode3.to - 1)).end);
                    LazyNode lazyNode2 = new LazyNode(parseNode3.from, (String)object, this.bkgrParser.src){

                        public Icon getIcon() {
                            String string = null;
                            for (ParseNode parseNode : parseNode3.children()) {
                                if (!parseNode.contains("unconstrained_type")) continue;
                                string = OutlinePanel.this.bkgrParser.src.get((int)parseNode.from).content;
                            }
                            return Member.getIcon(string, false);
                        }
                    };
                    lazyNode2.to = parseNode3.to;
                    lazyNode2.parent = lazyNode;
                    lazyNode.addTopLevel((ParseNode)lazyNode2);
                }
            }
            if (lazyNode != null && parseNode2.contains("decl_list")) {
                object = this.legacyChildren(parseNode2);
                Iterator<ParseNode> iterator = object.iterator();
                while (iterator.hasNext()) {
                    ParseNode parseNode4 = iterator.next();
                    if (!(parseNode4 instanceof LazyNode)) continue;
                    parseNode4.parent = lazyNode;
                    lazyNode.addTopLevel(parseNode4);
                }
            }
            if (parseNode2.contains("seq_of_stmts") || parseNode2.contains("basic_decl_item_list") && !this.isPkgDecl(parseNode) || parseNode2.contains("decl_list") && !this.isPkgDecl(parseNode)) continue;
            treeSet.addAll(this.legacyChildren(parseNode2));
        }
        return treeSet;
    }

    private boolean isPkgDecl(ParseNode parseNode) {
        if (parseNode.contains("pkg_body")) {
            return true;
        }
        if (parseNode.contains("pkg_spec")) {
            return true;
        }
        if (parseNode.contains("subprg_body")) {
            return false;
        }
        if (parseNode.contains("subprg_spec")) {
            return false;
        }
        ParseNode parseNode2 = parseNode.parent;
        if (parseNode2 != null) {
            return this.isPkgDecl(parseNode2);
        }
        return false;
    }

    private List<int[]> notSelectedSequences(NodeMenu nodeMenu) {
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        for (String string : nodeMenu.allItems.keySet()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = nodeMenu.allItems.get(string);
            if (jCheckBoxMenuItem.isSelected() || string.indexOf(32) < 0) continue;
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = (Integer)SqlEarley.getInstance().symbolIndexes.get(string2);
                linkedList2.add(n2);
            }
            linkedList.add(linkedList2.stream().mapToInt(n -> n).toArray());
        }
        return linkedList;
    }

    private MergedNode matchNodes(ParseNode parseNode, NodeMenu nodeMenu) {
        int n;
        List<int[]> list = this.notSelectedSequences(nodeMenu);
        int[] nArray = new int[list.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        n = -1;
        for (ParseNode parseNode2 : parseNode.children()) {
            ++n;
            int[] nArray2 = parseNode2.content();
            for (int i = 0; i < nArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray2[j] != list.get(i)[nArray[i]]) continue;
                    int n2 = i;
                    nArray[n2] = nArray[n2] + 1;
                    bl = true;
                    if (nArray[i] != list.get(i).length) break;
                    MergedNode mergedNode = new MergedNode(parseNode, n + 1 - list.get(i).length, n + 1, this.bkgrParser.src);
                    return mergedNode;
                }
                if (bl) continue;
                nArray[i] = 0;
            }
        }
        return null;
    }

    void collapseExpand() {
        try {
            for (int i = 1; i < this.tree.getRowCount(); ++i) {
                TreePath treePath = this.tree.getPathForRow(i);
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (!(object instanceof ParseNode)) {
                    return;
                }
                ParseNode parseNode = (ParseNode)object;
                boolean bl = false;
                for (int n : parseNode.content()) {
                    JCheckBoxMenuItem jCheckBoxMenuItem;
                    String string;
                    if (n == -1 || this.skipSymbol(string = SqlEarley.getInstance().allSymbols[n]) || (jCheckBoxMenuItem = this.collapseMenu.allItems.get(string)) == null || jCheckBoxMenuItem.isSelected()) continue;
                    bl = true;
                    break;
                }
                if (parseNode instanceof LazyNode || parseNode instanceof MergedNode) {
                    bl = true;
                }
                if (bl) {
                    this.tree.collapseRow(i);
                    continue;
                }
                this.tree.expandRow(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OutlinePanel.this.tree.setModel(OutlinePanel.this.model);
                OutlinePanel.this.collapseExpand();
            }
        });
    }

    public void extractContent(ParseNode parseNode, StringBuilder stringBuilder) {
        LexerToken lexerToken = this.bkgrParser.src.get(parseNode.from);
        for (int n : parseNode.content()) {
            String string;
            if (n == -1) continue;
            String string2 = SqlEarley.getInstance().allSymbols[n];
            String string3 = null;
            Object object = null;
            if (string2.charAt(0) == '\'') {
                string = lexerToken.content;
                string = string.replace("<", "&lt;");
                string = string.replace(">", "&gt;");
                if (CaseConverter.getState() != CaseConverter.CASE.UPPER && CaseConverter.getState() != CaseConverter.CASE.UPPER_KW && CaseConverter.getState() != CaseConverter.CASE.UPPER_KW_LOWER_ID) {
                    string3 = "<font color=#882244><b>" + string.toLowerCase() + "</font></b>";
                    object = "<font color=#882244><b>";
                }
                if (CaseConverter.getState() != CaseConverter.CASE.LOWER && CaseConverter.getState() != CaseConverter.CASE.LOWER_KW_UPPER_ID) {
                    string3 = "<font color=#882244><b>" + string.toUpperCase() + "</font></b>";
                    object = "<font color=#882244><b>";
                }
            }
            if (string3 == null && !this.skipSymbol(string2)) {
                string3 = "<font color=#aaaaaa>" + string2 + "</font>";
                object = "<font color=#aaaaaa>";
                if (HarvestDoc.getRailroads().containsKey(n)) {
                    string = ((DocURL)HarvestDoc.getRailroads().get(n)).getPublicURL();
                    string3 = "<a href=\"" + string + "\">" + string2 + "</a>";
                    object = "<a href=\"" + string + "\">";
                }
            }
            if (string3 == null) continue;
            string = this.restrict.getText();
            int n2 = string3.toUpperCase().indexOf(string.toUpperCase() + "<", ((String)object).length());
            if (n2 == ((String)object).length() && string.equals(string2)) {
                string3 = string3.substring(0, n2) + "<font bgcolor=#bbffbb>" + string3.substring(n2, n2 + string.length()) + "</font>" + string3.substring(n2 + string.length());
            }
            stringBuilder.append(string3);
            stringBuilder.append(' ');
        }
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        if (!OutlineWindow.getInstance().isVisible()) {
            return;
        }
        this.bkgrParser = backgroundParser;
        if (backgroundParser.root == null) {
            PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
            if (backgroundParser.src == null) {
                return;
            }
            plsqlStructureParser.parse(backgroundParser.src, PlSqlArguments.getSort());
            Item item = backgroundParser.parseNameTypeOwner(null);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(item == null ? "" : new Member(item.objName, item.objType, 0, 1, item.objType + " " + item.objName));
            defaultMutableTreeNode = this.buildTree(defaultMutableTreeNode, plsqlStructureParser.children);
            this.setModel(defaultMutableTreeNode);
            return;
        }
        this.setModel(this.convert(backgroundParser.root));
    }

    private DefaultMutableTreeNode buildTree(DefaultMutableTreeNode defaultMutableTreeNode, Set<Member> set) {
        Object object;
        LinkedList<DefaultMutableTreeNode> linkedList = new LinkedList<DefaultMutableTreeNode>();
        for (Member object22 : set) {
            linkedList.add(new DefaultMutableTreeNode(object22));
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode2 : linkedList) {
            object = null;
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : linkedList) {
                if (defaultMutableTreeNode3 == defaultMutableTreeNode2) continue;
                Member member = (Member)defaultMutableTreeNode2.getUserObject();
                Member member2 = (Member)defaultMutableTreeNode3.getUserObject();
                if (member2.from > member.from || member.to > member2.to) continue;
                if (object == null) {
                    object = defaultMutableTreeNode3;
                    continue;
                }
                Member member3 = (Member)((DefaultMutableTreeNode)object).getUserObject();
                if (member2.from > member3.from || member3.to > member2.to) continue;
                object = defaultMutableTreeNode3;
            }
            if (object == null) {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode2);
        }
        Object object3 = defaultMutableTreeNode;
        if (1 < defaultMutableTreeNode.getChildCount()) {
            return object3;
        }
        DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        object = (Member)defaultMutableTreeNode.getUserObject();
        Member member = (Member)defaultMutableTreeNode4.getUserObject();
        if (((Member)object).name.toLowerCase().equals(member.name.toLowerCase())) {
            object3 = defaultMutableTreeNode4;
        }
        return object3;
    }

    private int symbolIndex(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.tree.getRowForLocation(point.x, point.y);
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (n == -1 || treeCellRenderer == null) {
            return -1;
        }
        TreePath treePath = this.tree.getPathForRow(n);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, defaultMutableTreeNode, this.tree.isRowSelected(n), this.tree.isExpanded(n), this.tree.getModel().isLeaf(defaultMutableTreeNode), n, true);
        if (!(component instanceof JLabel)) {
            return -1;
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        JLabel jLabel = (JLabel)component;
        AccessibleText accessibleText = jLabel.getAccessibleContext().getAccessibleText();
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < accessibleText.getCharCount(); ++i) {
            if (accessibleText.getCharacterBounds(i).getHeight() < 0.1) continue;
            double d = accessibleText.getCharacterBounds(i).getX();
            if (d == 0.0) {
                n3 += n4;
                ++n2;
            }
            if (point.x - rectangle.x < n3) {
                return n2 - 1;
            }
            n4 = (int)d;
        }
        return n2;
    }

    private String urlAtIndex(int n, ParseNode parseNode) {
        int n2 = -1;
        for (int n3 : parseNode.content()) {
            String string;
            if (n3 == -1 || this.skipSymbol(string = SqlEarley.getInstance().allSymbols[n3]) || string.charAt(0) == '\'' || ++n2 != n) continue;
            if (!HarvestDoc.getRailroads().containsKey(n3)) {
                return null;
            }
            return ((DocURL)HarvestDoc.getRailroads().get(n3)).getPublicURL();
        }
        return null;
    }

    public void expandTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ParseNode parseNode = (ParseNode)defaultMutableTreeNode.getUserObject();
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof DefaultMutableTreeNode)) {
                return this;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof Member) {
                return this.getTreeCellRendererComponent4Member(jTree, object, bl, bl2, bl3, n, bl4, (Member)object2);
            }
            if (!(object2 instanceof ParseNode)) {
                this.setForeground(Color.red);
                this.setIcon(RaptorImagesArb.getIcon("RED"));
                if (object2 == null) {
                    return this;
                }
                this.setText(object2.toString());
                this.setToolTipText("!(o instanceof ParseNode)");
                return this;
            }
            ParseNode parseNode = (ParseNode)object2;
            Icon icon = parseNode.getIcon();
            this.setIcon(icon);
            if (parseNode.parent() == null && parseNode.topLevel != null) {
                this.setForeground(Color.red);
                this.setIcon(RaptorImagesArb.getIcon("RED"));
                this.setText(Messages.getString("OutlinePanel.SyntaxError"));
                this.setToolTipText("<html><pre>" + SyntaxError.checkSyntax((String)OutlinePanel.this.bkgrParser.text, (String[])new String[]{"sql_statements", "subprg_body"}, OutlinePanel.this.bkgrParser.src, (Earley)SqlEarley.getInstance(), (Matrix)OutlinePanel.this.bkgrParser.matrix).getDetailedMessage());
                return this;
            }
            this.setForeground(Color.black);
            StringBuilder stringBuilder = new StringBuilder();
            Object object3 = "<html>";
            if (OutlinePanel.this.bkgrParser.src != null && parseNode.from < OutlinePanel.this.bkgrParser.src.size()) {
                string = OutlinePanel.this.bkgrParser.src.get(parseNode.from);
                if (parseNode.from + 1 == parseNode.to) {
                    object3 = CaseConverter.getState() == CaseConverter.CASE.LOWER || CaseConverter.getState() == CaseConverter.CASE.UPPER_KW_LOWER_ID ? "<html><font color=#000000>" + ((LexerToken)string).content.toLowerCase() + "</font> " : "<html><font color=#000000>" + ((LexerToken)string).content.toUpperCase() + "</font> ";
                }
                for (int n2 : parseNode.content()) {
                    String string2;
                    if (n2 == -1 || (string2 = SqlEarley.getInstance().allSymbols[n2]).charAt(0) != '\'') continue;
                    if (CaseConverter.getState() != CaseConverter.CASE.UPPER && CaseConverter.getState() != CaseConverter.CASE.UPPER_KW && CaseConverter.getState() != CaseConverter.CASE.UPPER_KW_LOWER_ID) {
                        object3 = "<html>";
                    }
                    if (CaseConverter.getState() == CaseConverter.CASE.LOWER || CaseConverter.getState() == CaseConverter.CASE.LOWER_KW_UPPER_ID) continue;
                    object3 = "<html>";
                }
                OutlinePanel.this.extractContent(parseNode, stringBuilder);
            }
            if (parseNode instanceof LazyNode) {
                string = ((LazyNode)parseNode).startToken;
                int n3 = string.indexOf(32);
                if (n3 < 0) {
                    n3 = 0;
                }
                int n4 = string.toUpperCase().indexOf(OutlinePanel.this.restrict.getText().toUpperCase());
                String string3 = " ";
                if (n4 == n3 + 1 && n4 + OutlinePanel.this.restrict.getText().length() == string.length()) {
                    string3 = " bgcolor=#bbffbb";
                }
                String string4 = "<html><font color=#882244><b>" + string.substring(0, n3) + "</b></font> <font color=#000000 " + string3 + ">" + string.substring(n3 + 1);
                stringBuilder.append(string4);
            }
            if (parseNode instanceof MergedNode) {
                stringBuilder.append(((MergedNode)parseNode).htmlLabel(OutlinePanel.this.restrict.getText()));
            }
            if (stringBuilder.length() < "<font color=#000000>".length() && !(parseNode instanceof LazyNode) && !(parseNode instanceof MergedNode)) {
                this.setIcon(RaptorImagesArb.getIcon("GRAY"));
            }
            string = jTree.convertValueToText((String)object3 + stringBuilder.toString(), bl, bl2, bl3, n, bl4);
            this.setText(string);
            this.setToolTipText(parseNode.toString());
            return this;
        }

        private Component getTreeCellRendererComponent4Member(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, Member member) {
            if (member == OutlinePanel.this.current) {
                bl = true;
            }
            Icon icon = member.getIcon();
            this.setIcon(icon);
            this.setToolTipText(member.getTooltip());
            Object object2 = member.name;
            if (member.type != null && member.type.contains("BODY")) {
                object2 = (String)object2 + " Body";
            }
            String string = OutlinePanel.this.restrict.getText();
            boolean bl5 = ((String)object2).toUpperCase().startsWith(string.toUpperCase());
            if (bl5 && 0 < string.length()) {
                object2 = "<html><font bgcolor=#bbffbb>" + ((String)object2).substring(0, string.length()) + "</font> <font color=#000000>" + ((String)object2).substring(string.length());
            }
            String string2 = jTree.convertValueToText(object2, bl, bl2, bl3, n, bl4);
            this.setText(string2);
            return this;
        }
    }
}

