/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.controls.grid.IDrillLink;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class SqlIdDrillLink
implements IDrillLink {
    protected String _conn;
    private String sqlId;
    View current = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performDrill() {
        Object object;
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Clob clob;
            object = Connections.getInstance().getConnection(this._conn);
            preparedStatement = object.prepareStatement("select SQL_FULLTEXT from v$sql \n where sql_id = ?  \n order by child_number");
            preparedStatement.setString(1, this.sqlId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (clob = resultSet.getClob("SQL_FULLTEXT")) != null) {
                string = clob.getSubString(1L, (int)clob.length());
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("FailedVSQL"), null, null);
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (string == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("ExpiredCursor"), null, null);
            return;
        }
        object = RaptorDBAddin.getSqlOpener();
        this.current = object.openNewEditor(string, this._conn);
        object.showAutotraceStats(this.sqlId, this.current);
    }

    @Override
    public void setConnName(String string) {
        this._conn = string;
    }

    @Override
    public void setArgs(String[] stringArray) {
        this.sqlId = stringArray[1];
    }
}

