/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.plugins.EditorPlugin;

public class TooltipPlugin
implements EditorPlugin {
    private List<TooltipMessage> messages = new ArrayList<TooltipMessage>();
    public ToolTipProvider provider = new EditorTooltipProvider();

    public void addTooltip(TooltipMessage tooltipMessage) {
        this.messages.add(tooltipMessage);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        codeEditor.removeCEToolTipProvider((CEToolTipProvider)this.provider);
    }

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        codeEditor.addCEToolTipProvider((CEToolTipProvider)this.provider);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private final class EditorTooltipProvider
    implements CEToolTipProvider,
    ToolTipProvider {
        private EditorTooltipProvider() {
        }

        public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int n) {
            return this.getTooltipText(n);
        }

        public String getTooltipText(int n) {
            for (TooltipMessage tooltipMessage : TooltipPlugin.this.messages) {
                String string = tooltipMessage.getToolTipText(n);
                if (string == null) continue;
                return string;
            }
            return null;
        }

        public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int n) {
            return this.getTooltipText(n);
        }
    }
}

