/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.EventObject;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.search.InputTreePanel;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

public class OviewerSearchPanel
extends InputTreePanel {
    protected MouseListener onClick = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                return;
            }
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            jList.setSelectedIndex(n);
            if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                Context context = Context.newIdeContext();
                context.setEvent((EventObject)mouseEvent);
                OviewerSearchPanel.this.updateContext(context);
                if (context.getNode() == null) {
                    return;
                }
                ContextMenu contextMenu = new ContextMenu();
                contextMenu.addContextMenuListener((ContextMenuListener)new BasicObjectModifier());
                contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                contextMenu.show(context);
                return;
            }
            if (mouseEvent.getButton() == 1) {
                final URL uRL = OviewerSearchPanel.this.getSelectedURL();
                if (uRL == null) {
                    return;
                }
                DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(ControlsArb.getString("URLListRenderer.0") + DBURLFormatHelper.getName(uRL), IRaptorTaskRunMode.TASKVIEWER, false, false){

                    protected Void doWork() throws TaskException {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                OviewerSearchPanel.goTo(uRL);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        return null;
                    }

                    public String getQuery() {
                        return "";
                    }

                    public String getConnectionName() {
                        return DBURLFormatHelper.getConnectionName(uRL);
                    }
                };
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            }
        }
    };

    protected boolean isAddSchema() {
        return true;
    }

    protected void attachOnClick(JList jList) {
        jList.addMouseListener(this.onClick);
    }

    public static void goTo(URL uRL) {
        if (uRL == null) {
            return;
        }
        String string = Service.from2chars((String)DBURLFormatHelper.getCatalog(uRL));
        if (string != null) {
            int n = string.indexOf(44);
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Service.X((int)n2);
            int n4 = Service.Y((int)n2);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), DBURLFormatHelper.getName(uRL));
            NavSelectionListener.getInstance().open(uRL2, n3, n4);
        } else {
            String string2 = DBURLFormatHelper.getName(uRL);
            if (string2.indexOf(46) >= 0) {
                string2 = string2.substring(0, string2.indexOf(46));
                uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), string2);
            }
            NavSelectionListener.getInstance().open(uRL);
        }
    }
}

