/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportNames;
import oracle.dbtools.raptor.oviewer.base.Messages;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.ide.dialogs.OnePageWizardDialogFactory;

public class ConnectionExportPanel
extends JPanel {
    private JList fromList;
    private JList toList;
    private ListPicker fromPicker;
    private ReorderableListPicker toPicker;
    private DBObject m_selectedObject;
    private static URL s_selectedURL;
    private URLFileChooser.URLFileChooserPanel m_fileChooser;
    private JCheckBox m_chkCreateEmpty;
    private JCheckBox m_launchCheck;
    private JSpinner m_parallelismSpinner;
    private Map<String, List<ConnectionExportNames>> extraFolderTypeNameMap = new HashMap<String, List<ConnectionExportNames>>();
    private List<String> initiallySelectedFolderTypeNames = new ArrayList<String>();

    public ConnectionExportPanel(DBObject dBObject) {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createFileBrowser(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.createShuttle(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.m_chkCreateEmpty = new JCheckBox(Messages.getString("ConnectionExportTask.checkGenerateEmpty"));
        this.m_chkCreateEmpty.setSelected(true);
        jPanel.add((Component)this.m_chkCreateEmpty, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_launchCheck = new JCheckBox(Messages.getString("ConnectionExportTask.launchURILabel"));
        this.m_launchCheck.setSelected(true);
        jPanel.add((Component)this.m_launchCheck, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)new JLabel(Messages.getString("ConnectionExportTask.paralellism")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_parallelismSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        jPanel.add((Component)this.m_parallelismSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_selectedObject = dBObject;
    }

    public void addFolderTypeName(String string, String string2, String string3) {
        List<ConnectionExportNames> list = this.extraFolderTypeNameMap.get(string);
        if (list == null) {
            list = new ArrayList<ConnectionExportNames>();
            this.extraFolderTypeNameMap.put(string, list);
        }
        list.add(new ConnectionExportNames(string2, string3));
    }

    public void initiallySelectFolderTypeName(String string) {
        this.initiallySelectedFolderTypeNames.add(string);
    }

    private void populateShuttle(SortedSet<ShuttleEntry> sortedSet) {
        DefaultListModel defaultListModel = (DefaultListModel)this.fromList.getModel();
        defaultListModel.removeAllElements();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.toList.getModel();
        defaultListModel2.removeAllElements();
        for (ShuttleEntry shuttleEntry : sortedSet) {
            if (this.initiallySelectedFolderTypeNames.contains(shuttleEntry.toString())) {
                defaultListModel2.addElement(shuttleEntry);
                continue;
            }
            defaultListModel.addElement(shuttleEntry);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.m_selectedObject != null && this.toList.getModel().getSize() == 0 && this.fromList.getModel().getSize() == 0) {
            String string = this.m_selectedObject.getConnectionName();
            Connection connection = this.m_selectedObject.getConnection();
            ObjectFactory objectFactory = ObjectFactory.getFactory(string, connection);
            DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(this.m_selectedObject.getSchemaName());
            SortedSet<ShuttleEntry> sortedSet = this.getSortedShuttleEntryList(dBSchemaInstance);
            this.populateShuttle(sortedSet);
        }
    }

    private SortedSet<ShuttleEntry> getSortedShuttleEntryList(DBSchemaInstance dBSchemaInstance) {
        TreeSet<ShuttleEntry> treeSet = new TreeSet<ShuttleEntry>();
        for (DBFolderInstance dBFolderInstance : dBSchemaInstance.listTypeFolders()) {
            String string = dBFolderInstance.getDescriptor().getType().toUpperCase();
            if (string.equals("RECYCLEBIN") || string.equals("PUBLIC_SYNONYM")) continue;
            ShuttleEntry shuttleEntry = new ShuttleEntry(dBFolderInstance);
            treeSet.add(shuttleEntry);
            List<ConnectionExportNames> list = this.extraFolderTypeNameMap.get(shuttleEntry.toString());
            if (list == null) continue;
            for (ConnectionExportNames connectionExportNames : list) {
                treeSet.add(new ShuttleEntry(dBFolderInstance, connectionExportNames));
            }
        }
        return treeSet;
    }

    private JPanel createFileBrowser() {
        this.m_fileChooser = URLFileChooser.createURLFileChooserPanel(1, Messages.getString("ConnectionExportPanel.1"));
        this.m_fileChooser.setSelectionScope(1);
        if (s_selectedURL != null && s_selectedURL.toString().length() > 0) {
            String string = new File(s_selectedURL.getPath()).getAbsolutePath();
            this.m_fileChooser.setText(string);
        } else {
            String string = System.getProperty("user.home");
            if (string != null) {
                this.m_fileChooser.setText(string);
            }
        }
        return this.m_fileChooser;
    }

    public static void main(String[] stringArray) {
        SimpleIdeCore.initIde();
        System.setSecurityManager(null);
        ConnectionExportPanel connectionExportPanel = new ConnectionExportPanel(null);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionExportPanel, (Component)connectionExportPanel, (String)Messages.getString("ConnectionExportPanel.4"), (int)7);
        jEWTDialog.setSize(connectionExportPanel.getPreferredSize().width + 30, connectionExportPanel.getPreferredSize().height + 30);
        jEWTDialog.setDefaultCloseOperation(2);
        boolean bl = jEWTDialog.runDialog();
        if (bl) {
            DBFolderInstance[] dBFolderInstanceArray;
            for (DBFolderInstance dBFolderInstance : dBFolderInstanceArray = connectionExportPanel.getSelectedTypes()) {
                System.out.println(dBFolderInstance);
            }
        }
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        this.fromList = new JList(new DefaultListModel());
        this.toList = new JList(new DefaultListModel());
        this.fromPicker = new ListPicker(this.fromList);
        this.toPicker = new ReorderableListPicker(this.toList);
        shuttle.setToPicker((ItemPicker)this.toPicker);
        shuttle.setFromPicker((ItemPicker)this.fromPicker);
        shuttle.add((Component)new JLabel(DataImportArb.getString("SHUTTLE_AVAIL_COLUMNS")), (Object)"FromHeader");
        shuttle.add((Component)new JLabel(DataImportArb.getString("SHUTTLE_CHOSEN_COLUMNS")), (Object)"ToHeader");
        return shuttle;
    }

    public DBFolderInstance[] getSelectedTypes() {
        Object[] objectArray;
        ArrayList<DBFolderInstance> arrayList = new ArrayList<DBFolderInstance>();
        for (Object object : objectArray = ((DefaultListModel)this.toList.getModel()).toArray()) {
            ShuttleEntry shuttleEntry;
            DBFolderInstance dBFolderInstance;
            if (!(object instanceof ShuttleEntry) || arrayList.contains(dBFolderInstance = (shuttleEntry = (ShuttleEntry)object).getFolderInstance())) continue;
            arrayList.add(shuttleEntry.getFolderInstance());
        }
        Object[] objectArray2 = new DBFolderInstance[arrayList.size()];
        arrayList.toArray(objectArray2);
        return objectArray2;
    }

    public ConnectionExportNames[] getSelectedTypeNames(DBFolderInstance dBFolderInstance) {
        Object[] objectArray;
        ArrayList<ConnectionExportNames> arrayList = new ArrayList<ConnectionExportNames>();
        for (Object object : objectArray = ((DefaultListModel)this.toList.getModel()).toArray()) {
            ShuttleEntry shuttleEntry;
            if (!(object instanceof ShuttleEntry) || dBFolderInstance != (shuttleEntry = (ShuttleEntry)object).getFolderInstance()) continue;
            arrayList.add(shuttleEntry.getNames());
        }
        Object[] objectArray2 = new ConnectionExportNames[arrayList.size()];
        arrayList.toArray(objectArray2);
        return objectArray2;
    }

    public File getSelectedOutputDir() {
        return this.m_fileChooser.getSelectedFile();
    }

    public int getParallelism() {
        return (Integer)this.m_parallelismSpinner.getValue();
    }

    public boolean isLaunchSelected() {
        return this.m_launchCheck.isSelected();
    }

    public boolean isGenerateEmptySelected() {
        return this.m_chkCreateEmpty.isSelected();
    }

    private static class ShuttleEntry
    implements Comparable<ShuttleEntry> {
        private DBFolderInstance folderInstance;
        private ConnectionExportNames names;

        ShuttleEntry(DBFolderInstance dBFolderInstance) {
            this(dBFolderInstance, new ConnectionExportNames(dBFolderInstance.getType(), ShuttleEntry.getFolderTypeName(dBFolderInstance)));
        }

        ShuttleEntry(DBFolderInstance dBFolderInstance, ConnectionExportNames connectionExportNames) {
            this.folderInstance = dBFolderInstance;
            this.names = connectionExportNames;
        }

        DBFolderInstance getFolderInstance() {
            return this.folderInstance;
        }

        ConnectionExportNames getNames() {
            return this.names;
        }

        private static String getFolderTypeName(DBFolderInstance dBFolderInstance) {
            String string = dBFolderInstance.getType().toLowerCase();
            if (dBFolderInstance.getDescriptor() instanceof DatabaseContainer) {
                string = ((DatabaseContainer)dBFolderInstance.getDescriptor()).getLabel();
            }
            return string;
        }

        public String toString() {
            String string = null;
            if (this.names != null) {
                string = this.names.getType();
            }
            if (string == null) {
                string = this.folderInstance.getType();
            }
            return string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof ShuttleEntry) {
                bl = this.toString().equals(object.toString());
            }
            return bl;
        }

        @Override
        public int compareTo(ShuttleEntry shuttleEntry) {
            int n = 0;
            if (this != shuttleEntry) {
                DatabaseFolder databaseFolder = (DatabaseFolder)this.folderInstance.getDescriptor();
                DatabaseFolder databaseFolder2 = (DatabaseFolder)shuttleEntry.folderInstance.getDescriptor();
                n = (int)(databaseFolder.getWeight() - databaseFolder2.getWeight());
                if (n == 0) {
                    n = this.toString().compareTo(shuttleEntry.toString());
                }
            }
            return n;
        }
    }
}

