/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.IProcessMonitor;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;

public class AsynchronousViewerRunner
implements IProcessMonitor {
    private AsynchronousViewerEditor viewer;
    private URL url;
    private boolean pinned;
    private Timer timer = new Timer();
    private TimerTask refreshTask;
    private boolean shown;

    public AsynchronousViewerRunner(URL uRL, boolean bl) {
        assert (uRL != null);
        this.url = uRL;
        this.pinned = bl;
    }

    public void show() {
        this.setUpViewListener(this.url, this.pinned);
        SwingUtilities.invokeLater(() -> {
            try {
                this.shown = true;
                IdentifierDefinitionLookup.goTo(this.url, false);
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        });
    }

    public void refresh() {
        if (!this.shown) {
            this.show();
        } else if (this.getViewer() != null) {
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
            }
            this.refreshTask = new TimerTask(){

                @Override
                public void run() {
                    Node node = AsynchronousViewerRunner.this.getViewer().getContext().getNode();
                    if (node instanceof ViewerNode) {
                        try {
                            Connections.getInstance().getConnection(((ViewerNode)node).getDBObject().getConnectionName());
                        }
                        catch (Exception exception) {
                            Logger.ignore(this.getClass(), (Throwable)exception);
                        }
                    }
                    AsynchronousViewerRunner.this.getViewer().update(node, new UpdateMessage(ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID, (Object)node));
                }
            };
            this.timer.schedule(this.refreshTask, 3000L);
        }
    }

    private AsynchronousViewerEditor getViewer() {
        return this.viewer;
    }

    private void setViewer(AsynchronousViewerEditor asynchronousViewerEditor) {
        this.viewer = asynchronousViewerEditor;
    }

    private void setUpViewListener(final URL uRL, final boolean bl) {
        Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent activeViewEvent) {
                this.checkView(activeViewEvent.getNewView());
            }

            private void checkView(View view) {
                ViewerNode viewerNode;
                URL uRL2;
                AsynchronousViewerEditor asynchronousViewerEditor;
                Node node;
                if (view instanceof AsynchronousViewerEditor && (node = (asynchronousViewerEditor = (AsynchronousViewerEditor)view).getContext().getNode()) instanceof ViewerNode && uRL.equals(uRL2 = (viewerNode = (ViewerNode)node).getBaseNode().getURL())) {
                    Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
                    AsynchronousViewerRunner.this.setViewer(asynchronousViewerEditor);
                    viewerNode.setPinned(bl);
                    asynchronousViewerEditor.checkPin();
                }
            }
        });
    }
}

