/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.util.Resource;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class TransientURLFileSystemHelper
extends URLFileSystemHelper {
    static final Logger LOGGER = Logger.getLogger(TransientURLFileSystemHelper.class.getName());
    public static final String PROTOCOL = "sqldev.temp";
    private static Map<String, URL> s_backers = new HashMap<String, URL>();

    static URL createTransientURL(String string) {
        URL uRL = URLFactory.newDirURL((String)PROTOCOL, (String)"/tmp/");
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)string);
        String string2 = uRL2.getPath();
        if (!s_backers.containsKey(string2)) {
            int n;
            String string3 = "";
            if (string != null && (n = string.lastIndexOf(46)) >= 0) {
                string3 = string.substring(n);
            }
            try {
                File file = File.createTempFile("bck", string3, Resource.RAPTOR_USER_TEMP);
                file.deleteOnExit();
                s_backers.put(string2, URLFactory.newFileURL((File)file));
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.severe(malformedURLException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                LOGGER.severe(iOException.getLocalizedMessage());
            }
        }
        return uRL2;
    }

    static URL getBackingURL(URL uRL) {
        String string = uRL.getPath();
        URL uRL2 = s_backers.get(string);
        return uRL2;
    }

    public long lastModified(URL uRL) {
        URL uRL2 = TransientURLFileSystemHelper.getBackingURL(uRL);
        return uRL2 != null ? URLFileSystem.lastModified((URL)uRL2) : 0L;
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        URL uRL2 = TransientURLFileSystemHelper.getBackingURL(uRL);
        if (uRL2 == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return URLFileSystem.openInputStream((URL)uRL2);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        URL uRL2 = TransientURLFileSystemHelper.getBackingURL(uRL);
        if (uRL2 == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return URLFileSystem.openOutputStream((URL)uRL2);
    }

    public boolean exists(URL uRL) {
        return s_backers.get(uRL.getPath()) != null;
    }

    public boolean isReadOnly(URL uRL) {
        return false;
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        return bl ? null : uRL.getPath();
    }

    public boolean isDirectory(URL uRL) {
        return super.isDirectory(uRL);
    }
}

