/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.List;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DBTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.WeakCache;

public final class DatabaseNavigatorElementFactory {
    private static final String BODY_TAG = "BODY";
    private static WeakCache<URL, Folder> s_typeFolders = new WeakCache();
    private static ThreadLocal<Boolean> reportError = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    private DatabaseNavigatorElementFactory() {
    }

    public static Folder getTypeFolder(URL uRL, DBFolderInstance dBFolderInstance) {
        Folder folder = (Folder)s_typeFolders.get((Object)uRL);
        if (folder == null) {
            DatabaseFolder databaseFolder = dBFolderInstance != null ? (DatabaseFolder)dBFolderInstance.getDescriptor() : null;
            folder = DatabaseNavigatorElementFactory.createTypeFolderImpl(uRL, databaseFolder);
        }
        if (folder instanceof ObjectFolder) {
            if (dBFolderInstance == null) {
                dBFolderInstance = DatabaseNavigatorElementFactory.loadFolderInstance(uRL);
            }
            ((ObjectFolder)folder).setFolderInstance(dBFolderInstance);
        }
        s_typeFolders.put((Object)uRL, (Object)folder);
        return folder;
    }

    private static Folder createTypeFolderImpl(URL uRL, DatabaseFolder databaseFolder) {
        ObjectFolder objectFolder;
        block6: {
            Class<? extends Element> clazz;
            objectFolder = null;
            if (databaseFolder != null && (clazz = databaseFolder.getImplementationClass()) != null) {
                assert (Folder.class.isAssignableFrom(clazz));
                try {
                    Folder folder = (Folder)clazz.newInstance();
                    if (Locatable.class.isAssignableFrom(clazz)) {
                        ((Locatable)folder).setURL(uRL);
                    }
                    objectFolder = folder;
                }
                catch (Exception exception) {
                    if (!DatabaseNavigatorElementFactory.isReportError().booleanValue()) break block6;
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
        }
        if (objectFolder == null) {
            objectFolder = new ObjectFolder(uRL);
        }
        return objectFolder;
    }

    private static DBFolderInstance loadFolderInstance(URL uRL) {
        String string = DBURLFormatHelper.getConnectionName(uRL);
        String string2 = DBURLFormatHelper.getCatalog(uRL);
        String string3 = DBURLFormatHelper.getSchema(uRL);
        String string4 = DBURLFormatHelper.getBaseType(uRL);
        ObjectFactory objectFactory = DatabaseNavigatorElementFactory.getFactory(uRL);
        if (objectFactory != null) {
            String string5;
            DBTypeOwnerInstance dBItemInstance = objectFactory.createSchemaInstance(string3);
            if (string2 != null) {
                dBItemInstance.setProperty("CATALOG", string2);
            }
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
            ObjectCategory objectCategory = objectFactory.getParentCategoryForType(string4);
            while (objectCategory != null) {
                string5 = objectCategory.getType();
                arrayDeque.add(string5);
                objectCategory = objectFactory.getParentCategoryForCategory(string5);
            }
            string5 = (String)arrayDeque.poll();
            while (string5 != null) {
                for (CategoryInstance dBItemInstance2 : dBItemInstance.listCategories()) {
                    if (!ModelUtil.areEqual((Object)dBItemInstance2.getDescriptor().getType(), (Object)string5)) continue;
                    dBItemInstance = dBItemInstance2;
                    break;
                }
                string5 = (String)arrayDeque.poll();
            }
            for (DBFolderInstance dBFolderInstance : dBItemInstance.listTypeFolders()) {
                if (!ModelUtil.areEqual((Object)dBFolderInstance.getType(), (Object)string4)) continue;
                return dBFolderInstance;
            }
        }
        return null;
    }

    public static DatabaseNode getObjectNode(URL uRL) {
        DatabaseNode databaseNode;
        block15: {
            databaseNode = null;
            String string = DBURLFormatHelper.getConnectionName(uRL);
            ObjectFactory objectFactory = DatabaseNavigatorElementFactory.getFactory(uRL);
            if (objectFactory != null) {
                String string2 = DBURLFormatHelper.getBaseType(uRL);
                String string3 = DBURLFormatHelper.getName(uRL);
                if (string2 == null) {
                    return null;
                }
                URL uRL2 = DBURLFormatHelper.getEnclosingURL(uRL);
                if (uRL2 != null) {
                    try {
                        DBObjectInstance dBObjectInstance;
                        DatabaseObject databaseObject;
                        ChildType childType;
                        DatabaseNode databaseNode2 = DatabaseNavigatorElementFactory.getObjectNode(uRL2);
                        if (databaseNode2 == null) break block15;
                        if ("PACKAGE BODY".equals(string2) || "TYPE BODY".equals(string2)) {
                            string2 = BODY_TAG;
                        }
                        if ((childType = (databaseObject = (DatabaseObject)(dBObjectInstance = databaseNode2.getNodeInstance()).getDescriptor()).getChildType(string2)) != null) {
                            List<DBChildInstance> list;
                            if (childType.showAsFolder()) {
                                DatabaseFolder databaseFolder;
                                DBFolderInstance dBFolderInstance;
                                DatabaseFolder[] databaseFolderArray;
                                ObjectType objectType;
                                String string4 = childType.getNodeType();
                                if (string4 != null && (objectType = objectFactory.getObjectType(string4)) != null && (databaseFolderArray = objectType.getFolders()) != null && databaseFolderArray.length > 0 && (dBFolderInstance = objectFactory.createFolderInstance(string4, databaseFolder = databaseFolderArray[0])) != null) {
                                    for (String object : dBObjectInstance.getPropertyKeys()) {
                                        Object object2 = dBObjectInstance.getProperty(object);
                                        String string5 = "TYPE".equals(object) ? "PARENT_TYPE" : ("NAME".equals(object) ? "PARENT_NAME" : object);
                                        dBFolderInstance.setProperty(string5, object2);
                                    }
                                    List<? extends DBObjectInstance> list2 = dBFolderInstance.getChildren(new String[]{string3}, true);
                                    if (list2 != null && list2.size() > 0) {
                                        DBObjectInstance dBObjectInstance2 = (DBObjectInstance)list2.get(0);
                                        databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL, dBObjectInstance2);
                                    }
                                }
                            } else if (string3 != null && (list = dBObjectInstance.listChildren(string2)) != null) {
                                for (DBChildInstance dBChildInstance : list) {
                                    String string5 = (String)dBChildInstance.getProperty("NAME");
                                    if (!string3.equals(string5)) continue;
                                    databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL, (DBObjectInstance)dBChildInstance);
                                }
                            }
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        if (DatabaseNavigatorElementFactory.isReportError().booleanValue()) {
                            ExceptionHandler.handleException((Throwable)exception);
                        }
                        break block15;
                    }
                }
                databaseNode = DatabaseNavigatorElementFactory.createNodeByType(uRL, string2, objectFactory);
            }
        }
        return databaseNode;
    }

    private static Connection getConnection(String string) {
        Connection connection;
        block2: {
            connection = null;
            try {
                connection = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                if (!DatabaseNavigatorElementFactory.isReportError().booleanValue()) break block2;
                ExceptionHandler.handleException((Throwable)dBException);
            }
        }
        return connection;
    }

    private static ObjectFactory getFactory(URL uRL) {
        String string = uRL.getProtocol();
        String string2 = DBURLFormatHelper.getConnectionName(uRL);
        ObjectFactory objectFactory = null;
        Connection connection = DatabaseNavigatorElementFactory.getConnection(string2);
        if (connection != null) {
            ObjectFactoryRegistry objectFactoryRegistry = ObjectFactoryRegistry.getRegistry(string);
            objectFactory = objectFactoryRegistry.getFactory(string2, connection);
        }
        return objectFactory;
    }

    private static DatabaseNode createNodeByType(URL uRL, String string, ObjectFactory objectFactory) {
        DatabaseFolder[] databaseFolderArray;
        DatabaseNode databaseNode = null;
        ObjectType objectType = objectFactory.getObjectType(string);
        if (objectType != null && (databaseFolderArray = objectType.getFolders()) != null && databaseFolderArray.length > 0) {
            databaseNode = DatabaseNavigatorElementFactory.createNodeFromFolder(uRL, objectFactory, databaseFolderArray[0]);
        }
        return databaseNode;
    }

    private static DatabaseNode createNodeFromFolder(URL uRL, ObjectFactory objectFactory, DatabaseFolder databaseFolder) {
        DatabaseNode databaseNode = null;
        String string = databaseFolder.getType();
        DBFolderInstance dBFolderInstance = objectFactory.createFolderInstance(string, databaseFolder);
        if (dBFolderInstance != null) {
            dBFolderInstance.setProperty("SCHEMA", DBURLFormatHelper.getSchema(uRL));
            dBFolderInstance.setProperty("CATALOG", DBURLFormatHelper.getCatalog(uRL));
            try {
                List<? extends DBObjectInstance> list = dBFolderInstance.getChildren(new String[]{DBURLFormatHelper.getName(uRL)}, true);
                if (list.size() > 0) {
                    databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL, list.get(0));
                }
            }
            catch (SQLException sQLException) {
                if (DatabaseNavigatorElementFactory.isReportError().booleanValue()) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }
        return databaseNode;
    }

    public static DatabaseNode createObjectNode(URL uRL, DBObjectInstance dBObjectInstance) {
        DatabaseNode databaseNode = null;
        String string = (String)dBObjectInstance.getProperty("INTERNAL_NAME");
        if (string == null) {
            string = (String)dBObjectInstance.getProperty("NAME");
        }
        if (string != null) {
            String string2 = DBURLFormatHelper.getSchema(uRL);
            String string3 = (String)dBObjectInstance.getProperty("SCHEMA");
            URL uRL2 = string3 != null && ModelUtil.areDifferent((Object)string2, (Object)string3) ? DBURLFormatHelper.getURL(DBURLFormatHelper.getURL(uRL.getProtocol(), DBURLFormatHelper.getConnectionName(uRL), DBURLFormatHelper.getCatalog(uRL), string3, DBURLFormatHelper.getBaseType(uRL)), string) : DBURLFormatHelper.getURL(uRL, string);
            databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL2, dBObjectInstance);
        }
        return databaseNode;
    }

    private static DatabaseNode createObjectNodeImpl(URL uRL, DBObjectInstance dBObjectInstance) {
        DatabaseNode databaseNode;
        block4: {
            databaseNode = null;
            try {
                DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
                Class<? extends Element> clazz = databaseObject.getImplementationClass();
                if (clazz == null) {
                    clazz = ObjectNode.class;
                }
                assert (Node.class.isAssignableFrom(clazz));
                databaseNode = (DatabaseNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
                databaseNode.setNodeInstance(dBObjectInstance);
            }
            catch (Exception exception) {
                if (!DatabaseNavigatorElementFactory.isReportError().booleanValue()) break block4;
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        return databaseNode;
    }

    public static Element createChildElement(URL uRL, String string, DBChildInstance dBChildInstance) {
        DatabaseItem databaseItem = dBChildInstance.getDescriptor();
        if (databaseItem instanceof DatabaseObject) {
            URL uRL2 = DBURLFormatHelper.getEnclosedTypeURL(uRL, databaseItem.getType());
            return DatabaseNavigatorElementFactory.createObjectNode(uRL2, (DBObjectInstance)dBChildInstance);
        }
        String string2 = (String)dBChildInstance.getProperty("NAME");
        URL uRL3 = DBURLFormatHelper.getChildURL(uRL, string, string2);
        return new ChildObjectElement(uRL3, dBChildInstance);
    }

    public static void setReportError(Boolean bl) {
        reportError.set(bl);
    }

    public static Boolean isReportError() {
        return reportError.get();
    }
}

