/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.xml.AbstractChildInstance;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.OffsetMark;

public class ChildObjectElement
extends DefaultElement
implements Locatable,
Subject {
    private URL m_url;
    private DBChildInstance m_impl;
    private IdeSubject m_proxy;

    public ChildObjectElement(URL uRL, DBChildInstance dBChildInstance) {
        this.setURL(uRL);
        this.m_impl = dBChildInstance;
    }

    public OffsetMark getOffsetMark() {
        if (this.m_impl instanceof AbstractChildInstance) {
            return ((AbstractChildInstance)this.m_impl).offsetMark;
        }
        return null;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    public String getShortLabel() {
        return DBURLFormatHelper.getChildName(this.m_url);
    }

    public String getLongLabel() {
        String string = (String)this.m_impl.getProperty("LONG_LABEL");
        if (string == null || "".equals(string)) {
            return super.getLongLabel();
        }
        return string;
    }

    public String getToolTipText() {
        String string = (String)this.m_impl.getProperty("TOOLTIP");
        if (string == null || "".equals(string)) {
            return super.getLongLabel();
        }
        return string;
    }

    public Icon getIcon() {
        Icon icon = null;
        ConnectionTypeDetails connectionTypeDetails = this.m_impl.getObjectFactory().getConnectionTypeDescriptor().getImpl();
        if (connectionTypeDetails != null) {
            icon = connectionTypeDetails.getIcon(this.m_impl);
        }
        if (icon == null) {
            String string = (String)this.m_impl.getProperty("MEMBER_TYPE");
            boolean bl = false;
            try {
                bl = (Boolean)this.m_impl.getProperty("MEMBER_PRIVATE_VISIBILITY_KEY");
            }
            catch (Exception exception) {
                // empty catch block
            }
            icon = Member.getIcon(string, bl);
        }
        if (icon == null) {
            icon = this.m_impl.getDescriptor().getIcon();
        }
        return icon;
    }

    public Object getProperty(String string) {
        return this.m_impl.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.m_impl.setProperty(string, object);
    }

    public void attach(Observer observer) {
        if (this.m_proxy == null) {
            this.m_proxy = new IdeSubject();
        }
        this.m_proxy.attach(observer);
    }

    public void detach(Observer observer) {
        if (this.m_proxy != null) {
            this.m_proxy.detach(observer);
        }
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (this.m_proxy != null) {
            this.m_proxy.notifyObservers(object, updateMessage);
        }
    }
}

