/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.util.Properties;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.util.ModelUtil;

public final class FoldersConnectionPropertiesUpdater
implements ConnectionPropertiesUpdater {
    private String m_storeID;

    private String createQualifiedConnectionName(String string) {
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(this.m_storeID, string);
        return connectionKey.getQualifiedName();
    }

    @Override
    public void processForExport(String string, Properties properties) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        TreePath treePath = databasesFolderCache.getFolder("sqldev.nav", this.createQualifiedConnectionName(string));
        if (treePath != null) {
            properties.put("NAV_FOLDER", DatabasesFolderCache.convertToEncodedPath(treePath));
        }
    }

    @Override
    public void processForImport(String string, Properties properties, boolean bl) {
        TreePath treePath;
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        String string2 = this.createQualifiedConnectionName(string);
        TreePath treePath2 = databasesFolderCache.getFolder("sqldev.nav", string2);
        String string3 = properties.getProperty("NAV_FOLDER");
        TreePath treePath3 = treePath = string3 != null ? DatabasesFolderCache.createTreePath(string3) : null;
        if (ModelUtil.areDifferent((Object)treePath2, (Object)treePath)) {
            if (treePath2 != null) {
                if (treePath != null) {
                    databasesFolderCache.updateFolder("sqldev.nav", string2, treePath);
                } else {
                    databasesFolderCache.removeFolder("sqldev.nav", string2);
                }
            } else {
                databasesFolderCache.addFolder("sqldev.nav", string2, treePath);
            }
        }
        if (string3 != null) {
            properties.remove("NAV_FOLDER");
        }
    }

    @Override
    public void setConnectionStore(String string) {
        if (ModelUtil.areDifferent((Object)string, (Object)this.m_storeID)) {
            this.m_storeID = string;
        }
    }
}

