/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.folders.FolderNamePanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.Ide;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class FolderSelectionPanel
extends DialogTraversable {
    private static final String PATHS_KEY = "ExistingPaths";
    private static final String SELECTED_KEY = "SelectedPath";
    private static final String MODE_KEY = "PathMode";
    private JTree mTreeFolders = new JTree();
    private boolean isFolder;

    static TreePath getFolder(TreePath[] treePathArray, TreePath treePath, boolean bl) {
        Namespace namespace = new Namespace();
        namespace.put(PATHS_KEY, (Object)treePathArray);
        namespace.put(SELECTED_KEY, (Object)treePath);
        namespace.put(MODE_KEY, (Object)(bl ? Mode.FOLDER : Mode.CONNECTION));
        FolderSelectionPanel folderSelectionPanel = new FolderSelectionPanel();
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), DatabaseNavigatorResources.getString("TITLE_SELECT_FOLDER"), (Traversable)folderSelectionPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog();
        TreePath treePath2 = null;
        if (tDialogLauncher.showDialog()) {
            treePath2 = (TreePath)namespace.get(SELECTED_KEY);
        }
        return treePath2;
    }

    public String getHelpID() {
        return null;
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mTreeFolders, (String)DatabaseNavigatorResources.getString("LABEL_SELECT_FOLDER"));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        JComponent jComponent = new JButton();
        ((AbstractButton)jComponent).setIcon(OracleIcons.getIcon((String)"folderNew.png"));
        jComponent.setToolTipText(DatabaseNavigatorResources.getString("TOOLTIP_ADD_FOLDER"));
        ((AbstractButton)jComponent).setMargin(new Insets(1, 1, 1, 1));
        ((AbstractButton)jComponent).addActionListener(actionEvent -> this.addFolder());
        jToolBar.add(jComponent);
        this.mTreeFolders.getSelectionModel().setSelectionMode(1);
        this.mTreeFolders.setRootVisible(false);
        this.mTreeFolders.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        });
        this.mTreeFolders.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Icon getOpenIcon() {
                return this.getClosedIcon();
            }

            @Override
            public Icon getClosedIcon() {
                return super.getClosedIcon();
            }

            @Override
            public Icon getLeafIcon() {
                return this.getClosedIcon();
            }
        });
        jComponent = new JScrollPane();
        ((JScrollPane)jComponent).setViewportView(this.mTreeFolders);
        ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
        int n = 0;
        int n2 = 0;
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(n2++, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add(Box.createGlue(), LayoutControl.GBC.gbc(n2++, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jToolBar, LayoutControl.GBC.gbc(n2++, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE));
        n2 = 0;
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc(n2, ++n, 3, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    @Override
    public Component getInitialFocusComponent() {
        return this.mTreeFolders;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TreePath treePath = this.getSelection();
        traversableContext.put(SELECTED_KEY, (Object)treePath);
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        TreePath[] treePathArray = (TreePath[])traversableContext.find(PATHS_KEY);
        TreePath treePath = (TreePath)traversableContext.find(SELECTED_KEY);
        this.isFolder = traversableContext.get(MODE_KEY) == Mode.FOLDER;
        MutableTreeNode mutableTreeNode = new TreeBuilder().buildTree(treePathArray != null ? treePathArray : TreeBuilder.LEAF);
        this.mTreeFolders.setModel(new DefaultTreeModel(mutableTreeNode));
        TreePath treePath2 = this.convertFromFolderPath(treePath);
        DialogCallbacks dialogCallbacks = traversableContext.getDialogCallbacks();
        this.mTreeFolders.getSelectionModel().addTreeSelectionListener(treeSelectionEvent -> dialogCallbacks.enableOKButton(this.validateSelection(treeSelectionEvent, treePath2)));
        for (int i = 0; i < this.mTreeFolders.getRowCount(); ++i) {
            this.mTreeFolders.expandRow(i);
        }
        SwingUtilities.invokeLater(() -> this.mTreeFolders.setSelectionPath(treePath2));
    }

    boolean validateSelection(TreeSelectionEvent treeSelectionEvent, TreePath treePath) {
        boolean bl = false;
        TreePath treePath2 = treeSelectionEvent.getNewLeadSelectionPath();
        if (!(treePath2 == null || this.isFolder && treePath != null && treePath.isDescendant(treePath2))) {
            bl = true;
        }
        return bl;
    }

    private void addFolder() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mTreeFolders.getModel();
        TreePath treePath = this.mTreeFolders.getSelectionPath();
        if (treePath == null) {
            treePath = new TreePath(defaultTreeModel.getRoot());
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        int n = defaultTreeModel.getChildCount(mutableTreeNode);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = defaultTreeModel.getChild(mutableTreeNode, i).toString();
        }
        String string = FolderNamePanel.getFolderName(stringArray, null);
        if (string != null) {
            int n2;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            for (n2 = 0; n2 < stringArray.length && string.compareTo(stringArray[n2]) >= 0; ++n2) {
            }
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, n2);
            this.mTreeFolders.expandPath(treePath);
            TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
            this.mTreeFolders.setSelectionPath(treePath2);
        }
    }

    private TreePath convertFromFolderPath(TreePath treePath) {
        TreePath treePath2 = null;
        if (treePath != null) {
            TreeNode treeNode = (TreeNode)this.mTreeFolders.getModel().getRoot();
            treePath2 = new TreePath(treeNode);
            int n = treePath.getPathCount();
            block0: for (int i = 0; i < n; ++i) {
                String string = treePath.getPathComponent(i).toString();
                int n2 = treeNode.getChildCount();
                for (int j = 0; j < n2; ++j) {
                    TreeNode treeNode2 = treeNode.getChildAt(j);
                    if (!string.equals(treeNode2.toString())) {
                        continue;
                    }
                    treePath2 = treePath2.pathByAddingChild(treeNode2);
                    treeNode = treeNode2;
                    continue block0;
                }
            }
        }
        return treePath2;
    }

    private TreePath getSelection() {
        int n;
        TreePath treePath = null;
        TreePath treePath2 = this.mTreeFolders.getSelectionPath();
        if (treePath2 != null && (n = treePath2.getPathCount()) > 0) {
            Object[] objectArray = new String[n - 1];
            for (int i = 1; i < n; ++i) {
                objectArray[i - 1] = treePath2.getPathComponent(i).toString();
            }
            treePath = new TreePath(objectArray);
        }
        return treePath;
    }

    private static final class TreeBuilder {
        private static final String ROOT_LABEL = "";
        private static final TreePath ROOT = new TreePath("");
        private static final TreePath[] LEAF = new TreePath[0];
        Map<TreePath, Set<TreePath>> folders = new HashMap<TreePath, Set<TreePath>>();

        private TreeBuilder() {
        }

        void processPath(TreePath treePath) {
            String string = treePath.getLastPathComponent().toString();
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 == null) {
                treePath2 = ROOT;
            } else {
                this.processPath(treePath2);
            }
            Set<TreePath> set = this.folders.get(treePath2);
            if (set == null) {
                set = new HashSet<TreePath>();
                this.folders.put(treePath2, set);
            }
            set.add(treePath);
        }

        TreePath[] getChildren(TreePath treePath3) {
            TreePath[] treePathArray;
            Set<TreePath> set = this.folders.get(treePath3);
            TreePath[] treePathArray2 = treePathArray = set != null ? set.toArray(LEAF) : LEAF;
            if (treePathArray.length > 1) {
                Arrays.sort(treePathArray, (treePath, treePath2) -> treePath.getLastPathComponent().toString().compareTo(treePath2.getLastPathComponent().toString()));
            }
            return treePathArray;
        }

        MutableTreeNode buildNode(TreePath treePath) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(treePath.getLastPathComponent().toString());
            for (TreePath treePath2 : this.getChildren(treePath)) {
                defaultMutableTreeNode.add(this.buildNode(treePath2));
            }
            return defaultMutableTreeNode;
        }

        MutableTreeNode buildRoot() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ROOT_LABEL);
            for (TreePath treePath : this.getChildren(ROOT)) {
                defaultMutableTreeNode.add(this.buildNode(treePath));
            }
            return defaultMutableTreeNode;
        }

        MutableTreeNode buildTree(TreePath[] treePathArray) {
            for (TreePath treePath : treePathArray) {
                if (treePath == null) continue;
                this.processPath(treePath);
            }
            return this.buildRoot();
        }
    }

    private static enum Mode {
        FOLDER,
        CONNECTION;

    }
}

