/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.common.util.Arrays;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.folders.ConnectionFolderOwnerTreeNode;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.FolderNamePanel;
import oracle.dbtools.raptor.navigator.folders.FolderSelectionPanel;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class DatabasesFoldersController
implements Controller {
    public static final String CONNECTION_CATEGORY = "DatabaseNavigator.CategorizeConnection";
    public static final int CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CategorizeConnection");
    public static final String REMOVE_CONNECTION_CATEGORY = "DatabaseNavigator.RemoveCategory";
    public static final int REMOVE_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveCategory");
    public static final String REMOVE_FROM_FOLDER = "DatabaseNavigator.RemoveConnFromFolder";
    public static final int REMOVE_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveConnFromFolder");
    public static final String RENAME_CONNECTION_CATEGORY = "DatabaseNavigator.RenameCategory";
    public static final int RENAME_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RenameCategory");
    public static final String DISCONNECT_CONNECTION_FROM_FOLDER = "DatabaseNavigator.Disconn_Database";
    public static final int DISCONNECT_CONNECTION_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.Disconn_Database");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        Element[] elementArray = context.getSelection();
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext(context);
        if (navigatorTreeNode == null) {
            return false;
        }
        NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
        if (CONNECTION_CATEGORY_ID == n) {
            ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode2 = (ConnectionFolderOwnerTreeNode)navigatorTreeNode.findAncestorTreeNode(ConnectionFolderOwner.class, true);
            DatabasesFolder databasesFolder = navigatorTreeNode.findAncestorElement(DatabasesFolder.class, false);
            TreePath[] treePathArray = this.fetch(connectionFolderOwnerTreeNode2, true, connectionFolderOwnerTreeNode -> connectionFolderOwnerTreeNode.getFolderNames(), new TreePath[0]);
            TreePath treePath = FolderSelectionPanel.getFolder(treePathArray, databasesFolder != null ? connectionFolderOwnerTreeNode2.getTreePath(databasesFolder) : null, !(elementArray[0] instanceof IConnectionNode));
            if (treePath != null) {
                connectionFolderOwnerTreeNode2.updateFolder(navigatorTree, treePath, elementArray);
            }
            bl = true;
        } else if (REMOVE_FROM_FOLDER_ID == n) {
            ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode3 = (ConnectionFolderOwnerTreeNode)navigatorTreeNode.findAncestorTreeNode(ConnectionFolderOwner.class, true);
            connectionFolderOwnerTreeNode3.updateFolder(navigatorTree, null, elementArray);
            bl = true;
        } else if (RENAME_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode4 = (ConnectionFolderOwnerTreeNode)navigatorTreeNode.findAncestorTreeNode(ConnectionFolderOwner.class, true);
            String string = databasesFolder.getName();
            String[] stringArray = this.fetch(connectionFolderOwnerTreeNode4, true, connectionFolderOwnerTreeNode -> connectionFolderOwnerTreeNode.getSiblingNames(databasesFolder), new String[0]);
            String string2 = FolderNamePanel.getFolderName(stringArray, string);
            if (string2 != null) {
                connectionFolderOwnerTreeNode4.renameFolder(databasesFolder, string2);
            }
            bl = true;
        } else if (REMOVE_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode5 = (ConnectionFolderOwnerTreeNode)navigatorTreeNode.findAncestorTreeNode(ConnectionFolderOwner.class, true);
            connectionFolderOwnerTreeNode5.removeFolder(databasesFolder);
            bl = true;
        } else if (n == DISCONNECT_CONNECTION_FROM_FOLDER_ID) {
            Object object;
            String string = (String)ideAction.getValue("Name");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (elementArray[0] instanceof ConnectionFolderOwner) {
                arrayList.addAll(this.getConnections((ConnectionFolderOwner)elementArray[0]));
            } else if (elementArray[0] instanceof DatabasesFolder) {
                object = (DatabasesFolder)elementArray[0];
                arrayList.addAll(this.getConnections((DatabasesFolder)((Object)object)));
            }
            if (arrayList.size() > 0) {
                object = new CloseTask(string, arrayList.toArray(new String[0]));
                object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString("CONN_CLOSED_LABEL"), null, null);
                            }
                        });
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)object);
            }
            bl = true;
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RENAME_CONNECTION_CATEGORY_ID || n == REMOVE_CONNECTION_CATEGORY_ID || n == REMOVE_FROM_FOLDER_ID) {
            return true;
        }
        if (n == DISCONNECT_CONNECTION_FROM_FOLDER_ID) {
            Element element = context.getElement();
            ideAction.setEnabled(this.isAnyconnectionOpen(element));
            return true;
        }
        return false;
    }

    private List<String> getConnections(DatabasesFolder databasesFolder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = databasesFolder.getChildren();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element instanceof IConnectionNode) {
                arrayList.add(((IConnectionNode)element).getQualifiedConnectionName());
                continue;
            }
            if (!(element instanceof DatabasesFolder)) continue;
            arrayList.addAll(this.getConnections((DatabasesFolder)element));
        }
        return arrayList;
    }

    private List<String> getConnections(ConnectionFolderOwner connectionFolderOwner) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = connectionFolderOwner.getChildren();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof IConnectionNode)) continue;
            arrayList.add(((IConnectionNode)element).getQualifiedConnectionName());
        }
        return arrayList;
    }

    private boolean isAnyconnectionOpen(Element element) {
        block3: {
            block2: {
                if (!(element instanceof ConnectionFolderOwner)) break block2;
                ConnectionFolderOwner connectionFolderOwner = (ConnectionFolderOwner)element;
                Iterator iterator = connectionFolderOwner.getChildren();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    if (!(element2 instanceof IConnectionNode) || !Connections.getInstance().isConnectionOpen(((IConnectionNode)element2).getQualifiedConnectionName())) continue;
                    return true;
                }
                break block3;
            }
            if (!(element instanceof DatabasesFolder)) break block3;
            DatabasesFolder databasesFolder = (DatabasesFolder)element;
            Iterator iterator = databasesFolder.getChildren();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                if ((!(element3 instanceof IConnectionNode) || !Connections.getInstance().isConnectionOpen(((IConnectionNode)element3).getQualifiedConnectionName())) && (!(element3 instanceof DatabasesFolder) || !this.isAnyconnectionOpen(element3))) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T[] fetch(ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode, boolean bl, Fetcher<T> fetcher, T[] TArray) {
        NavigatorTreeNode navigatorTreeNode;
        HashSet hashSet = new HashSet(Arrays.asSet((Object[])TArray));
        hashSet.addAll(Arrays.asSet((Object[])fetcher.fetch(connectionFolderOwnerTreeNode)));
        if (bl && (navigatorTreeNode = (NavigatorTreeNode)connectionFolderOwnerTreeNode.getParent()) != null) {
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                NavigatorTreeNode navigatorTreeNode2 = iterator.next();
                if (navigatorTreeNode2 == connectionFolderOwnerTreeNode || !(navigatorTreeNode2 instanceof ConnectionFolderOwnerTreeNode)) continue;
                hashSet.addAll(Arrays.asSet((Object[])fetcher.fetch((ConnectionFolderOwnerTreeNode)navigatorTreeNode2)));
            }
        }
        return hashSet.toArray(TArray);
    }

    private static interface Fetcher<T> {
        public T[] fetch(ConnectionFolderOwnerTreeNode var1);
    }

    private static class CloseTask
    extends RaptorTask<Void> {
        private String[] m_conns;

        CloseTask(String string, String[] stringArray) {
            super(string, false, IRaptorTaskRunMode.TASKVIEWER);
            this.m_conns = stringArray;
        }

        protected Void doWork() throws TaskException {
            Connections connections = Connections.getInstance();
            for (String string : this.m_conns) {
                if (!connections.isConnectionOpen(string)) continue;
                connections.closeConnection(string, true);
            }
            return null;
        }
    }
}

